/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.exporter;

import conexp.fx.core.collections.relation.MatrixRelation;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;

public class CXTExporter<G, M> {
    public static <G, M> void export(MatrixRelation<G, M> context, Map<Integer, Integer> domainPermutation, Map<Integer, Integer> codomainPermutation, File file) {
        try {
            Object object;
            int domainIndex;
            if (!file.exists()) {
                if (!file.getParentFile().exists()) {
                    file.mkdirs();
                }
                file.createNewFile();
            }
            BufferedWriter outputWriter = new BufferedWriter(new FileWriter(file));
            outputWriter.append("B\r\n");
            outputWriter.append("\r\n");
            outputWriter.append(context.rowHeads().size() + "\r\n");
            outputWriter.append(context.colHeads().size() + "\r\n");
            outputWriter.append("\r\n");
            for (domainIndex = 0; domainIndex < context.rowHeads().size(); ++domainIndex) {
                object = context.rowHeads().get(domainPermutation.containsKey(domainIndex) ? domainPermutation.get(domainIndex) : domainIndex);
                outputWriter.append(object + "\r\n");
            }
            for (int codomainIndex = 0; codomainIndex < context.colHeads().size(); ++codomainIndex) {
                Object attribute = context.colHeads().get(codomainPermutation.containsKey(codomainIndex) ? codomainPermutation.get(codomainIndex) : codomainIndex);
                outputWriter.append(attribute + "\r\n");
            }
            for (domainIndex = 0; domainIndex < context.rowHeads().size(); ++domainIndex) {
                object = context.rowHeads().get(domainPermutation.containsKey(domainIndex) ? domainPermutation.get(domainIndex) : domainIndex);
                for (int codomainIndex = 0; codomainIndex < context.colHeads().size(); ++codomainIndex) {
                    Object attribute = context.colHeads().get(codomainPermutation.containsKey(codomainIndex) ? codomainPermutation.get(codomainIndex) : codomainIndex);
                    outputWriter.append(context.contains(object, attribute) ? "X" : ".");
                }
                outputWriter.append("\r\n");
            }
            outputWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static <G, M> void export(MatrixRelation<G, M> formalContext, File file) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter outputWriter = new BufferedWriter(new FileWriter(file));
            outputWriter.append("B\r\n");
            outputWriter.append("\r\n");
            outputWriter.append(formalContext.rowHeads().size() + "\r\n");
            outputWriter.append(formalContext.colHeads().size() + "\r\n");
            outputWriter.append("\r\n");
            for (Object object : formalContext.rowHeads()) {
                outputWriter.append(object + "\r\n");
            }
            for (Object attribute : formalContext.colHeads()) {
                outputWriter.append(attribute + "\r\n");
            }
            for (Object object : formalContext.rowHeads()) {
                for (Object attribute : formalContext.colHeads()) {
                    outputWriter.append(formalContext.contains(object, attribute) ? "X" : ".");
                }
                outputWriter.append("\r\n");
            }
            outputWriter.append("\r\n");
            outputWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

