/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.importer;

import conexp.fx.core.context.MatrixContext;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javafx.geometry.Point3D;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;

public class CFXImporter {
    public static void importt(MatrixContext<String, String> _context, Map<String, Point3D> seedMap, File file) {
        try {
            String attribute;
            Element xml = Jsoup.parse((File)file, null).body();
            Element domain = xml.getElementsByTag("domain").first();
            for (Object objectEl : domain.getElementsByTag("object")) {
                String object = objectEl.attr("name");
                _context.rowHeads().add(object);
            }
            Element codomain = xml.getElementsByTag("codomain").first();
            for (Object attributeEl : codomain.getElementsByTag("attribute")) {
                String attribute2 = attributeEl.attr("name");
                _context.colHeads().add(attribute2);
                if (Boolean.valueOf(attributeEl.attr("selected")).booleanValue()) continue;
                _context.selectedAttributes().remove(attribute2);
            }
            Element context = xml.getElementsByTag("context").first();
            for (Element incidenceEl : context.getElementsByTag("incidence")) {
                String object = incidenceEl.attr("object");
                attribute = incidenceEl.attr("attribute");
                _context.addFast(object, attribute);
            }
            if (seedMap != null) {
                Element lattice = xml.getElementsByTag("lattice").first();
                for (Element seedEl : lattice.getElementsByTag("attribute-seed")) {
                    attribute = seedEl.attr("attribute");
                    Double x = Double.valueOf(seedEl.attr("x"));
                    Double y = Double.valueOf(seedEl.attr("y"));
                    Double z = Double.valueOf(seedEl.attr("z"));
                    Point3D point3d = new Point3D(x.doubleValue(), y.doubleValue(), z.doubleValue());
                    seedMap.put(attribute, point3d);
                }
            }
            _context.pushAllChangedEvent();
        }
        catch (IOException e) {
            System.err.println("Unable to parse ConExpFX file from " + file.toString());
            e.printStackTrace();
        }
    }
}

