/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.layout;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import conexp.fx.core.context.Concept;
import conexp.fx.core.context.ConceptLattice;
import conexp.fx.core.layout.ConceptLayout;
import conexp.fx.core.layout.ConceptMovement;
import conexp.fx.core.math.Points;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javafx.beans.Observable;
import javafx.beans.binding.Binding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.geometry.Point3D;
import org.eclipse.jdt.annotation.Nullable;

public final class AdditiveConceptLayout<G, M>
extends ConceptLayout<G, M, Binding<Point3D>> {
    public final ObservableMap<G, Point3D> seedsG = FXCollections.observableMap(new ConcurrentHashMap());
    public final Map<G, Point3D> seedHistoryG = new ConcurrentHashMap<G, Point3D>();
    public final ObservableMap<M, Point3D> seedsM = FXCollections.observableMap(new ConcurrentHashMap());
    public final Map<M, Point3D> seedHistoryM = new ConcurrentHashMap<M, Point3D>();
    private final Property<Type> type;

    public AdditiveConceptLayout(ConceptLattice<G, M> conceptLattice, @Nullable Map<G, Point3D> initialSeedsG, @Nullable Map<M, Point3D> initialSeedsM, Type type) {
        super(conceptLattice);
        this.type = new SimpleObjectProperty((Object)type);
        this.initializePositionBindings();
        if (initialSeedsG != null) {
            this.seedsG.putAll(initialSeedsG);
        }
        if (initialSeedsM != null) {
            this.seedsM.putAll(initialSeedsM);
        }
    }

    public final void setType(Type type) {
        this.type.setValue((Object)type);
    }

    public final void bindType(ObservableValue<Type> observable) {
        this.type.bind(observable);
    }

    @Override
    protected final Binding<Point3D> newPositionBinding(final Concept<G, M> concept) {
        return new ObjectBinding<Point3D>(){
            {
                if (AdditiveConceptLayout.this.observe) {
                    this.bind(new Observable[]{AdditiveConceptLayout.this.seedsG, concept.extent(), AdditiveConceptLayout.this.seedsM, concept.intent(), AdditiveConceptLayout.this.type});
                } else {
                    this.bind(new Observable[]{AdditiveConceptLayout.this.seedsG, AdditiveConceptLayout.this.seedsM, AdditiveConceptLayout.this.type});
                }
            }

            public final void dispose() {
                if (AdditiveConceptLayout.this.observe) {
                    this.unbind(new Observable[]{AdditiveConceptLayout.this.seedsG, concept.extent(), AdditiveConceptLayout.this.seedsM, concept.intent(), AdditiveConceptLayout.this.type});
                } else {
                    this.unbind(new Observable[]{AdditiveConceptLayout.this.seedsG, AdditiveConceptLayout.this.seedsM, AdditiveConceptLayout.this.type});
                }
                super.dispose();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected final Point3D computeValue() {
                Point3D seed;
                Object object;
                Object object2;
                double x = 0.0;
                double y = 0.0;
                double z = 0.0;
                if (((Type)((Object)AdditiveConceptLayout.this.type.getValue())).equals((Object)Type.HYBRID) || ((Type)((Object)AdditiveConceptLayout.this.type.getValue())).equals((Object)Type.OBJECT)) {
                    object2 = concept.extent();
                    synchronized (object2) {
                        object = AdditiveConceptLayout.this.seedsG;
                        synchronized (object) {
                            for (Object g : Sets.difference((Set)AdditiveConceptLayout.this.seedsG.keySet(), concept.extent())) {
                                seed = (Point3D)AdditiveConceptLayout.this.seedsG.get(g);
                                x += seed.getX();
                                y += seed.getY();
                                z += seed.getZ();
                            }
                        }
                    }
                }
                if (((Type)((Object)AdditiveConceptLayout.this.type.getValue())).equals((Object)Type.HYBRID) || ((Type)((Object)AdditiveConceptLayout.this.type.getValue())).equals((Object)Type.ATTRIBUTE)) {
                    object2 = concept.intent();
                    synchronized (object2) {
                        object = AdditiveConceptLayout.this.seedsM;
                        synchronized (object) {
                            for (Object m : Sets.intersection((Set)AdditiveConceptLayout.this.seedsM.keySet(), concept.intent())) {
                                seed = (Point3D)AdditiveConceptLayout.this.seedsM.get(m);
                                x += seed.getX();
                                y += seed.getY();
                                z += seed.getZ();
                            }
                        }
                    }
                }
                return new Point3D(x, y, z);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean updateSeeds(@Nullable Map<G, Point3D> seedUpdatesG, @Nullable Map<M, Point3D> seedUpdatesM) {
        Object object;
        boolean ret = false;
        if (!this.seedsG.equals(seedUpdatesG)) {
            object = this.seedsG;
            synchronized (object) {
                ret = true;
                this.seedsG.clear();
                if (seedUpdatesG != null) {
                    this.seedsG.putAll(seedUpdatesG);
                }
            }
        }
        if (!this.seedsM.equals(seedUpdatesM)) {
            object = this.seedsM;
            synchronized (object) {
                ret = true;
                this.seedsM.clear();
                if (seedUpdatesM != null) {
                    this.seedsM.putAll(seedUpdatesM);
                }
            }
        }
        this.invalidate();
        return ret;
    }

    public final void normalizeSeeds() {
        double l = 1.0 / Stream.concat(this.seedsG.values().stream(), this.seedsM.values().stream()).map(Point3D::magnitude).reduce(Math::min).orElse(1.0);
        this.seedsG.replaceAll((g, seed) -> seed.multiply(l));
        this.seedsM.replaceAll((m, seed) -> seed.multiply(l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void rotate(double angle) {
        Object object = this.seedsG;
        synchronized (object) {
            this.seedsG.replaceAll((__, seed) -> Points.rotate(seed, angle));
        }
        object = this.seedsM;
        synchronized (object) {
            this.seedsM.replaceAll((__, seed) -> Points.rotate(seed, angle));
        }
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void move(Concept<G, M> concept, ConceptMovement movement, Point3D delta) {
        ObservableMap<G, Point3D> observableMap = this.seedsG;
        synchronized (observableMap) {
            ObservableMap<M, Point3D> observableMap2 = this.seedsM;
            synchronized (observableMap2) {
                double dx = delta.getX();
                double dy = delta.getY();
                double dz = delta.getZ();
                switch (movement) {
                    case LABEL_SEED: {
                        try {
                            Object affectedSeed = Iterators.getOnlyElement((Iterator)Sets.intersection(this.lattice.attributeLabels(concept), (Set)this.seedsM.keySet()).iterator());
                            Point3D seed = (Point3D)this.seedsM.get(affectedSeed);
                            this.seedsM.put(affectedSeed, (Object)new Point3D(seed.getX() + dx, Math.max(0.001, seed.getY() + dy), seed.getZ() + dz));
                        }
                        catch (IllegalArgumentException | NoSuchElementException e) {
                            System.err.println(e.getStackTrace()[0] + " Moving only label seeds, but there was none or more than one! Check this.");
                            System.err.println("\t" + Sets.intersection(this.lattice.attributeLabels(concept), (Set)this.seedsM.keySet()));
                        }
                        break;
                    }
                    case LABEL_CHAIN_SEEDS: {
                        try {
                            Object m = Iterators.getOnlyElement((Iterator)Sets.intersection(this.lattice.attributeLabels(concept), (Set)this.seedsM.keySet()).iterator());
                            final Point3D s = (Point3D)this.seedsM.get(m);
                            HashSet eq = new HashSet(Maps.filterValues(this.seedsM, (Predicate)new Predicate<Point3D>(){

                                public final boolean apply(Point3D p) {
                                    return s.equals((Object)p);
                                }
                            }).keySet());
                            double f = 1.0 / (double)Sets.intersection(eq, concept.intent()).size();
                            Point3D t = new Point3D(s.getX() + f * dx, Math.max(0.1, s.getY() + f * dy), s.getZ() + f * dz);
                            for (Object n : eq) {
                                this.seedsM.put(n, (Object)t);
                            }
                            break;
                        }
                        catch (IllegalArgumentException | NoSuchElementException e) {
                            System.err.println(e.getStackTrace()[0] + " Moving only label seeds, but there was none or more than one! Check this.");
                            System.err.println("\t" + Sets.intersection(this.lattice.attributeLabels(concept), (Set)this.seedsM.keySet()));
                            break;
                        }
                    }
                    case INTENT_SEEDS: 
                    case INTENT_CHAIN_SEEDS: {
                        HashSet affectedSeedsM = new HashSet(Sets.intersection((Set)this.seedsM.keySet(), concept.intent()));
                        HashSet affectedSeedsG = new HashSet(Sets.difference((Set)this.seedsG.keySet(), concept.extent()));
                        Point3D a = Points.absoluteSum(Collections2.transform(affectedSeedsG, arg_0 -> this.seedsG.get(arg_0))).add(Points.absoluteSum(Collections2.transform(affectedSeedsM, arg_0 -> this.seedsM.get(arg_0))));
                        switch (movement) {
                            case INTENT_SEEDS: {
                                Point3D t;
                                double fz;
                                double fy;
                                double fx;
                                Point3D s;
                                if (((Type)((Object)this.type.getValue())).equals((Object)Type.HYBRID) || ((Type)((Object)this.type.getValue())).equals((Object)Type.OBJECT)) {
                                    for (Object g : affectedSeedsG) {
                                        s = (Point3D)this.seedsG.get(g);
                                        fx = a.getX() == 0.0 ? 1.0 / (double)affectedSeedsG.size() : Math.abs(s.getX()) / a.getX();
                                        fy = a.getY() == 0.0 ? 1.0 / (double)affectedSeedsG.size() : Math.abs(s.getY()) / a.getY();
                                        fz = a.getZ() == 0.0 ? 1.0 / (double)affectedSeedsG.size() : Math.abs(s.getZ()) / a.getZ();
                                        t = new Point3D(s.getX() + fx * dx, Math.max(0.1, s.getY() + fy * dy), s.getZ() + fz * dz);
                                        this.seedsG.put(g, (Object)t);
                                    }
                                }
                                if (!((Type)((Object)this.type.getValue())).equals((Object)Type.HYBRID) && !((Type)((Object)this.type.getValue())).equals((Object)Type.ATTRIBUTE)) break;
                                for (Object m : affectedSeedsM) {
                                    s = (Point3D)this.seedsM.get(m);
                                    fx = a.getX() == 0.0 ? 1.0 / (double)affectedSeedsM.size() : Math.abs(s.getX()) / a.getX();
                                    fy = a.getY() == 0.0 ? 1.0 / (double)affectedSeedsM.size() : Math.abs(s.getY()) / a.getY();
                                    fz = a.getZ() == 0.0 ? 1.0 / (double)affectedSeedsM.size() : Math.abs(s.getZ()) / a.getZ();
                                    t = new Point3D(s.getX() + fx * dx, Math.max(0.1, s.getY() + fy * dy), s.getZ() + fz * dz);
                                    this.seedsM.put(m, (Object)t);
                                }
                                break;
                            }
                            case INTENT_CHAIN_SEEDS: {
                                Point3D t;
                                double fz;
                                double fy;
                                double fx;
                                HashSet eq;
                                Point3D s;
                                double size;
                                switch ((Type)((Object)this.type.getValue())) {
                                    case HYBRID: {
                                        size = affectedSeedsG.size() + affectedSeedsM.size();
                                        break;
                                    }
                                    case OBJECT: {
                                        size = affectedSeedsG.size();
                                        break;
                                    }
                                    case ATTRIBUTE: {
                                        size = affectedSeedsM.size();
                                        break;
                                    }
                                    default: {
                                        size = 1.0;
                                    }
                                }
                                if (((Type)((Object)this.type.getValue())).equals((Object)Type.HYBRID) || ((Type)((Object)this.type.getValue())).equals((Object)Type.OBJECT)) {
                                    while (!affectedSeedsG.isEmpty()) {
                                        Object g = Iterables.getFirst(affectedSeedsG, null);
                                        s = (Point3D)this.seedsG.get(g);
                                        eq = new HashSet(Maps.filterValues(this.seedsG, (Predicate)new Predicate<Point3D>(){

                                            public final boolean apply(Point3D p) {
                                                return s.equals((Object)p);
                                            }
                                        }).keySet());
                                        affectedSeedsG.removeAll(eq);
                                        fx = a.getX() == 0.0 ? 1.0 / size : Math.abs(s.getX()) / a.getX();
                                        fy = a.getY() == 0.0 ? 1.0 / size : Math.abs(s.getY()) / a.getY();
                                        fz = a.getZ() == 0.0 ? 1.0 / size : Math.abs(s.getZ()) / a.getZ();
                                        t = new Point3D(s.getX() + fx * dx, Math.max(0.1, s.getY() + fy * dy), s.getZ() + fz * dz);
                                        for (Object h : eq) {
                                            this.seedsG.put(h, (Object)t);
                                        }
                                    }
                                }
                                if (!((Type)((Object)this.type.getValue())).equals((Object)Type.HYBRID) && !((Type)((Object)this.type.getValue())).equals((Object)Type.ATTRIBUTE)) break;
                                while (!affectedSeedsM.isEmpty()) {
                                    Object m = Iterables.getFirst(affectedSeedsM, null);
                                    s = (Point3D)this.seedsM.get(m);
                                    eq = new HashSet(Maps.filterValues(this.seedsM, (Predicate)new Predicate<Point3D>(){

                                        public final boolean apply(Point3D p) {
                                            return s.equals((Object)p);
                                        }
                                    }).keySet());
                                    affectedSeedsM.removeAll(eq);
                                    fx = a.getX() == 0.0 ? 1.0 / size : Math.abs(s.getX()) / a.getX();
                                    fy = a.getY() == 0.0 ? 1.0 / size : Math.abs(s.getY()) / a.getY();
                                    fz = a.getZ() == 0.0 ? 1.0 / size : Math.abs(s.getZ()) / a.getZ();
                                    t = new Point3D(s.getX() + fx * dx, Math.max(0.1, s.getY() + fy * dy), s.getZ() + fz * dz);
                                    for (Object n : eq) {
                                        this.seedsM.put(n, (Object)t);
                                    }
                                }
                                break block11;
                            }
                        }
                        break;
                    }
                }
            }
        }
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void deleteZ() {
        Object object = this.seedsG;
        synchronized (object) {
            this.seedsG.replaceAll((g, seed) -> seed.subtract(0.0, 0.0, seed.getZ()));
        }
        object = this.seedsM;
        synchronized (object) {
            this.seedsM.replaceAll((m, seed) -> seed.subtract(0.0, 0.0, seed.getZ()));
        }
        this.invalidate();
    }

    public final AdditiveConceptLayout<G, M> clone() {
        return new AdditiveConceptLayout<G, M>(this.lattice, this.seedsG, this.seedsM, (Type)((Object)this.type.getValue()));
    }

    public final boolean equals(Object o) {
        return o != null && o instanceof AdditiveConceptLayout && ((AdditiveConceptLayout)o).lattice.equals(this.lattice) && ((AdditiveConceptLayout)o).seedsG.equals(this.seedsG) && ((AdditiveConceptLayout)o).seedsM.equals(this.seedsM);
    }

    public final int hashCode() {
        return 7 * this.lattice.hashCode() + 13 * this.seedsG.hashCode() + 23 * this.seedsM.hashCode();
    }

    public static enum Type {
        ATTRIBUTE("Attribute-Additive"),
        OBJECT("Object-Additive"),
        HYBRID("Hybrid-Additive");

        private final String title;

        private Type(String title) {
            this.title = title;
        }

        public final String toString() {
            return this.title;
        }
    }
}

