/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.layout;

import com.google.common.base.Predicate;
import conexp.fx.core.collections.BitSetFX;
import conexp.fx.core.collections.Collections3;
import conexp.fx.core.collections.relation.MatrixRelation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.ujmp.core.util.RandomSimple;

public final class ChainDecomposer<E> {
    private final MatrixRelation<E, E> neighborhood;
    private final int num;
    private final Random rng = new RandomSimple();

    public ChainDecomposer(MatrixRelation<E, E> neighborhood) {
        this.neighborhood = neighborhood;
        this.num = neighborhood.rowHeads().size();
    }

    public final Set<Set<E>> randomChainDecomposition() {
        BitSetFX available = new BitSetFX();
        available.set(0, this.num);
        HashSet<Set<Set<E>>> chains = new HashSet<Set<Set<E>>>();
        while (!available.isEmpty()) {
            chains.add(this.nextChain(available));
        }
        return chains;
    }

    private final Set<E> nextChain(BitSetFX available) {
        HashSet chain = new HashSet();
        int i = this.nextMinimalElement(available);
        while (i != -1) {
            chain.add(this.neighborhood.rowHeads().get(i));
            i = this.nextChainElement(i, available);
        }
        return chain;
    }

    private final int nextMinimalElement(final BitSetFX available) {
        int i = Collections3.random(available, new Predicate<Integer>(){

            public final boolean apply(Integer i) {
                return ChainDecomposer.this.neighborhood._col(i, available).isEmpty();
            }
        }, this.rng);
        available.remove(i);
        return i;
    }

    private final int nextChainElement(int i, BitSetFX available) {
        Collection<Integer> upper = this.neighborhood._row(i, available);
        if (upper.isEmpty()) {
            return -1;
        }
        int j = Collections3.random(upper, this.rng);
        available.remove(j);
        return j;
    }
}

