/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.layout;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import conexp.fx.core.collections.Pair;
import conexp.fx.core.context.Concept;
import conexp.fx.core.layout.AdditiveConceptLayout;
import conexp.fx.core.layout.ConceptMovement;
import conexp.fx.core.layout.QualityMeasure;
import conexp.fx.gui.task.TimeTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javafx.beans.binding.Binding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableSet;
import javafx.geometry.BoundingBox;
import javafx.geometry.Point3D;
import javafx.geometry.Rectangle2D;

public final class LayoutEvolution<G, M> {
    private final ExecutorService tpe;
    private final QualityMeasure<G, M, Pair<Concept<G, M>, Double>> conflictDistance;
    private final AdditiveConceptLayout<G, M> layout;
    private final Concept<G, M> concept;
    private final ConceptMovement movement;
    private double minY;
    private final int toSide;
    private final int zoomInto;
    private final int steps;
    public final DoubleProperty progressProperty = new SimpleDoubleProperty(0.0);
    public Value best;
    public final ObservableSet<Value> values = FXCollections.observableSet(new HashSet());
    private final List<Value> lastValues;
    private final Set<Value> nextValues = new HashSet<Value>();
    private final double numPerDim;

    public static final <G, M> TimeTask<Void> calculate(final LayoutEvolution<G, M> qualityChart) {
        return new TimeTask<Void>("Quality Measure Chart"){

            protected final Void call() {
                this.updateProgress(0.0, 1.0);
                if (this.isCancelled()) {
                    return null;
                }
                this.updateMessage("Simulating Concept Movement...");
                qualityChart.progressProperty.addListener((ChangeListener)new ChangeListener<Number>(){

                    public final void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                        this.updateProgress(newValue.doubleValue(), 1.0);
                    }
                });
                qualityChart.calculate();
                this.updateProgress(1.0, 1.0);
                return null;
            }
        };
    }

    public LayoutEvolution(AdditiveConceptLayout<G, M> layout, Concept<G, M> concept, ConceptMovement movement, double widthFactor, double heightFactor, int toSide, int steps, int zoomInto, QualityMeasure<G, M, Pair<Concept<G, M>, Double>> conflictDistance, ExecutorService tpe) {
        this.layout = layout;
        this.concept = concept;
        this.movement = movement;
        this.toSide = toSide;
        this.numPerDim = 1.0 + 2.0 * (double)toSide;
        this.zoomInto = zoomInto;
        this.steps = steps;
        this.conflictDistance = conflictDistance;
        this.tpe = tpe;
        this.lastValues = new ArrayList<Value>((int)Math.pow(1.0 + 2.0 * (double)toSide, 2.0));
        BoundingBox layoutBounds = layout.getCurrentBoundingBox(false, false);
        double width = widthFactor * layoutBounds.getWidth();
        double height = heightFactor * layoutBounds.getHeight();
        Point3D origin = (Point3D)((Binding)layout.getPosition(concept)).getValue();
        Rectangle2D rectangle = new Rectangle2D(origin.getX() - width / 2.0, origin.getY() - height / 2.0, width, height);
        Value firstValue = new Value(Point3D.ZERO, rectangle, conflictDistance.apply(layout), (Map)((AdditiveConceptLayout)layout.clone()).seedsG, (Map)((AdditiveConceptLayout)layout.clone()).seedsM);
        if (concept.equals(layout.lattice.context.selection.topConcept())) {
            this.best = firstValue;
            return;
        }
        switch (movement) {
            case LABEL_SEED: {
                try {
                    this.minY = ((Point3D)((Binding)layout.getPosition((Concept)Iterators.getOnlyElement(layout.lattice.row(concept).iterator()))).getValue()).getY() - origin.getY();
                    break;
                }
                catch (IllegalArgumentException | NoSuchElementException e) {
                    this.best = firstValue;
                    return;
                }
            }
            default: {
                this.minY = -origin.getY();
            }
        }
        this.values.add((Object)firstValue);
        this.nextValues.add(firstValue);
    }

    public final Value calculate() {
        if (!this.nextValues.isEmpty()) {
            for (int step = 0; step < this.steps; ++step) {
                this.zoomIn();
            }
        }
        return this.best;
    }

    private final void zoomIn() {
        HashSet futures = new HashSet();
        for (Value value : this.nextValues) {
            this.values.remove((Object)value);
            double tileWidth = value.rectangle.getWidth() / this.numPerDim;
            double tileHeight = value.rectangle.getHeight() / this.numPerDim;
            Value value2 = new Value(value.delta, new Rectangle2D(value.rectangle.getMinX() + (double)this.toSide * tileWidth, value.rectangle.getMinY() + (double)this.toSide * tileHeight, tileWidth, tileHeight), value.result, value.hint, value.seedsG, value.seedsM);
            this.values.add((Object)value2);
            this.lastValues.add(value2);
            for (double i = (double)(-this.toSide); i <= (double)this.toSide; i += 1.0) {
                for (double j = (double)(-this.toSide); j <= (double)this.toSide; j += 1.0) {
                    if (i == 0.0 && j == 0.0) continue;
                    futures.add(this.tpe.submit(this.create(value, i, j, tileWidth, tileHeight)));
                }
            }
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        this.nextValues.clear();
        Collections.sort(this.lastValues);
        for (Value value : Iterables.limit(this.lastValues, (int)this.zoomInto)) {
            this.nextValues.add(value);
        }
        this.lastValues.clear();
    }

    private final Runnable create(final Value nextValue, final double i, final double j, final double tileWidth, final double tileHeight) {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Point3D delta = nextValue.delta.add(i * tileWidth, j * tileHeight, 0.0);
                if (delta.getY() < LayoutEvolution.this.minY) {
                    return;
                }
                Object movedLayout = LayoutEvolution.this.layout.clone();
                ((AdditiveConceptLayout)movedLayout).move(LayoutEvolution.this.concept, LayoutEvolution.this.movement, delta);
                Value value = new Value(delta, new Rectangle2D(nextValue.rectangle.getMinX() + (i + (double)LayoutEvolution.this.toSide) * tileWidth, nextValue.rectangle.getMinY() + (j + (double)LayoutEvolution.this.toSide) * tileHeight, tileWidth, tileHeight), (Pair)LayoutEvolution.this.conflictDistance.apply(movedLayout), (Map)((AdditiveConceptLayout)movedLayout).seedsG, (Map)((AdditiveConceptLayout)movedLayout).seedsM);
                Object object = LayoutEvolution.this.values;
                synchronized (object) {
                    LayoutEvolution.this.values.add((Object)value);
                }
                object = LayoutEvolution.this.lastValues;
                synchronized (object) {
                    LayoutEvolution.this.lastValues.add(value);
                }
                if (LayoutEvolution.this.best == null || value.result >= LayoutEvolution.this.best.result) {
                    LayoutEvolution.this.best = value;
                }
            }
        };
    }

    public final class Value
    implements Comparable<Value> {
        public final Point3D delta;
        public final Rectangle2D rectangle;
        public final double result;
        public final Concept<G, M> hint;
        public final Map<G, Point3D> seedsG;
        public final Map<M, Point3D> seedsM;

        private Value(Point3D delta, Rectangle2D rectangle, Pair<Concept<G, M>, Double> result, Map<G, Point3D> seedsG, Map<M, Point3D> seedsM) {
            this(delta, rectangle, result.second(), result.first(), seedsG, seedsM);
        }

        private Value(Point3D delta, Rectangle2D rectangle, double result, Concept<G, M> hint, Map<G, Point3D> seedsG, Map<M, Point3D> seedsM) {
            this.delta = delta;
            this.rectangle = rectangle;
            this.result = result;
            this.hint = hint;
            this.seedsG = seedsG;
            this.seedsM = seedsM;
        }

        @Override
        public final int compareTo(Value other) {
            return (int)Math.signum(other.result - this.result);
        }
    }
}

