/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.math;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.ujmp.core.Matrix;
import org.ujmp.core.booleanmatrix.BooleanMatrix;
import org.ujmp.core.booleanmatrix.BooleanMatrix2D;
import org.ujmp.core.calculation.Calculation;

public final class BooleanMatrices {
    public static final BooleanMatrix clone(BooleanMatrix m) {
        BooleanMatrix copy = BooleanMatrices.empty(m.getRowCount(), m.getColumnCount());
        copy.or(Calculation.Ret.ORIG, (Matrix)m);
        return copy;
    }

    public static final BooleanMatrix empty(long size) {
        return BooleanMatrices.empty(size, size);
    }

    public static final BooleanMatrix empty(long rows, long columns) {
        return BooleanMatrix2D.Factory.zeros(rows, columns);
    }

    public static final BooleanMatrix full(long size) {
        return BooleanMatrices.full(size, size);
    }

    public static final BooleanMatrix full(long rows, long columns) {
        return BooleanMatrices.complement(BooleanMatrices.empty(rows, columns));
    }

    public static final BooleanMatrix identity(long size) {
        BooleanMatrix m = BooleanMatrices.empty(size);
        int i = 0;
        while ((long)i < size) {
            m.setBoolean(true, new long[]{i, i});
            ++i;
        }
        return m;
    }

    public static final BooleanMatrix negativeIdentity(long size) {
        return BooleanMatrices.complement(BooleanMatrices.identity(size));
    }

    public static final BooleanMatrix lowerDiagonal(long size) {
        return BooleanMatrices.dual(BooleanMatrices.upperDiagonal(size));
    }

    public static final BooleanMatrix upperDiagonal(long size) {
        BooleanMatrix m = BooleanMatrices.empty(size);
        int i = 0;
        while ((long)i < size) {
            int j = i;
            while ((long)j < size) {
                m.setBoolean(true, new long[]{i, j});
                ++j;
            }
            ++i;
        }
        return m;
    }

    public static final BooleanMatrix strictLowerDiagonal(long size) {
        return BooleanMatrices.complement(BooleanMatrices.upperDiagonal(size));
    }

    public static final BooleanMatrix strictUpperDiagonal(long size) {
        return BooleanMatrices.complement(BooleanMatrices.lowerDiagonal(size));
    }

    public static final BooleanMatrix apposition(BooleanMatrix ... ms) {
        if (ms.length == 0) {
            return null;
        }
        BooleanMatrix m = ms[0];
        for (int i = 1; i < ms.length; ++i) {
            m = BooleanMatrices.apposition(m, ms[i]);
        }
        return m;
    }

    public static final BooleanMatrix apposition(BooleanMatrix left, BooleanMatrix right) {
        if (left == null) {
            return (BooleanMatrix)right.clone();
        }
        if (right == null) {
            return (BooleanMatrix)left.clone();
        }
        return (BooleanMatrix)left.appendHorizontally(Calculation.Ret.NEW, new Matrix[]{right});
    }

    public static final BooleanMatrix subposition(BooleanMatrix ... ms) {
        if (ms.length == 0) {
            return null;
        }
        BooleanMatrix m = ms[0];
        for (int i = 1; i < ms.length; ++i) {
            m = BooleanMatrices.subposition(m, ms[i]);
        }
        return m;
    }

    public static final BooleanMatrix subposition(BooleanMatrix upper, BooleanMatrix lower) {
        if (upper == null) {
            return (BooleanMatrix)lower.clone();
        }
        if (lower == null) {
            return (BooleanMatrix)upper.clone();
        }
        return (BooleanMatrix)upper.appendVertically(Calculation.Ret.NEW, new Matrix[]{lower});
    }

    public static final BooleanMatrix quadPosition(BooleanMatrix leftUpper, BooleanMatrix rightUpper, BooleanMatrix leftLower, BooleanMatrix rightLower) {
        return BooleanMatrices.subposition(BooleanMatrices.apposition(leftUpper, rightUpper), BooleanMatrices.apposition(leftLower, rightLower));
    }

    public static final BooleanMatrix complement(BooleanMatrix m) {
        return (BooleanMatrix)m.not(Calculation.Ret.NEW);
    }

    public static final BooleanMatrix dual(BooleanMatrix m) {
        return (BooleanMatrix)m.transpose(Calculation.Ret.NEW);
    }

    public static final BooleanMatrix booleann(long size) {
        if (size < 0L) {
            return null;
        }
        if (size == 0L) {
            return BooleanMatrices.identity(1L);
        }
        BooleanMatrix m = BooleanMatrices.booleann(size - 1L);
        return BooleanMatrices.subposition(BooleanMatrices.apposition(m, m), BooleanMatrices.apposition(BooleanMatrices.empty((long)Math.pow(2.0, size - 1L)), m));
    }

    public static final BooleanMatrix directSum(BooleanMatrix leftUpper, BooleanMatrix rightLower) {
        return BooleanMatrices.subposition(BooleanMatrices.apposition(leftUpper, BooleanMatrices.full(leftUpper.getRowCount(), rightLower.getColumnCount())), BooleanMatrices.apposition(BooleanMatrices.full(rightLower.getRowCount(), leftUpper.getColumnCount()), rightLower));
    }

    public static final BooleanMatrix horizontalSum(BooleanMatrix leftUpper, BooleanMatrix rightLower) {
        return BooleanMatrices.subposition(BooleanMatrices.apposition(leftUpper, BooleanMatrices.empty(leftUpper.getRowCount(), rightLower.getColumnCount())), BooleanMatrices.apposition(BooleanMatrices.empty(rightLower.getRowCount(), leftUpper.getColumnCount()), rightLower));
    }

    public static final BooleanMatrix verticalSum(BooleanMatrix leftUpper, BooleanMatrix rightLower) {
        return BooleanMatrices.subposition(BooleanMatrices.apposition(leftUpper, BooleanMatrices.full(leftUpper.getRowCount(), rightLower.getColumnCount())), BooleanMatrices.apposition(BooleanMatrices.empty(rightLower.getRowCount(), leftUpper.getColumnCount()), rightLower));
    }

    public static final BooleanMatrix substitutionSum(BooleanMatrix outer, BooleanMatrix inner, long row, long column, Collection<Integer> gI, Collection<Integer> mI) {
        BooleanMatrix lu = outer;
        System.out.println(lu);
        BooleanMatrix rl = inner;
        System.out.println(rl);
        BooleanMatrix ru = BooleanMatrices.empty(lu.getRowCount(), rl.getColumnCount());
        ru.selectRows(Calculation.Ret.LINK, mI).not(Calculation.Ret.ORIG);
        System.out.println(ru);
        BooleanMatrix ll = BooleanMatrices.empty(rl.getRowCount(), lu.getColumnCount());
        ll.selectColumns(Calculation.Ret.LINK, gI).not(Calculation.Ret.ORIG);
        System.out.println(ll);
        return BooleanMatrices.quadPosition(lu, ru, ll, rl).deleteRows(Calculation.Ret.NEW, new long[]{row}).deleteColumns(Calculation.Ret.NEW, new long[]{column}).toBooleanMatrix();
    }

    public static final BooleanMatrix directProduct(BooleanMatrix m1, BooleanMatrix m2) {
        return (BooleanMatrix)BooleanMatrices.scale(m1, m2.getRowCount(), m2.getColumnCount()).or(Calculation.Ret.NEW, (Matrix)BooleanMatrices.duplicate(m2, m1.getRowCount(), m1.getColumnCount()));
    }

    public static final BooleanMatrix biProduct(BooleanMatrix m1, BooleanMatrix m2) {
        return (BooleanMatrix)BooleanMatrices.scale(m1, m2.getRowCount(), m2.getColumnCount()).and(Calculation.Ret.NEW, (Matrix)BooleanMatrices.duplicate(m2, m1.getRowCount(), m1.getColumnCount()));
    }

    public static final BooleanMatrix semiProduct(BooleanMatrix m1, BooleanMatrix m2) {
        return BooleanMatrices.apposition(BooleanMatrices.scaleV(m1, m2.getRowCount()), BooleanMatrices.duplicateV(m2, m1.getRowCount()));
    }

    private static final BooleanMatrix duplicate(BooleanMatrix m, long rowFactor, long columnFactor) {
        return BooleanMatrices.duplicateV(BooleanMatrices.duplicateH(m, columnFactor), rowFactor);
    }

    private static final BooleanMatrix duplicateH(BooleanMatrix m, long columnFactor) {
        BooleanMatrix h = null;
        int i = 0;
        while ((long)i < columnFactor) {
            h = BooleanMatrices.apposition(h, m);
            ++i;
        }
        return h;
    }

    private static final BooleanMatrix duplicateV(BooleanMatrix m, long rowFactor) {
        BooleanMatrix v = null;
        int i = 0;
        while ((long)i < rowFactor) {
            v = BooleanMatrices.subposition(v, m);
            ++i;
        }
        return v;
    }

    private static final BooleanMatrix scale(BooleanMatrix m, long rowFactor, long columnFactor) {
        return BooleanMatrices.scaleV(BooleanMatrices.scaleH(m, columnFactor), rowFactor);
    }

    private static final BooleanMatrix scaleH(BooleanMatrix m, long columnFactor) {
        BooleanMatrix h = null;
        for (long j = 0L; j < m.getColumnCount(); ++j) {
            int f = 0;
            while ((long)f < columnFactor) {
                h = BooleanMatrices.apposition(h, (BooleanMatrix)m.selectColumns(Calculation.Ret.NEW, new long[]{j}));
                ++f;
            }
        }
        return h;
    }

    private static final BooleanMatrix scaleV(BooleanMatrix m, long rowFactor) {
        BooleanMatrix v = null;
        for (long i = 0L; i < m.getRowCount(); ++i) {
            int f = 0;
            while ((long)f < rowFactor) {
                v = BooleanMatrices.subposition(v, (BooleanMatrix)m.selectRows(Calculation.Ret.NEW, new long[]{i}));
                ++f;
            }
        }
        return v;
    }

    public static final BooleanMatrix andCol(BooleanMatrix m, Iterable<Integer> columns) {
        Iterator<Integer> it = columns.iterator();
        if (it.hasNext()) {
            BooleanMatrix andCol = (BooleanMatrix)m.selectColumns(Calculation.Ret.NEW, new long[]{it.next().intValue()});
            while (it.hasNext()) {
                andCol.and(Calculation.Ret.ORIG, m.selectColumns(Calculation.Ret.LINK, new long[]{it.next().intValue()}));
            }
            return andCol;
        }
        return BooleanMatrices.full(m.getRowCount(), 1L);
    }

    public static final BooleanMatrix andRow(BooleanMatrix m, Iterable<Integer> rows) {
        Iterator<Integer> it = rows.iterator();
        if (it.hasNext()) {
            BooleanMatrix andRow = (BooleanMatrix)m.selectRows(Calculation.Ret.NEW, new long[]{it.next().intValue()});
            while (it.hasNext()) {
                andRow.and(Calculation.Ret.ORIG, m.selectRows(Calculation.Ret.LINK, new long[]{it.next().intValue()}));
            }
            return andRow;
        }
        return BooleanMatrices.full(1L, m.getColumnCount());
    }

    public static final BooleanMatrix andCol(BooleanMatrix m, Integer ... columns) {
        return BooleanMatrices.andCol(m, Arrays.asList(columns));
    }

    public static final BooleanMatrix andRow(BooleanMatrix m, Integer ... rows) {
        return BooleanMatrices.andRow(m, Arrays.asList(rows));
    }

    private static final boolean isSquare(BooleanMatrix m) {
        return m.getRowCount() == m.getColumnCount();
    }

    public static final BooleanMatrix product(BooleanMatrix m1, BooleanMatrix m2) {
        return m1.mtimes(Calculation.Ret.NEW, false, (Matrix)m2).toBooleanMatrix();
    }

    public static final BooleanMatrix power(BooleanMatrix m, int n) {
        if (!BooleanMatrices.isSquare(m)) {
            throw new IllegalArgumentException();
        }
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return BooleanMatrices.identity(m.getRowCount());
        }
        if (n == 1) {
            return BooleanMatrices.clone(m);
        }
        if (n == 2) {
            return BooleanMatrices.product(m, m);
        }
        return BooleanMatrices.product(BooleanMatrices.power(m, n - 1), m);
    }

    public static final BooleanMatrix reflexiveClosure(BooleanMatrix m) {
        if (!BooleanMatrices.isSquare(m)) {
            return null;
        }
        return m.or(Calculation.Ret.NEW, (Matrix)BooleanMatrices.identity(m.getRowCount())).toBooleanMatrix();
    }

    public static final BooleanMatrix reflexiveReduction(BooleanMatrix m) {
        if (!BooleanMatrices.isSquare(m)) {
            return null;
        }
        return m.and(Calculation.Ret.NEW, (Matrix)BooleanMatrices.negativeIdentity(m.getRowCount())).toBooleanMatrix();
    }

    public static final BooleanMatrix transitiveClosure(BooleanMatrix m) {
        if (!BooleanMatrices.isSquare(m)) {
            return null;
        }
        BooleanMatrix t = BooleanMatrices.clone(m);
        BooleanMatrix power = BooleanMatrices.clone(m);
        BooleanMatrix last = null;
        do {
            power = BooleanMatrices.product(power, m);
            last = BooleanMatrices.clone(t);
        } while (!(t = t.or(Calculation.Ret.NEW, (Matrix)power).toBooleanMatrix()).equals(last));
        return t;
    }

    public static final BooleanMatrix transitiveReduction(BooleanMatrix m) {
        if (!BooleanMatrices.isSquare(m)) {
            return null;
        }
        return m.and(Calculation.Ret.NEW, m.mtimes(Calculation.Ret.NEW, false, (Matrix)BooleanMatrices.transitiveClosure(m)).not(Calculation.Ret.NEW)).toBooleanMatrix();
    }
}

