/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.math;

import conexp.fx.core.math.LatticeElement;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Function;

@FunctionalInterface
public interface DualClosureOperator<T extends LatticeElement<T>>
extends Function<T, T> {
    @Override
    default public T apply(T element) {
        return this.closure(element);
    }

    public T closure(T var1);

    default public boolean close(T element) {
        return !element.inf(this.closure(element));
    }

    default public boolean isClosed(T element) {
        return element.equivalent(this.closure(element));
    }

    @SafeVarargs
    public static <T extends LatticeElement<T>> DualClosureOperator<T> infimum(DualClosureOperator<T> ... closureOperators) {
        return DualClosureOperator.infimum(Arrays.asList(closureOperators));
    }

    public static <T extends LatticeElement<T>> DualClosureOperator<T> infimum(Iterable<DualClosureOperator<T>> closureOperators) {
        return element -> {
            Iterator it = closureOperators.iterator();
            if (!it.hasNext()) {
                return (LatticeElement)element.smallest();
            }
            LatticeElement closure = ((DualClosureOperator)it.next()).closure(element);
            while (it.hasNext()) {
                closure.sup(((DualClosureOperator)it.next()).closure(element));
            }
            return closure;
        };
    }

    @SafeVarargs
    public static <T extends LatticeElement<T>> DualClosureOperator<T> supremum(DualClosureOperator<T> ... closureOperators) {
        return DualClosureOperator.supremum(Arrays.asList(closureOperators));
    }

    public static <T extends LatticeElement<T>> DualClosureOperator<T> supremum(Iterable<DualClosureOperator<T>> closureOperators) {
        return element -> {
            Iterator it = closureOperators.iterator();
            if (!it.hasNext()) {
                return element;
            }
            LatticeElement closure = ((DualClosureOperator)closureOperators.iterator().next()).closure(element);
            boolean changed = true;
            while (changed) {
                changed = false;
                for (DualClosureOperator clop : closureOperators) {
                    changed |= closure.inf(clop.closure(closure));
                }
            }
            return closure;
        };
    }
}

