/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.math;

import java.util.Collection;

public final class Math3 {
    public static final double wsum(double x, double y, double p) {
        return p * x + (1.0 - p) * y;
    }

    public static final double round(double x, int decimalsAfterDot) {
        double f = Math.pow(10.0, decimalsAfterDot);
        return Math.rint(f * x) / f;
    }

    public static final long factorial(int n) {
        return n == 0 ? 1L : (long)n * Math3.factorial(n - 1);
    }

    public static final double modulo(double number, double module) {
        double value;
        for (value = number; value < 0.0; value += module) {
        }
        return value % module;
    }

    public static final long binomial(int N, int K) {
        int n;
        long[][] binomial = new long[N + 1][K + 1];
        for (int k = 1; k <= K; ++k) {
            binomial[0][k] = 0L;
        }
        for (n = 0; n <= N; ++n) {
            binomial[n][0] = 1L;
        }
        for (n = 1; n <= N; ++n) {
            for (int k = 1; k <= K; ++k) {
                binomial[n][k] = binomial[n - 1][k - 1] + binomial[n - 1][k];
            }
        }
        return binomial[N][K];
    }

    public static double sum(Collection<? extends Number> c) {
        double s = 0.0;
        for (Number number : c) {
            s += number.doubleValue();
        }
        return s;
    }

    public static double product(Collection<? extends Number> c) {
        double s = 1.0;
        for (Number number : c) {
            s *= number.doubleValue();
        }
        return s;
    }

    public static final String formatMillis(long millis) {
        if (millis == 0L) {
            return "";
        }
        long ms = millis % 1000L;
        long s = millis / 1000L % 60L;
        long m = millis / 60000L % 60L;
        long h = millis / 3600000L;
        if (h > 0L) {
            return String.format("%02dh %02dmin", h, m);
        }
        if (m > 0L) {
            return String.format("%02dmin %02ds", m, s);
        }
        if (s > 0L) {
            return String.format("%02ds %03dms", s, ms);
        }
        return String.format("%03dms", ms);
    }

    public static final String formatNanos(long nanos) {
        if (nanos == 0L) {
            return "";
        }
        long ns = nanos % 1000L;
        long \u00b5s = nanos / 1000L % 1000L;
        long ms = nanos / 1000000L % 1000L;
        long s = nanos / 1000000000L % 60L;
        long m = nanos / 60000000000L % 60L;
        long h = nanos / 3600000000000L;
        if (h > 0L) {
            return String.format("%02dh %02dmin", h, m);
        }
        if (m > 0L) {
            return String.format("%02dmin %02ds", m, s);
        }
        if (s > 0L) {
            return String.format("%02ds %03dms", s, ms);
        }
        if (ms > 0L) {
            return String.format("%03dms %03d\u00b5s", ms, \u00b5s);
        }
        if (\u00b5s > 0L) {
            return String.format("%03d\u00b5s %03dns", \u00b5s, ns);
        }
        return String.format("%03dns", ns);
    }
}

