/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.math;

import conexp.fx.core.context.Context;
import conexp.fx.core.context.Implication;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.lang3.NotImplementedException;

@FunctionalInterface
public interface SetClosureOperator<M>
extends Function<Set<M>, Set<M>> {
    @Override
    default public Set<M> apply(Set<M> set) {
        return this.closure(set);
    }

    public Set<M> closure(Set<M> var1);

    default public boolean close(Set<M> set) {
        return !set.addAll(this.closure(set));
    }

    default public boolean isClosed(Set<M> set) {
        return set.size() == this.closure(set).size();
    }

    @SafeVarargs
    public static <T> SetClosureOperator<T> infimum(SetClosureOperator<T> ... closureOperators) {
        return SetClosureOperator.infimum(Arrays.asList(closureOperators));
    }

    public static <T> SetClosureOperator<T> infimum(Iterable<SetClosureOperator<T>> closureOperators) {
        return set -> {
            HashSet closure = new HashSet();
            Iterator iterator = closureOperators.iterator();
            if (iterator.hasNext()) {
                closure.addAll(((SetClosureOperator)iterator.next()).closure(set));
            }
            while (iterator.hasNext()) {
                closure.retainAll(((SetClosureOperator)iterator.next()).closure(set));
            }
            return closure;
        };
    }

    @SafeVarargs
    public static <T> SetClosureOperator<T> supremum(SetClosureOperator<T> ... closureOperators) {
        return SetClosureOperator.supremum(Arrays.asList(closureOperators));
    }

    public static <T> SetClosureOperator<T> supremum(Iterable<SetClosureOperator<T>> closureOperators) {
        return set -> {
            HashSet closure = new HashSet();
            closure.addAll(set);
            boolean changed = true;
            while (changed) {
                changed = false;
                for (SetClosureOperator clop : closureOperators) {
                    changed |= closure.addAll(clop.closure(closure));
                }
            }
            return closure;
        };
    }

    public static <G, M> SetClosureOperator<M> fromContext(Context<G, M> cxt) {
        return set -> cxt.rowAnd(cxt.colAnd(set));
    }

    public static <G, M> SetClosureOperator<M> joiningImplications(Context<G, M> cxt, Set<M> premises, Set<M> conclusions) {
        return set -> {
            HashSet pintersection = new HashSet(set);
            pintersection.retainAll(premises);
            Set cattributes = cxt.rowAnd(cxt.colAnd(pintersection));
            cattributes.retainAll(conclusions);
            HashSet closure = new HashSet(cattributes);
            closure.addAll(set);
            return closure;
        };
    }

    public static <G, M, C extends Set<M>> C implicativeClosure(Collection<Implication<G, M>> implications, int firstPremiseSize, boolean includePseudoClosures, boolean parallel, boolean bySize, Function<Set<M>, C> supplier, Set<M> set) {
        Set closure = (Set)supplier.apply(set);
        AtomicBoolean changed = new AtomicBoolean(true);
        Predicate<Implication> p = includePseudoClosures ? i -> closure.size() > i.getPremise().size() && closure.containsAll(i.getPremise()) : i -> closure.size() >= i.getPremise().size() && closure.containsAll(i.getPremise());
        if (bySize) {
            int size;
            if (firstPremiseSize > 0) {
                size = closure.size();
                ((Stream)(parallel ? implications.parallelStream() : implications.stream()).filter(i -> firstPremiseSize <= i.getPremise().size()).filter(p).sequential()).forEach(i -> closure.addAll(i.getConclusion()));
                changed.set(closure.size() != size);
            }
            while (changed.get()) {
                size = closure.size();
                changed.set(false);
                ((Stream)(parallel ? implications.parallelStream() : implications.stream()).filter(p).sequential()).forEach(i -> closure.addAll(i.getConclusion()));
                changed.set(closure.size() != size);
            }
        } else {
            if (firstPremiseSize > 0) {
                ((Stream)(parallel ? implications.parallelStream() : implications.stream()).filter(i -> firstPremiseSize <= i.getPremise().size()).filter(p).sequential()).forEach(i -> changed.set(closure.addAll(i.getConclusion()) || changed.get()));
            }
            while (changed.get()) {
                changed.set(false);
                ((Stream)(parallel ? implications.parallelStream() : implications.stream()).filter(p).sequential()).forEach(i -> changed.set(closure.addAll(i.getConclusion()) || changed.get()));
            }
        }
        return (C)closure;
    }

    public static <G, M, C extends Set<M>> SetClosureOperator<M> fromImplications(Collection<Implication<G, M>> implications, int firstPremiseSize, boolean includePseudoClosures, boolean parallel, boolean bySize, Function<Set<M>, C> supplier) {
        return set -> SetClosureOperator.implicativeClosure(implications, firstPremiseSize, includePseudoClosures, parallel, bySize, supplier, set);
    }

    public static <G, M> SetClosureOperator<M> fromImplications(Collection<Implication<G, M>> implications, int firstPremiseSize, boolean includePseudoClosures, boolean parallel) {
        return SetClosureOperator.fromImplications(implications, firstPremiseSize, includePseudoClosures, parallel, false, HashSet::new);
    }

    public static <G, M> SetClosureOperator<M> fromImplications(Collection<Implication<G, M>> implications, boolean includePseudoClosures, boolean parallel) {
        return SetClosureOperator.fromImplications(implications, 0, includePseudoClosures, parallel);
    }

    public static <G, M> SetClosureOperator<M> fromImplications(Collection<Implication<G, M>> implications) {
        return SetClosureOperator.fromImplications(implications, false, true);
    }

    public static <G, M> SetClosureOperator<M> fromImplicationSetLinClosure(Collection<Implication<G, M>> implications) {
        return set -> {
            HashMap<Implication, Integer> count = new HashMap<Implication, Integer>();
            HashMap list = new HashMap();
            for (Object attribute : set) {
                list.put(attribute, new HashSet());
            }
            for (Implication implication : implications) {
                for (Object attribute : implication.getPremise()) {
                    list.put(attribute, new HashSet());
                }
                for (Object attribute : implication.getConclusion()) {
                    list.put(attribute, new HashSet());
                }
            }
            HashSet newdep = new HashSet();
            HashSet update = new HashSet();
            for (Implication implication : implications) {
                count.put(implication, implication.getPremise().size());
                if (implication.getPremise().isEmpty()) {
                    newdep.addAll(implication.getConclusion());
                }
                for (Object attribute : implication.getPremise()) {
                    if (!list.containsKey(attribute)) {
                        list.put(attribute, new HashSet());
                    }
                    ((Set)list.get(attribute)).add(implication);
                }
            }
            newdep.addAll(set);
            update.addAll(set);
            while (!update.isEmpty()) {
                Object attribute = update.iterator().next();
                update.remove(attribute);
                for (Implication implication : (Set)list.get(attribute)) {
                    Integer previous = (Integer)count.get((Object)implication);
                    count.put(implication, previous - 1);
                    if ((Integer)count.get((Object)implication) != 0) continue;
                    HashSet add = new HashSet();
                    add.addAll(implication.getConclusion());
                    add.removeAll(newdep);
                    newdep.addAll(add);
                    update.addAll(add);
                }
            }
            return newdep;
        };
    }

    public static <G, M> SetClosureOperator<M> fromImplicationSetDowlingGalier(Collection<Implication<G, M>> implications) {
        throw new NotImplementedException("");
    }

    public static <G, M> SetClosureOperator<M> byMaximalCardinality(final int maxCard, final Collection<M> baseSet) {
        return new SetClosureOperator<M>(){

            @Override
            public boolean isClosed(Set<M> set) {
                return set.size() <= maxCard || set.containsAll(baseSet);
            }

            @Override
            public boolean close(Set<M> set) {
                if (this.isClosed(set)) {
                    return true;
                }
                set.addAll(baseSet);
                return false;
            }

            @Override
            public Set<M> closure(Set<M> set) {
                if (this.isClosed(set)) {
                    return new HashSet(set);
                }
                return new HashSet(baseSet);
            }
        };
    }

    public static <G, M> SetClosureOperator<M> byMinimalSupport(final int minSupp, final Context<G, M> cxt) {
        return new SetClosureOperator<M>(){

            @Override
            public boolean isClosed(Set<M> set) {
                return cxt.colAnd(set).size() >= minSupp || set.containsAll(cxt.colHeads());
            }

            @Override
            public boolean close(Set<M> set) {
                if (this.isClosed(set)) {
                    return true;
                }
                set.addAll(cxt.colHeads());
                return false;
            }

            @Override
            public Set<M> closure(Set<M> set) {
                if (this.isClosed(set)) {
                    return new HashSet(set);
                }
                return new HashSet(cxt.colHeads());
            }
        };
    }

    public static <G, M> SetClosureOperator<M> containsAllFrom(final Collection<M> elements, Set<M> baseSet) {
        return new SetClosureOperator<M>(){

            @Override
            public boolean isClosed(Set<M> set) {
                return set.containsAll(elements);
            }

            @Override
            public boolean close(Set<M> set) {
                if (this.isClosed(set)) {
                    return true;
                }
                set.addAll(elements);
                return false;
            }

            @Override
            public Set<M> closure(Set<M> set) {
                if (this.isClosed(set)) {
                    return new HashSet(set);
                }
                HashSet result = new HashSet(set);
                result.addAll(elements);
                return result;
            }
        };
    }

    public static <G, M> SetClosureOperator<M> isSubsetOf(final Collection<M> elements, final Set<M> baseSet) {
        return new SetClosureOperator<M>(){

            @Override
            public boolean isClosed(Set<M> set) {
                return elements.containsAll(set);
            }

            @Override
            public boolean close(Set<M> set) {
                if (this.isClosed(set)) {
                    return true;
                }
                set.addAll(baseSet);
                return false;
            }

            @Override
            public Set<M> closure(Set<M> set) {
                if (this.isClosed(set)) {
                    return new HashSet(set);
                }
                return new HashSet(baseSet);
            }
        };
    }

    public static <M> SetClosureOperator<M> bottom() {
        return new SetClosureOperator<M>(){

            @Override
            public final boolean isClosed(Set<M> set) {
                return true;
            }

            @Override
            public final boolean close(Set<M> set) {
                return true;
            }

            @Override
            public final Set<M> closure(Set<M> set) {
                return new HashSet(set);
            }
        };
    }

    public static <M> SetClosureOperator<M> top(final Set<M> baseSet) {
        return new SetClosureOperator<M>(){

            @Override
            public final boolean isClosed(Set<M> set) {
                return set.containsAll(baseSet) && baseSet.containsAll(set);
            }

            @Override
            public final boolean close(Set<M> set) {
                set.retainAll(baseSet);
                return !set.addAll(baseSet);
            }

            @Override
            public final Set<M> closure(Set<M> set) {
                return new HashSet(baseSet);
            }
        };
    }
}

