/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.util;

import conexp.fx.core.collections.Pair;
import conexp.fx.core.util.Strings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Predicate;
import javafx.stage.FileChooser;

public enum FileFormat {
    ANY("All Files", "*"),
    CXT("Burmeister Format (Only Context)", "cxt"),
    CEX("ConExp Format (Only Context)", "cex"),
    CFX("ConExpFX Format (Context & Lattice)", "cfx"),
    CSVB("Comma Separated Values (pairs)", "csv"),
    CSVT("Comma Separated Values (triples)", "csv"),
    RDF("RDF Format (Graph Data)", "rdf", "rdfs", "owl", "xml"),
    NT("N-Triples", "nt"),
    N3("N3", "n3"),
    TTL("Turtle", "ttl"),
    TRIX("TriX", "xml", "trix"),
    TRIG("TriG", "trig"),
    BRDF("Binary RDF", "brf"),
    NQUADS("N-Quads", "nq"),
    JSONLD("JSON-LD", "jsonld"),
    RDFJSON("RDF-JSON", "rj"),
    RDFA("RDFa", "xhtml"),
    HTML("Hypertext Markup Language (Only Context)", "html"),
    PDF("Portable Document Format (Only Lattice)", "pdf"),
    PNG("Portable Network Graphics (Only Lattice)", "png"),
    SVG("Scalable Vector Graphics (Only Lattice)", "svg"),
    TEX("Ganter's fca.sty TeX Format (Context & Lattice)", "tex");

    public final String title;
    public final String[] suffix;
    public final FileChooser.ExtensionFilter extensionFilter;

    private FileFormat(String title, String ... suffix) {
        this.title = title;
        this.suffix = suffix;
        String suffixes = "";
        LinkedList<String> extensions = new LinkedList<String>();
        for (String s : suffix) {
            suffixes = suffixes + ", *." + s;
            extensions.add("*." + s);
        }
        this.extensionFilter = new FileChooser.ExtensionFilter(title + suffixes, extensions);
    }

    public String toString() {
        String suffixes = "";
        Iterator<String> it = Arrays.asList(this.suffix).iterator();
        if (it.hasNext()) {
            suffixes = suffixes + "*." + it.next();
        }
        while (it.hasNext()) {
            suffixes = suffixes + ", *." + it.next();
        }
        return this.title + " [" + suffixes + "]";
    }

    public static final Pair<File, FileFormat> of(File file) {
        String suffix = file.getName().substring(file.getName().lastIndexOf(".") + 1);
        if (suffix.toLowerCase().equals("csv")) {
            try {
                Optional<String> firstNonEmptyLine = Files.lines(file.toPath()).map(String::trim).filter(((Predicate<String>)String::isEmpty).negate()).findAny();
                if (firstNonEmptyLine.isPresent() && Strings.countOccurences(firstNonEmptyLine.get(), ";") < 2) {
                    return Pair.of(file, CSVB);
                }
                return Pair.of(file, CSVT);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        for (FileFormat ff : FileFormat.values()) {
            if (ff == ANY) continue;
            for (String suf : ff.suffix) {
                if (!suf.equals(suffix)) continue;
                return Pair.of(file, ff);
            }
        }
        return Pair.of(file, ANY);
    }

    public static final Pair<File, FileFormat> of(File file, FileFormat ... fileFormats) {
        String suffix = file.getName().substring(file.getName().lastIndexOf(".") + 1);
        for (FileFormat ff : fileFormats) {
            if (ff == ANY) continue;
            for (String suf : ff.suffix) {
                if (!suf.equals(suffix)) continue;
                return Pair.of(file, ff);
            }
        }
        return Pair.of(file, ANY);
    }
}

