/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.xml;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import conexp.fx.core.xml.Datatype;
import conexp.fx.core.xml.ListData;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class BooleanListData
extends ListData<Boolean> {
    private static final Function<String, Boolean> STRING_TO_BOOLEAN_FUNCTION = new Function<String, Boolean>(){

        public final Boolean apply(String value) {
            return Boolean.valueOf(value);
        }
    };

    public BooleanListData(String key, String subkey, List<Boolean> value) throws NullPointerException, IndexOutOfBoundsException {
        super(Datatype.BOOLEAN_LIST, key, subkey, value);
    }

    public BooleanListData(String key, String subkey, Boolean ... values) throws NullPointerException, IndexOutOfBoundsException {
        this(key, subkey, Arrays.asList(values));
    }

    public BooleanListData(String key, String subkey, Void v, List<String> value) throws NullPointerException, IndexOutOfBoundsException {
        this(key, subkey, Lists.transform(value, STRING_TO_BOOLEAN_FUNCTION));
    }

    public BooleanListData(String key, String subkey, Void v, String ... values) throws NullPointerException, IndexOutOfBoundsException {
        this(key, subkey, Lists.transform(Arrays.asList(values), STRING_TO_BOOLEAN_FUNCTION));
    }

    @Override
    public final boolean add(Boolean value) {
        return ((List)this.value).add(value);
    }

    @Override
    public final void add(int index, Boolean value) {
        ((List)this.value).add(index, value);
    }

    @Override
    public final Boolean set(int index, Boolean value) {
        return ((List)this.value).set(index, value);
    }

    @Override
    public final Boolean get(int index) {
        return (Boolean)((List)this.value).get(index);
    }

    @Override
    public final Boolean remove(int index) {
        return (Boolean)((List)this.value).remove(index);
    }

    @Override
    public final boolean remove(Object object) {
        return ((List)this.value).remove(object);
    }

    @Override
    public final boolean contains(Object object) {
        return ((List)this.value).contains(object);
    }

    @Override
    public final int indexOf(Object object) {
        return ((List)this.value).indexOf(object);
    }

    @Override
    public final int lastIndexOf(Object object) {
        return ((List)this.value).lastIndexOf(object);
    }

    @Override
    public final boolean addAll(Collection<? extends Boolean> collection) {
        return ((List)this.value).addAll(collection);
    }

    @Override
    public final boolean addAll(int index, Collection<? extends Boolean> collection) {
        return ((List)this.value).addAll(index, collection);
    }

    @Override
    public final boolean removeAll(Collection<?> collection) {
        return ((List)this.value).removeAll(collection);
    }

    @Override
    public final boolean retainAll(Collection<?> collection) {
        return ((List)this.value).retainAll(collection);
    }

    @Override
    public final boolean containsAll(Collection<?> collection) {
        return ((List)this.value).containsAll(collection);
    }

    @Override
    public final void clear() {
        ((List)this.value).clear();
    }

    @Override
    public final boolean isEmpty() {
        return ((List)this.value).isEmpty();
    }

    @Override
    public final int size() {
        return ((List)this.value).size();
    }

    @Override
    public final Iterator<Boolean> iterator() {
        return ((List)this.value).iterator();
    }

    @Override
    public final ListIterator<Boolean> listIterator() {
        return ((List)this.value).listIterator();
    }

    @Override
    public final ListIterator<Boolean> listIterator(int index) {
        return ((List)this.value).listIterator(index);
    }

    @Override
    public final List<Boolean> subList(int fromIndex, int toIndex) {
        return ((List)this.value).subList(fromIndex, toIndex);
    }

    @Override
    public final Object[] toArray() {
        return ((List)this.value).toArray();
    }

    @Override
    public final <T> T[] toArray(T[] array) {
        return ((List)this.value).toArray(array);
    }
}

