/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.xml;

import conexp.fx.core.collections.Collections3;
import conexp.fx.core.xml.BooleanData;
import conexp.fx.core.xml.BooleanListData;
import conexp.fx.core.xml.CompoundData;
import conexp.fx.core.xml.CompoundListData;
import conexp.fx.core.xml.Datatype;
import conexp.fx.core.xml.FloatData;
import conexp.fx.core.xml.FloatListData;
import conexp.fx.core.xml.IntegerData;
import conexp.fx.core.xml.IntegerListData;
import conexp.fx.core.xml.ListData;
import conexp.fx.core.xml.StringData;
import conexp.fx.core.xml.StringListData;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Data<T> {
    protected final Datatype type;
    protected final String key;
    protected T value;
    private static final String PREFIX = "| ";

    public Data(Datatype type, String key, T value) throws NullPointerException, IndexOutOfBoundsException {
        if (type == null) {
            throw new NullPointerException("Unable to create data without type");
        }
        if (key == null) {
            throw new IndexOutOfBoundsException("Unable to create data without keys");
        }
        this.type = type;
        this.key = key;
        this.value = value;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Data)) {
            return false;
        }
        Data other = (Data)object;
        if (!this.type.equals((Object)other.type)) {
            return false;
        }
        if (!this.key.equals(other.key)) {
            return false;
        }
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return 1 + 2 * this.type.hashCode() + 3 * this.key.hashCode() + 5 * this.value.hashCode();
    }

    public String toString() {
        return this.toString("");
    }

    private final String toString(String prefix) {
        switch (this.type) {
            case STRING: {
                return prefix + this.key + " (" + (Object)((Object)this.type) + ") = \"" + this.value.toString() + "\"";
            }
            case BOOLEAN: 
            case INTEGER: 
            case BOOLEAN_LIST: 
            case INTEGER_LIST: 
            case STRING_LIST: {
                return prefix + this.key + " (" + (Object)((Object)this.type) + ") = " + this.value.toString();
            }
            case METADATA: 
            case COMPOUND: {
                return prefix + this.key + " (" + (Object)((Object)this.type) + ")\r\n";
            }
            case COMPOUND_LIST: {
                return prefix + this.key + " (" + (Object)((Object)this.type) + ")" + this.toString(prefix + PREFIX, this.toCompoundListData().getSubkey(), (List)this.toCompoundListData().getValue());
            }
        }
        return prefix + this.key + " (" + (Object)((Object)this.type) + ")\r\n";
    }

    private final String toString(String prefix, String subkey, List<Map<String, Data<?>>> list) {
        String string = "";
        for (Map<String, Data<?>> map : list) {
            string = string + "\r\n" + prefix + subkey + "\r\n" + this.toString(prefix + PREFIX, map);
        }
        return string;
    }

    private final String toString(String prefix, Map<String, Data<?>> map) {
        Iterator<String> keys = Collections3.sort(map.keySet()).iterator();
        String string = "";
        if (keys.hasNext()) {
            string = string + super.toString(prefix);
        }
        while (keys.hasNext()) {
            string = string + "\r\n" + super.toString(prefix);
        }
        return string;
    }

    public final Datatype getType() {
        return this.type;
    }

    public final String getKey() {
        return new String(this.key);
    }

    public final T getValue() {
        return this.value;
    }

    public final T setValue(T value) throws NullPointerException {
        if (value == null) {
            throw new NullPointerException("Unable to set null value on data");
        }
        T previous = this.value;
        this.value = value;
        return previous;
    }

    public final boolean isBooleanData() {
        return this.getType().equals((Object)Datatype.BOOLEAN);
    }

    public final BooleanData toBooleanData() throws ClassCastException {
        if (!this.isBooleanData()) {
            throw new ClassCastException("Cannot cast data of type " + (Object)((Object)this.type) + " to " + (Object)((Object)Datatype.BOOLEAN));
        }
        return (BooleanData)this;
    }

    public final Boolean getBooleanValue() {
        return (Boolean)this.toBooleanData().getValue();
    }

    public final void setBooleanValue(Boolean value) {
        this.toBooleanData().setValue(value);
    }

    public final boolean isIntegerData() {
        return this.getType().equals((Object)Datatype.INTEGER);
    }

    public final IntegerData toIntegerData() throws ClassCastException {
        if (!this.isIntegerData()) {
            throw new ClassCastException("Cannot cast data of type " + (Object)((Object)this.type) + " to " + (Object)((Object)Datatype.INTEGER));
        }
        return (IntegerData)this;
    }

    public final Integer getIntegerValue() {
        return (Integer)this.toIntegerData().getValue();
    }

    public final void setIntegerValue(Integer value) {
        this.toIntegerData().setValue(value);
    }

    public final boolean isFloatData() {
        return this.getType().equals((Object)Datatype.FLOAT);
    }

    public final FloatData toFloatData() throws ClassCastException {
        if (!this.isFloatData()) {
            throw new ClassCastException("Cannot cast data of type " + (Object)((Object)this.type) + " to " + (Object)((Object)Datatype.FLOAT));
        }
        return (FloatData)this;
    }

    public final Float getFloatValue() {
        return (Float)this.toFloatData().getValue();
    }

    public final void setFloatValue(Float value) {
        this.toFloatData().setValue(value);
    }

    public final boolean isStringData() {
        return this.getType().equals((Object)Datatype.STRING);
    }

    public final StringData toStringData() throws ClassCastException {
        if (!this.isStringData()) {
            throw new ClassCastException("Cannot cast data of type " + (Object)((Object)this.type) + " to " + (Object)((Object)Datatype.STRING));
        }
        return (StringData)this;
    }

    public final String getStringValue() {
        return (String)this.toStringData().getValue();
    }

    public final void setStringValue(String value) {
        this.toStringData().setValue(value);
    }

    public final boolean isCompoundData() {
        return this.getType().equals((Object)Datatype.COMPOUND);
    }

    public final CompoundData toCompoundData() throws ClassCastException {
        if (!this.isCompoundData()) {
            throw new ClassCastException("Cannot cast data of type " + (Object)((Object)this.type) + " to " + (Object)((Object)Datatype.COMPOUND));
        }
        return (CompoundData)this;
    }

    public final Map<String, Data<?>> getCompoundValue() {
        return (Map)this.toCompoundData().getValue();
    }

    public final boolean isListData() {
        return this.isBooleanListData() || this.isIntegerListData() || this.isStringListData() || this.isCompoundListData();
    }

    public final ListData<?> toListData() throws ClassCastException {
        if (!this.isListData()) {
            throw new ClassCastException("Cannot cast data of type " + (Object)((Object)this.type) + " to LIST");
        }
        return (ListData)this;
    }

    public final List<?> getListValue() {
        return (List)this.toListData().getValue();
    }

    public final boolean isBooleanListData() {
        return this.getType().equals((Object)Datatype.BOOLEAN_LIST);
    }

    public final BooleanListData toBooleanListData() throws ClassCastException {
        if (!this.isBooleanListData()) {
            throw new ClassCastException("Cannot cast data of type " + (Object)((Object)this.type) + " to " + (Object)((Object)Datatype.BOOLEAN_LIST));
        }
        return (BooleanListData)this;
    }

    public final List<Boolean> getBooleanListValue() {
        return (List)this.toBooleanListData().getValue();
    }

    public final boolean isIntegerListData() {
        return this.getType().equals((Object)Datatype.INTEGER_LIST);
    }

    public final IntegerListData toIntegerListData() throws ClassCastException {
        if (!this.isIntegerListData()) {
            throw new ClassCastException("Cannot cast data of type " + (Object)((Object)this.type) + " to " + (Object)((Object)Datatype.INTEGER_LIST));
        }
        return (IntegerListData)this;
    }

    public final List<Integer> getIntegerListValue() {
        return (List)this.toIntegerListData().getValue();
    }

    public final boolean isFloatListData() {
        return this.getType().equals((Object)Datatype.FLOAT_LIST);
    }

    public final FloatListData toFloatListData() throws ClassCastException {
        if (!this.isFloatListData()) {
            throw new ClassCastException("Cannot cast data of type " + (Object)((Object)this.type) + " to " + (Object)((Object)Datatype.FLOAT_LIST));
        }
        return (FloatListData)this;
    }

    public final List<Float> getFloatListValue() {
        return (List)this.toFloatListData().getValue();
    }

    public final boolean isStringListData() {
        return this.getType().equals((Object)Datatype.STRING_LIST);
    }

    public final StringListData toStringListData() throws ClassCastException {
        if (!this.isStringListData()) {
            throw new ClassCastException("Cannot cast data of type " + (Object)((Object)this.type) + " to " + (Object)((Object)Datatype.STRING_LIST));
        }
        return (StringListData)this;
    }

    public final List<String> getStringListValue() {
        return (List)this.toStringListData().getValue();
    }

    public final boolean isCompoundListData() {
        return this.getType().equals((Object)Datatype.COMPOUND_LIST);
    }

    public final CompoundListData toCompoundListData() throws ClassCastException {
        if (!this.isCompoundListData()) {
            throw new ClassCastException("Cannot cast data of type " + (Object)((Object)this.type) + " to " + (Object)((Object)Datatype.COMPOUND_LIST));
        }
        return (CompoundListData)this;
    }

    public final List<Map<String, Data<?>>> getCompoundListValue() {
        return (List)this.toCompoundListData().getValue();
    }

    public final boolean isMetadata() {
        return this.getType().equals((Object)Datatype.METADATA);
    }

    public final boolean isDocument() {
        return this.getType().equals((Object)Datatype.DOCUMENT);
    }
}

