/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.core.xml;

import conexp.fx.core.collections.Collections3;
import conexp.fx.core.xml.AbstractCompoundData;
import conexp.fx.core.xml.Data;
import conexp.fx.core.xml.Datatype;
import conexp.fx.core.xml.JsoupUtil;
import conexp.fx.core.xml.Key;
import conexp.fx.core.xml.Metadata;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public final class XMLFile
extends AbstractCompoundData {
    private final File file;

    public XMLFile(File file) throws IOException {
        super(Datatype.DOCUMENT, "", XMLFile.readElementFromFile(file), new Metadata(XMLFile.readElementFromFile(file)));
        this.file = file;
    }

    public final File getFile() {
        return this.file;
    }

    private static final synchronized Element readElementFromFile(File file) throws IOException {
        return Jsoup.parse((File)file, null).body();
    }

    public final synchronized void store() throws IOException {
        this.writeDocumentToFile(this.writeDataToDocument());
    }

    private final synchronized Document writeDataToDocument() {
        Document document = new Document("");
        this.writeDataToElement((Map)this.value, (Element)document, document.appendElement("metadata"));
        return document;
    }

    private final synchronized void writeDataToElement(Map<String, Data<?>> map, Element element, Element metadata) {
        block15: for (String key : Collections3.sort(map.keySet())) {
            Data<?> value = map.get(key);
            Element metadata_data = null;
            if (metadata != null) {
                metadata_data = metadata.appendElement("data");
                metadata_data.appendElement("key").text(key);
                metadata_data.appendElement("type").text(value.getType().toString());
                switch (value.getType()) {
                    case BOOLEAN_LIST: 
                    case INTEGER_LIST: 
                    case FLOAT_LIST: 
                    case STRING_LIST: 
                    case COMPOUND_LIST: {
                        JsoupUtil.firstOrAppendElement(metadata_data, "metadata", "subkey").text(value.toListData().getSubkey());
                    }
                }
            }
            Element data = JsoupUtil.firstOrAppendElement(element, Key.toArray(key));
            switch (value.getType()) {
                case BOOLEAN: {
                    data.text(((Boolean)value.toBooleanData().getValue()).toString());
                    break;
                }
                case INTEGER: {
                    data.text(((Integer)value.toIntegerData().getValue()).toString());
                    break;
                }
                case FLOAT: {
                    data.text(((Float)value.toFloatData().getValue()).toString());
                    break;
                }
                case STRING: {
                    data.text((String)value.toStringData().getValue());
                    break;
                }
                case COMPOUND: {
                    this.writeDataToElement(value.toCompoundData(), data, metadata != null ? JsoupUtil.firstOrAppendElement(metadata_data, "metadata") : null);
                    break;
                }
                case BOOLEAN_LIST: {
                    for (Boolean boolean_ : value.toBooleanListData()) {
                        data.appendElement(value.toListData().getSubkey()).text(boolean_.toString());
                    }
                    continue block15;
                }
                case INTEGER_LIST: {
                    for (Integer integer : value.toIntegerListData()) {
                        data.appendElement(value.toListData().getSubkey()).text(integer.toString());
                    }
                    continue block15;
                }
                case FLOAT_LIST: {
                    for (Float floating : value.toFloatListData()) {
                        data.appendElement(value.toListData().getSubkey()).text(floating.toString());
                    }
                    continue block15;
                }
                case STRING_LIST: {
                    for (String string : value.toStringListData()) {
                        data.appendElement(value.toListData().getSubkey()).text(string);
                    }
                    continue block15;
                }
                case COMPOUND_LIST: {
                    int i = 0;
                    for (Map<String, Data<?>> map_ : value.toCompoundListData()) {
                        this.writeDataToElement(map_, data.appendElement(value.toListData().getSubkey()), i++ == 0 && metadata != null ? JsoupUtil.firstOrAppendElement(metadata_data, "metadata") : null);
                    }
                    break;
                }
            }
        }
    }

    private final synchronized void writeDocumentToFile(Document document) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.file));
        bufferedWriter.append(document.toString());
        bufferedWriter.close();
    }

    public static final void createEmptyConfiguration(File file) throws IOException {
        file.createNewFile();
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.append("<metadata>\r\n</metadata>");
        bufferedWriter.close();
    }
}

