/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.assistent;

import conexp.fx.core.exporter.TeXExporter;
import conexp.fx.core.util.FileFormat;
import conexp.fx.gui.ConExpFX;
import conexp.fx.gui.assistent.Assistent;
import conexp.fx.gui.assistent.AssistentPage;
import conexp.fx.gui.dataset.FCADataset;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javafx.beans.Observable;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckBoxBuilder;
import javafx.scene.control.RadioButton;
import javafx.scene.control.RadioButtonBuilder;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.ToggleGroupBuilder;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBoxBuilder;
import javafx.scene.layout.VBox;
import javafx.scene.layout.VBoxBuilder;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.StringConverter;
import javafx.util.converter.IntegerStringConverter;
import jfxtras.scene.control.ListSpinner;

public class ExportAssistent
extends Assistent<String> {
    private final FCADataset fcaInstance;

    public ExportAssistent(Stage owner, FCADataset<?, ?> fcaInstance) {
        super(owner, "Export Wizard", "Export Wizard", "Exports a Formal Context", null, r -> r.equals("TEX") ? "TEX" : null);
        this.fcaInstance = fcaInstance;
        this.initialize();
    }

    @Override
    protected Node createInitialNode() {
        BorderPane pane = new BorderPane();
        final ToggleGroup toggleGroup = new ToggleGroup();
        RadioButton htmlButton = new RadioButton("HTML");
        RadioButton pdfButton = new RadioButton("PDF");
        RadioButton pngButton = new RadioButton("PNG");
        RadioButton svgButton = new RadioButton("SVG");
        RadioButton texButton = new RadioButton("LaTeX");
        htmlButton.setToggleGroup(toggleGroup);
        pdfButton.setToggleGroup(toggleGroup);
        pngButton.setToggleGroup(toggleGroup);
        svgButton.setToggleGroup(toggleGroup);
        texButton.setToggleGroup(toggleGroup);
        htmlButton.setUserData((Object)"HTML");
        pdfButton.setUserData((Object)"PDF");
        pngButton.setUserData((Object)"PNG");
        svgButton.setUserData((Object)"SVG");
        texButton.setUserData((Object)"TEX");
        VBox toggleBox = new VBox(new Node[]{htmlButton, pdfButton, pngButton, svgButton, texButton});
        this.resultProperty.bind((ObservableValue)new ObjectBinding<String>(){
            {
                super.bind(new Observable[]{toggleGroup.selectedToggleProperty()});
            }

            protected String computeValue() {
                Toggle toggle = (Toggle)toggleGroup.selectedToggleProperty().get();
                if (toggle == null) {
                    return null;
                }
                return (String)toggle.getUserData();
            }
        });
        pane.setPadding(new Insets(4.0));
        pane.setCenter((Node)toggleBox);
        return pane;
    }

    @Override
    protected void createPages() {
        this.availablePages.put("TEX", new TeXExportPage(this.fcaInstance));
    }

    @Override
    protected void onNext() {
        File result;
        if (!((String)this.resultProperty.get()).equals("TEX") && (result = this.showFileChooser()) != null) {
            this.fcaInstance.export(FileFormat.valueOf((String)this.resultProperty.get()), result);
        }
    }

    private final File showFileChooser() {
        FileChooser fc = new FileChooser();
        fc.setInitialDirectory(ConExpFX.instance.lastDirectory);
        return fc.showSaveDialog((Window)this.owner);
    }

    public final class TeXExportPage
    extends AssistentPage<TeXExporter.TeXOptions> {
        private final FCADataset<?, ?> fcaInstance;

        public TeXExportPage(FCADataset<?, ?> fcaInstance) {
            super("TeX Export", "Exports a Formal Context and its Concept Lattice to LaTeX", null, r -> null);
            this.fcaInstance = fcaInstance;
            this.resultProperty.set((Object)new TeXExporter.TeXOptions(null, false, false, false, null, null, null));
            this.contentProperty.set((Object)this.createContentNode());
        }

        @Override
        protected void onNext() {
            try {
                ((TeXExporter.TeXOptions)this.resultProperty.get()).file = ExportAssistent.this.showFileChooser();
                new TeXExporter(this.fcaInstance.context, (Map<Integer, Integer>)this.fcaInstance.contextWidget.rowHeaderPane.rowMap, (Map<Integer, Integer>)this.fcaInstance.contextWidget.colHeaderPane.columnMap, this.fcaInstance.layout, (TeXExporter.TeXOptions)this.resultProperty.get()).export();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        protected Node createContentNode() {
            VBox box = new VBox();
            box.setPadding(new Insets(0.0, 10.0, 0.0, 10.0));
            box.setSpacing(4.0);
            this.resultProperty.set((Object)new TeXExporter.TeXOptions(null, false, true, false, TeXExporter.ContextTeXPackage.None, TeXExporter.DiagramTeXPackage.ConExpFX, new TeXExporter.FitScale(80, 120)));
            CheckBox arrowsCheckBox = ((CheckBoxBuilder)CheckBoxBuilder.create().text("Arrow Relations")).build();
            CheckBox labelsCheckBox = ((CheckBoxBuilder)CheckBoxBuilder.create().text("Concept Labels")).selected(true).build();
            CheckBox standAloneCheckBox = ((CheckBoxBuilder)((CheckBoxBuilder)CheckBoxBuilder.create().disable(true)).text("Stand-Alone Document")).build();
            RadioButton noneContextButton = ((RadioButtonBuilder)((RadioButtonBuilder)((RadioButtonBuilder)RadioButtonBuilder.create().text("Context Package: None")).selected(true)).userData((Object)TeXExporter.ContextTeXPackage.None)).build();
            RadioButton ganterContextButton = ((RadioButtonBuilder)((RadioButtonBuilder)RadioButtonBuilder.create().text("Context Package: Ganter")).userData((Object)TeXExporter.ContextTeXPackage.Ganter)).build();
            RadioButton tabularContextButton = ((RadioButtonBuilder)((RadioButtonBuilder)RadioButtonBuilder.create().text("Context Package: Tabular")).userData((Object)TeXExporter.ContextTeXPackage.Tabular)).build();
            RadioButton noneDiagramButton = ((RadioButtonBuilder)((RadioButtonBuilder)RadioButtonBuilder.create().text("Diagram Package: None")).userData((Object)TeXExporter.DiagramTeXPackage.None)).build();
            RadioButton ganterDiagramButton = ((RadioButtonBuilder)((RadioButtonBuilder)RadioButtonBuilder.create().text("Diagram Package: Ganter")).userData((Object)TeXExporter.DiagramTeXPackage.Ganter)).build();
            RadioButton conExpFXDiagramButton = ((RadioButtonBuilder)((RadioButtonBuilder)((RadioButtonBuilder)RadioButtonBuilder.create().text("Diagram Package: ConExpFX")).selected(true)).userData((Object)TeXExporter.DiagramTeXPackage.ConExpFX)).build();
            RadioButton fitButton = ((RadioButtonBuilder)((RadioButtonBuilder)RadioButtonBuilder.create().text("Diagram Scale: Fit")).userData((Object)TeXExporter.ScaleEnum.Fit)).build();
            RadioButton fitWidthButton = ((RadioButtonBuilder)((RadioButtonBuilder)RadioButtonBuilder.create().text("Diagram Scale: Fit Width")).userData((Object)TeXExporter.ScaleEnum.FitWidth)).build();
            RadioButton fitHeightButton = ((RadioButtonBuilder)((RadioButtonBuilder)RadioButtonBuilder.create().text("Diagram Scale: Fit Height")).userData((Object)TeXExporter.ScaleEnum.FitHeight)).build();
            RadioButton fitRatioButton = ((RadioButtonBuilder)((RadioButtonBuilder)((RadioButtonBuilder)RadioButtonBuilder.create().text("Diagram Scale: Fit Ratio")).selected(true)).userData((Object)TeXExporter.ScaleEnum.FitRatio)).build();
            final ListSpinner widthSpinner = new ListSpinner(1, 1000);
            final ListSpinner heightSpinner = new ListSpinner(1, 1000);
            widthSpinner.valueProperty().set((Object)80);
            heightSpinner.valueProperty().set((Object)120);
            widthSpinner.withPostfix("mm");
            heightSpinner.withPostfix("mm");
            widthSpinner.withEditable(Boolean.valueOf(true));
            widthSpinner.withStringConverter((StringConverter)new IntegerStringConverter());
            heightSpinner.withEditable(Boolean.valueOf(true));
            heightSpinner.withStringConverter((StringConverter)new IntegerStringConverter());
            widthSpinner.setMinWidth(100.0);
            widthSpinner.setMaxWidth(100.0);
            heightSpinner.setMinWidth(100.0);
            heightSpinner.setMaxWidth(100.0);
            ToggleGroup contextGroup = ToggleGroupBuilder.create().toggles(new Toggle[]{noneContextButton, ganterContextButton, tabularContextButton}).build();
            ToggleGroup diagramGroup = ToggleGroupBuilder.create().toggles(new Toggle[]{noneDiagramButton, ganterDiagramButton, conExpFXDiagramButton}).build();
            final ToggleGroup scaleGroup = ToggleGroupBuilder.create().toggles(new Toggle[]{fitButton, fitWidthButton, fitHeightButton, fitRatioButton}).build();
            arrowsCheckBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    ((TeXExporter.TeXOptions)TeXExportPage.this.resultProperty.get()).arrows = newValue;
                }
            });
            labelsCheckBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    ((TeXExporter.TeXOptions)TeXExportPage.this.resultProperty.get()).labels = newValue;
                }
            });
            standAloneCheckBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    ((TeXExporter.TeXOptions)TeXExportPage.this.resultProperty.get()).standAlone = newValue;
                }
            });
            contextGroup.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

                public void changed(ObservableValue<? extends Toggle> observable, Toggle oldToggle, Toggle newToggle) {
                    ((TeXExporter.TeXOptions)TeXExportPage.this.resultProperty.get()).contextTeXPackage = (TeXExporter.ContextTeXPackage)((Object)newToggle.getUserData());
                }
            });
            diagramGroup.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

                public void changed(ObservableValue<? extends Toggle> observable, Toggle oldToggle, Toggle newToggle) {
                    ((TeXExporter.TeXOptions)TeXExportPage.this.resultProperty.get()).diagramTeXPackage = (TeXExporter.DiagramTeXPackage)((Object)newToggle.getUserData());
                }
            });
            scaleGroup.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

                public void changed(ObservableValue<? extends Toggle> observable, Toggle oldToggle, Toggle newToggle) {
                    ((TeXExporter.TeXOptions)TeXExportPage.this.resultProperty.get()).scale = ((TeXExporter.ScaleEnum)((Object)newToggle.getUserData())).toOption((Integer)widthSpinner.valueProperty().get(), (Integer)heightSpinner.valueProperty().get());
                    widthSpinner.disableProperty().set((TeXExporter.ScaleEnum)((Object)newToggle.getUserData()) == TeXExporter.ScaleEnum.FitHeight);
                    heightSpinner.disableProperty().set((TeXExporter.ScaleEnum)((Object)newToggle.getUserData()) == TeXExporter.ScaleEnum.FitWidth);
                }
            });
            widthSpinner.valueProperty().addListener((ChangeListener)new ChangeListener<Integer>(){

                public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
                    ((TeXExporter.TeXOptions)TeXExportPage.this.resultProperty.get()).scale = ((TeXExporter.ScaleEnum)((Object)((Toggle)scaleGroup.selectedToggleProperty().get()).getUserData())).toOption(newValue, (Integer)heightSpinner.valueProperty().get());
                }
            });
            heightSpinner.valueProperty().addListener((ChangeListener)new ChangeListener<Integer>(){

                public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
                    ((TeXExporter.TeXOptions)TeXExportPage.this.resultProperty.get()).scale = ((TeXExporter.ScaleEnum)((Object)((Toggle)scaleGroup.selectedToggleProperty().get()).getUserData())).toOption((Integer)widthSpinner.valueProperty().get(), newValue);
                }
            });
            box.getChildren().addAll((Object[])new Node[]{((VBoxBuilder)((VBoxBuilder)VBoxBuilder.create().padding(new Insets(2.0, 0.0, 2.0, 0.0))).spacing(4.0).children(new Node[]{arrowsCheckBox, labelsCheckBox, standAloneCheckBox})).build()});
            box.getChildren().addAll((Object[])new Node[]{((VBoxBuilder)((VBoxBuilder)VBoxBuilder.create().padding(new Insets(2.0, 0.0, 2.0, 0.0))).spacing(4.0).children(new Node[]{noneContextButton, ganterContextButton, tabularContextButton})).build()});
            box.getChildren().addAll((Object[])new Node[]{((VBoxBuilder)((VBoxBuilder)VBoxBuilder.create().padding(new Insets(2.0, 0.0, 2.0, 0.0))).spacing(4.0).children(new Node[]{noneDiagramButton, ganterDiagramButton, conExpFXDiagramButton})).build()});
            box.getChildren().addAll((Object[])new Node[]{((VBoxBuilder)((VBoxBuilder)VBoxBuilder.create().padding(new Insets(2.0, 0.0, 0.0, 0.0))).spacing(4.0).children(new Node[]{fitButton, fitWidthButton, fitHeightButton, fitRatioButton})).build()});
            box.getChildren().addAll((Object[])new Node[]{((HBoxBuilder)((HBoxBuilder)HBoxBuilder.create().padding(new Insets(0.0, 0.0, 2.0, 0.0))).spacing(4.0).children(new Node[]{widthSpinner, heightSpinner})).build()});
            return box;
        }
    }
}

