/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.assistent;

import conexp.fx.core.builder.Request;
import conexp.fx.core.builder.Requests;
import conexp.fx.core.collections.Pair;
import conexp.fx.core.collections.setlist.HashSetArrayList;
import conexp.fx.core.context.MatrixContext;
import conexp.fx.core.util.FileFormat;
import conexp.fx.gui.ConExpFX;
import conexp.fx.gui.assistent.AssistentPage;
import conexp.fx.gui.dataset.FCADataset;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.InsetsBuilder;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBuilder;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ChoiceBoxBuilder;
import javafx.scene.control.Label;
import javafx.scene.control.LabelBuilder;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextAreaBuilder;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFieldBuilder;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.GridPaneBuilder;
import javafx.scene.layout.HBox;
import javafx.scene.text.FontBuilder;
import jfxtras.scene.control.ListSpinner;
import org.openrdf.repository.Repository;
import org.openrdf.repository.http.HTTPRepository;

public class TypePage
extends AssistentPage<Request<?, ?>> {
    private final Requests.Type type;
    private final Accordion accordion = new Accordion();

    public TypePage(Requests.Type type) {
        super(type.title, type.description, null, null);
        this.contentProperty.set((Object)this.accordion);
        this.type = type;
        if (type.sources.contains((Object)Requests.Source.NULL)) {
            this.resultProperty.set(null);
        }
        for (Requests.Source source : type.sources) {
            this.accordion.getPanes().add((Object)this.createSourcePane(source));
        }
        this.accordion.expandedPaneProperty().addListener((ChangeListener)new ChangeListener<TitledPane>(){

            public void changed(ObservableValue<? extends TitledPane> observable, TitledPane oldValue, TitledPane newValue) {
                if (newValue == null) {
                    TypePage.this.resultProperty.unbind();
                    TypePage.this.resultProperty.set(null);
                } else {
                    TypePage.this.resultProperty.bind(((SourcePane)newValue).result);
                }
            }
        });
        this.accordion.setExpandedPane((TitledPane)this.accordion.getPanes().get(0));
    }

    private final SourcePane createSourcePane(Requests.Source src) {
        switch (src) {
            case NULL: {
                return this.nullPane();
            }
            case INT_INT: {
                return this.intIntPane();
            }
            case INT: {
                return this.intPane();
            }
            case INT_LIST: {
                return this.intListPane();
            }
            case STRINGS: {
                return this.stringsPane();
            }
            case ORDER: {
                return this.orderPane();
            }
            case ORDER_ORDER: {
                return this.orderOrderPane();
            }
            case CONTEXT: {
                return this.contextPane();
            }
            case CONTEXT_DOUBLE: {
                return this.contextDoublePane();
            }
            case CONTEXT_CONTEXT: {
                return this.contextContextPane();
            }
            case CONTEXT_CONTEXT_CONTEXT_CONTEXT: {
                return this.contextContextContextContextPane();
            }
            case CONTEXT_CONTEXT_OBJECT_OBJECT: {
                return this.contextContextObjectObjectPane();
            }
            case CONTEXT_SET_SET: {
                return this.contextSetSetPane();
            }
            case FILE: {
                return this.filePane();
            }
            case SPARQL_AND_XMLURL: {
                return this.queryURLPane();
            }
            case SPARQL_AND_ONTOLOGYFILE: {
                return this.queryFilePane();
            }
            case SPARQL_AND_ONTOLOGYURL: {
                return this.queryURLPane2();
            }
            case SPARQL_AND_ONTOLOGYREPOSITORY: {
                return this.queryRepositoryPane();
            }
        }
        return null;
    }

    private GridPane newGridPane() {
        return ((GridPaneBuilder)((GridPaneBuilder)GridPaneBuilder.create().hgap(10.0).vgap(10.0).maxWidth(480.0)).padding(InsetsBuilder.create().left(10.0).right(10.0).top(10.0).bottom(10.0).build())).build();
    }

    private final SourcePane nullPane() {
        return new SourcePane(Requests.Source.NULL, (Node)this.newGridPane(), (ObservableValue)new SimpleObjectProperty((Object)new Requests.Scale.DichtomicScale()));
    }

    private final SourcePane intIntPane() {
        GridPane pane = this.newGridPane();
        final ListSpinner objectSpinner = new ListSpinner(0, 1024);
        final ListSpinner attributeSpinner = new ListSpinner(0, 1024);
        pane.add((Node)((LabelBuilder)LabelBuilder.create().text("Number of Objects: ")).build(), 0, 0);
        pane.add((Node)objectSpinner, 1, 0);
        pane.add((Node)((LabelBuilder)LabelBuilder.create().text("Number of Attribute): ")).build(), 0, 1);
        pane.add((Node)attributeSpinner, 1, 1);
        return new SourcePane(Requests.Source.INT_INT, (Node)pane, (ObservableValue)new ObjectBinding<Request<?, ?>>(){
            {
                this.bind(new Observable[]{objectSpinner.valueProperty(), attributeSpinner.valueProperty()});
            }

            protected final Request<?, ?> computeValue() {
                return new Requests.New.NewContext((Integer)objectSpinner.getValue(), (Integer)attributeSpinner.getValue());
            }
        });
    }

    private final SourcePane intPane() {
        GridPane pane = this.newGridPane();
        final ListSpinner elementSpinner = new ListSpinner(0, 1024);
        pane.add((Node)((LabelBuilder)LabelBuilder.create().text("Number of Elements: ")).build(), 0, 0);
        pane.add((Node)elementSpinner, 1, 0);
        return new SourcePane(Requests.Source.INT, (Node)pane, (ObservableValue)new ObjectBinding<Request<?, ?>>(){
            {
                this.bind(new Observable[]{elementSpinner.valueProperty()});
            }

            protected final Request<?, ?> computeValue() {
                return new Requests.New.NewOrder((Integer)elementSpinner.getValue());
            }
        });
    }

    private final SourcePane intListPane() {
        GridPane pane = this.newGridPane();
        final ListSpinner nSpinner = new ListSpinner(0, 1024);
        nSpinner.setMinWidth(100.0);
        pane.add((Node)((LabelBuilder)LabelBuilder.create().text("n = ")).build(), 0, 0);
        pane.add((Node)nSpinner, 1, 0);
        return new SourcePane(Requests.Source.INT_LIST, (Node)pane, (ObservableValue)new ObjectBinding<Request<?, ?>>(){
            {
                this.bind(new Observable[]{nSpinner.valueProperty()});
            }

            protected final Request<?, ?> computeValue() {
                switch (TypePage.this.type) {
                    case BOOLEAN: {
                        return new Requests.Scale.BooleanScaleFromInt((Integer)nSpinner.getValue());
                    }
                    case NOMINAL: {
                        return new Requests.Scale.NominalScaleFromInt((Integer)nSpinner.getValue());
                    }
                    case CONTRA_NOMINAL: {
                        return new Requests.Scale.ContraNominalScaleFromInt((Integer)nSpinner.getValue());
                    }
                    case ORDINAL: {
                        return new Requests.Scale.OrdinalScaleFromInt((Integer)nSpinner.getValue());
                    }
                    case CONTRA_ORDINAL: {
                        return new Requests.Scale.ContraOrdinalScaleFromInt((Integer)nSpinner.getValue());
                    }
                    case INTER_ORDINAL: {
                        return new Requests.Scale.InterOrdinalScaleFromInt((Integer)nSpinner.getValue());
                    }
                    case CONVEX_ORDINAL: {
                        return new Requests.Scale.ConvexOrdinalScaleFromInt((Integer)nSpinner.getValue());
                    }
                }
                return null;
            }
        });
    }

    private final SourcePane stringsPane() {
        GridPane pane = this.newGridPane();
        final TextField textField = ((TextFieldBuilder)((TextFieldBuilder)TextFieldBuilder.create().minWidth(260.0)).maxWidth(260.0)).build();
        pane.add((Node)((LabelBuilder)LabelBuilder.create().text("Semicolon separated Elements:")).build(), 0, 0);
        pane.add((Node)textField, 1, 0);
        return new SourcePane(Requests.Source.STRINGS, (Node)pane, (ObservableValue)new ObjectBinding<Request<?, ?>>(){
            {
                this.bind(new Observable[]{textField.textProperty()});
            }

            protected final Request<?, ?> computeValue() {
                HashSetArrayList<String> s = new HashSetArrayList<String>(Arrays.asList(((String)textField.textProperty().get()).split(";")));
                switch (TypePage.this.type) {
                    case BOOLEAN: {
                        return new Requests.Scale.BooleanScaleFromSetList<String>(s);
                    }
                    case NOMINAL: {
                        return new Requests.Scale.NominalScaleFromSetList<String>(s);
                    }
                    case CONTRA_NOMINAL: {
                        return new Requests.Scale.ContraNominalScaleFromSetList<String>(s);
                    }
                    case ORDINAL: {
                        return new Requests.Scale.OrdinalScaleFromSetList<String>(s);
                    }
                    case CONTRA_ORDINAL: {
                        return new Requests.Scale.ContraOrdinalScaleFromSetList<String>(s);
                    }
                    case INTER_ORDINAL: {
                        return new Requests.Scale.InterOrdinalScaleFromSetList<String>(s);
                    }
                    case CONVEX_ORDINAL: {
                        return new Requests.Scale.ConvexOrdinalScaleFromSetList<String>(s);
                    }
                }
                return null;
            }
        });
    }

    private final SourcePane orderPane() {
        GridPane pane = this.newGridPane();
        final ChoiceBox orderChoice = ((ChoiceBoxBuilder)((ChoiceBoxBuilder)ChoiceBoxBuilder.create().minWidth(320.0)).maxWidth(320.0)).items(ConExpFX.instance.orders).build();
        pane.add((Node)((LabelBuilder)LabelBuilder.create().text("Order Context:")).build(), 0, 0);
        pane.add((Node)orderChoice, 1, 0);
        return new SourcePane(Requests.Source.ORDER, (Node)pane, (ObservableValue)new ObjectBinding<Request<?, ?>>(){
            {
                this.bind(new Observable[]{orderChoice.valueProperty()});
            }

            protected final Request<?, ?> computeValue() {
                switch (TypePage.this.type) {
                    case CONTRA_ORDINAL: {
                        return new Requests.Scale.ContraOrdinalScaleFromOrder((MatrixContext)orderChoice.valueProperty().get());
                    }
                    case INTER_ORDINAL: {
                        return new Requests.Scale.InterOrdinalScaleFromOrder((MatrixContext)orderChoice.valueProperty().get());
                    }
                    case CONVEX_ORDINAL: {
                        return new Requests.Scale.ConvexOrdinalScaleFromOrder((MatrixContext)orderChoice.valueProperty().get());
                    }
                }
                return null;
            }
        });
    }

    private final SourcePane orderOrderPane() {
        GridPane pane = this.newGridPane();
        final ChoiceBox order1Choice = ((ChoiceBoxBuilder)((ChoiceBoxBuilder)ChoiceBoxBuilder.create().minWidth(320.0)).maxWidth(320.0)).items(ConExpFX.instance.orders).build();
        final ChoiceBox order2Choice = ((ChoiceBoxBuilder)((ChoiceBoxBuilder)ChoiceBoxBuilder.create().minWidth(320.0)).maxWidth(320.0)).items(ConExpFX.instance.orders).build();
        pane.add((Node)((LabelBuilder)LabelBuilder.create().text("First Order Context:")).build(), 0, 0);
        pane.add((Node)order1Choice, 1, 0);
        pane.add((Node)((LabelBuilder)LabelBuilder.create().text("Second Order Context:")).build(), 0, 1);
        pane.add((Node)order2Choice, 1, 1);
        return new SourcePane(Requests.Source.ORDER_ORDER, (Node)pane, (ObservableValue)new ObjectBinding<Request<?, ?>>(){
            {
                this.bind(new Observable[]{order1Choice.valueProperty(), order2Choice.valueProperty()});
            }

            protected final Request<?, ?> computeValue() {
                switch (TypePage.this.type) {
                    case BI_ORDINAL: {
                        return new Requests.Scale.BiOrdinalScale((MatrixContext)order1Choice.valueProperty().get(), (MatrixContext)order2Choice.valueProperty().get());
                    }
                    case GRID: {
                        return new Requests.Scale.GridScale((MatrixContext)order1Choice.valueProperty().get(), (MatrixContext)order2Choice.valueProperty().get());
                    }
                }
                return null;
            }
        });
    }

    private final SourcePane contextPane() {
        GridPane pane = this.newGridPane();
        final ChoiceBox contextChoice = ((ChoiceBoxBuilder)((ChoiceBoxBuilder)ChoiceBoxBuilder.create().minWidth(320.0)).maxWidth(320.0)).items(ConExpFX.instance.contexts).build();
        pane.add((Node)((LabelBuilder)LabelBuilder.create().text("Formal Context:")).build(), 0, 0);
        pane.add((Node)contextChoice, 1, 0);
        return new SourcePane(Requests.Source.CONTEXT, (Node)pane, (ObservableValue)new ObjectBinding<Request<?, ?>>(){
            {
                this.bind(new Observable[]{contextChoice.valueProperty()});
            }

            protected final Request<?, ?> computeValue() {
                switch (TypePage.this.type) {
                    case COMPLEMENT: {
                        return new Requests.Construct.Complement((MatrixContext)contextChoice.valueProperty().get());
                    }
                    case DUAL: {
                        return new Requests.Construct.Dual((MatrixContext)contextChoice.valueProperty().get());
                    }
                    case CONTRARY: {
                        return new Requests.Construct.Contrary((MatrixContext)contextChoice.valueProperty().get());
                    }
                }
                return null;
            }
        });
    }

    private final SourcePane contextDoublePane() {
        GridPane pane = this.newGridPane();
        final ChoiceBox contextChoice = ((ChoiceBoxBuilder)((ChoiceBoxBuilder)ChoiceBoxBuilder.create().minWidth(320.0)).maxWidth(320.0)).items(ConExpFX.instance.contexts).build();
        pane.add((Node)((LabelBuilder)LabelBuilder.create().text("Formal Context:")).build(), 0, 0);
        pane.add((Node)contextChoice, 1, 0);
        final ListSpinner toleranceSpinner = new ListSpinner(0, 100);
        pane.add((Node)((LabelBuilder)LabelBuilder.create().text("Tolerance (%): ")).build(), 0, 1);
        pane.add((Node)toleranceSpinner, 1, 1);
        return new SourcePane(Requests.Source.CONTEXT_DOUBLE, (Node)pane, (ObservableValue)new ObjectBinding<Request<?, ?>>(){
            {
                this.bind(new Observable[]{contextChoice.valueProperty(), toleranceSpinner.valueProperty()});
            }

            protected final Request<?, ?> computeValue() {
                switch (TypePage.this.type) {
                    default: 
                }
                return null;
            }
        });
    }

    private final SourcePane contextContextPane() {
        GridPane pane = this.newGridPane();
        final ChoiceBox context1Choice = ((ChoiceBoxBuilder)((ChoiceBoxBuilder)ChoiceBoxBuilder.create().minWidth(320.0)).maxWidth(320.0)).items(ConExpFX.instance.contexts).build();
        final ChoiceBox context2Choice = ((ChoiceBoxBuilder)((ChoiceBoxBuilder)ChoiceBoxBuilder.create().minWidth(320.0)).maxWidth(320.0)).items(ConExpFX.instance.contexts).build();
        pane.add((Node)((LabelBuilder)LabelBuilder.create().text("First Formal Context:")).build(), 0, 0);
        pane.add((Node)context1Choice, 1, 0);
        pane.add((Node)((LabelBuilder)LabelBuilder.create().text("Second Formal Context:")).build(), 0, 1);
        pane.add((Node)context2Choice, 1, 1);
        return new SourcePane(Requests.Source.CONTEXT_CONTEXT, (Node)pane, (ObservableValue)new ObjectBinding<Request<?, ?>>(){
            {
                this.bind(new Observable[]{context1Choice.valueProperty(), context2Choice.valueProperty()});
            }

            protected final Request<?, ?> computeValue() {
                switch (TypePage.this.type) {
                    case APPOSITION: {
                        return new Requests.Construct.Apposition((MatrixContext)context1Choice.valueProperty().get(), (MatrixContext)context2Choice.valueProperty().get());
                    }
                    case SUBPOSITION: {
                        return new Requests.Construct.Subposition((MatrixContext)context1Choice.valueProperty().get(), (MatrixContext)context2Choice.valueProperty().get());
                    }
                    case HORIZONTAL_SUM: {
                        return new Requests.Construct.HorizontalSum((MatrixContext)context1Choice.valueProperty().get(), (MatrixContext)context2Choice.valueProperty().get());
                    }
                    case VERTICAL_SUM: {
                        return new Requests.Construct.VerticalSum((MatrixContext)context1Choice.valueProperty().get(), (MatrixContext)context2Choice.valueProperty().get());
                    }
                    case DIRECT_SUM: {
                        return new Requests.Construct.DirectSum((MatrixContext)context1Choice.valueProperty().get(), (MatrixContext)context2Choice.valueProperty().get());
                    }
                    case DIRECT_PRODUCT: {
                        return new Requests.Construct.DirectProduct((MatrixContext)context1Choice.valueProperty().get(), (MatrixContext)context2Choice.valueProperty().get());
                    }
                    case BI_PRODUCT: {
                        return new Requests.Construct.BiProduct((MatrixContext)context1Choice.valueProperty().get(), (MatrixContext)context2Choice.valueProperty().get());
                    }
                    case SEMI_PRODUCT: {
                        return new Requests.Construct.SemiProduct((MatrixContext)context1Choice.valueProperty().get(), (MatrixContext)context2Choice.valueProperty().get());
                    }
                }
                return null;
            }
        });
    }

    private final SourcePane contextContextContextContextPane() {
        GridPane pane = this.newGridPane();
        final ChoiceBox context1Choice = ((ChoiceBoxBuilder)((ChoiceBoxBuilder)ChoiceBoxBuilder.create().minWidth(320.0)).maxWidth(320.0)).items(ConExpFX.instance.contexts).build();
        final ChoiceBox context2Choice = ((ChoiceBoxBuilder)((ChoiceBoxBuilder)ChoiceBoxBuilder.create().minWidth(320.0)).maxWidth(320.0)).items(ConExpFX.instance.contexts).build();
        final ChoiceBox context3Choice = ((ChoiceBoxBuilder)((ChoiceBoxBuilder)ChoiceBoxBuilder.create().minWidth(320.0)).maxWidth(320.0)).items(ConExpFX.instance.contexts).build();
        final ChoiceBox context4Choice = ((ChoiceBoxBuilder)((ChoiceBoxBuilder)ChoiceBoxBuilder.create().minWidth(320.0)).maxWidth(320.0)).items(ConExpFX.instance.contexts).build();
        pane.add((Node)((LabelBuilder)LabelBuilder.create().text("First Formal Context:")).build(), 0, 0);
        pane.add((Node)context1Choice, 1, 0);
        pane.add((Node)((LabelBuilder)LabelBuilder.create().text("Second Formal Context:")).build(), 0, 1);
        pane.add((Node)context2Choice, 1, 1);
        pane.add((Node)((LabelBuilder)LabelBuilder.create().text("Third Formal Context:")).build(), 0, 2);
        pane.add((Node)context3Choice, 1, 2);
        pane.add((Node)((LabelBuilder)LabelBuilder.create().text("Fourth Formal Context:")).build(), 0, 3);
        pane.add((Node)context4Choice, 1, 3);
        return new SourcePane(Requests.Source.CONTEXT_CONTEXT_CONTEXT_CONTEXT, (Node)pane, (ObservableValue)new ObjectBinding<Request<?, ?>>(){
            {
                this.bind(new Observable[]{context1Choice.valueProperty(), context2Choice.valueProperty(), context3Choice.valueProperty(), context4Choice.valueProperty()});
            }

            protected final Request<?, ?> computeValue() {
                switch (TypePage.this.type) {
                    case QUADPOSITION: {
                        return new Requests.Construct.Quadposition((MatrixContext)context1Choice.valueProperty().get(), (MatrixContext)context2Choice.valueProperty().get(), (MatrixContext)context3Choice.valueProperty().get(), (MatrixContext)context4Choice.valueProperty().get());
                    }
                }
                return null;
            }
        });
    }

    private final SourcePane contextContextObjectObjectPane() {
        GridPane pane = this.newGridPane();
        final ChoiceBox context1Choice = ((ChoiceBoxBuilder)((ChoiceBoxBuilder)ChoiceBoxBuilder.create().minWidth(320.0)).maxWidth(320.0)).items(ConExpFX.instance.contexts).build();
        final ChoiceBox context2Choice = ((ChoiceBoxBuilder)((ChoiceBoxBuilder)ChoiceBoxBuilder.create().minWidth(320.0)).maxWidth(320.0)).items(ConExpFX.instance.contexts).build();
        final ChoiceBox objectChoice = ((ChoiceBoxBuilder)((ChoiceBoxBuilder)ChoiceBoxBuilder.create().minWidth(320.0)).maxWidth(320.0)).build();
        final ChoiceBox attributeChoice = ((ChoiceBoxBuilder)((ChoiceBoxBuilder)ChoiceBoxBuilder.create().minWidth(320.0)).maxWidth(320.0)).build();
        objectChoice.itemsProperty().bind((ObservableValue)new ObjectBinding<ObservableList<?>>(){
            {
                this.bind(new Observable[]{context1Choice.valueProperty()});
            }

            protected ObservableList<?> computeValue() {
                if (context1Choice.valueProperty().get() == null) {
                    return FXCollections.observableList((List)Collections.EMPTY_LIST);
                }
                return FXCollections.observableList(((MatrixContext)context1Choice.valueProperty().get()).rowHeads());
            }
        });
        attributeChoice.itemsProperty().bind((ObservableValue)new ObjectBinding<ObservableList<?>>(){
            {
                this.bind(new Observable[]{context1Choice.valueProperty()});
            }

            protected ObservableList<?> computeValue() {
                if (context1Choice.valueProperty().get() == null) {
                    return FXCollections.observableList((List)Collections.EMPTY_LIST);
                }
                return FXCollections.observableList(((MatrixContext)context1Choice.valueProperty().get()).colHeads());
            }
        });
        pane.add((Node)((LabelBuilder)LabelBuilder.create().text("First Formal Context:")).build(), 0, 0);
        pane.add((Node)context1Choice, 1, 0);
        pane.add((Node)((LabelBuilder)LabelBuilder.create().text("Second Formal Context:")).build(), 0, 1);
        pane.add((Node)context2Choice, 1, 1);
        pane.add((Node)((LabelBuilder)LabelBuilder.create().text("First Object:")).build(), 0, 2);
        pane.add((Node)objectChoice, 1, 2);
        pane.add((Node)((LabelBuilder)LabelBuilder.create().text("Second Attribute:")).build(), 0, 3);
        pane.add((Node)attributeChoice, 1, 3);
        return new SourcePane(Requests.Source.CONTEXT_CONTEXT_OBJECT_OBJECT, (Node)pane, (ObservableValue)new ObjectBinding<Request<?, ?>>(){
            {
                this.bind(new Observable[]{context1Choice.valueProperty(), context2Choice.valueProperty(), objectChoice.valueProperty(), attributeChoice.valueProperty()});
            }

            protected final Request<?, ?> computeValue() {
                switch (TypePage.this.type) {
                    case SUBSTITUTION_SUM: {
                        return new Requests.Construct.SubstitutionSum((MatrixContext)context1Choice.valueProperty().get(), (MatrixContext)context2Choice.valueProperty().get(), objectChoice.valueProperty().get(), attributeChoice.valueProperty().get());
                    }
                }
                return null;
            }
        });
    }

    private final SourcePane contextSetSetPane() {
        GridPane pane = this.newGridPane();
        final ChoiceBox contextChoice = ((ChoiceBoxBuilder)((ChoiceBoxBuilder)ChoiceBoxBuilder.create().minWidth(320.0)).maxWidth(320.0)).items(ConExpFX.instance.contexts).build();
        pane.add((Node)((LabelBuilder)LabelBuilder.create().text("Formal Context:")).build(), 0, 0);
        pane.add((Node)contextChoice, 1, 0);
        return new SourcePane(Requests.Source.CONTEXT_SET_SET, (Node)pane, (ObservableValue)new ObjectBinding<Request<?, ?>>(){
            {
                this.bind(new Observable[]{contextChoice.valueProperty()});
            }

            protected final Request<?, ?> computeValue() {
                switch (TypePage.this.type) {
                    default: 
                }
                return null;
            }
        });
    }

    private final SourcePane filePane() {
        FileChooseBox fileChooseBox;
        GridPane pane = this.newGridPane();
        switch (this.type) {
            case IMPORT_CFX_CONTEXT: {
                fileChooseBox = new FileChooseBox("Import Concept Explorer FX File", FileFormat.CFX);
                break;
            }
            case IMPORT_CXT_CONTEXT: {
                fileChooseBox = new FileChooseBox("Import Burmeister File", FileFormat.CXT);
                break;
            }
            case IMPORT_CEX_CONTEXT: {
                fileChooseBox = new FileChooseBox("Import Concept Explorer File", FileFormat.CEX);
                break;
            }
            case IMPORT_CSV_CONTEXT: {
                fileChooseBox = new FileChooseBox("Import Binary CSV File", FileFormat.CSVB);
                break;
            }
            default: {
                fileChooseBox = null;
            }
        }
        pane.add((Node)((LabelBuilder)LabelBuilder.create().text("Concept Explorer File: ")).build(), 0, 0);
        pane.add((Node)fileChooseBox, 1, 0);
        return new SourcePane(Requests.Source.FILE, (Node)pane, (ObservableValue)new ObjectBinding<Request<?, ?>>(){
            {
                this.bind(new Observable[]{fileChooseBox.fileProperty});
            }

            protected final Request<?, ?> computeValue() {
                if (fileChooseBox.fileProperty.get() == null) {
                    return null;
                }
                switch (TypePage.this.type) {
                    case IMPORT_CFX_CONTEXT: {
                        return new Requests.Import.ImportCFX((File)((Pair)fileChooseBox.fileProperty.get()).first());
                    }
                    case IMPORT_CXT_CONTEXT: {
                        return new Requests.Import.ImportCXT((File)((Pair)fileChooseBox.fileProperty.get()).first());
                    }
                    case IMPORT_CEX_CONTEXT: {
                        return new Requests.Import.ImportCEX((File)((Pair)fileChooseBox.fileProperty.get()).first());
                    }
                    case IMPORT_CSV_CONTEXT: {
                        return new Requests.Import.ImportCSVB((File)((Pair)fileChooseBox.fileProperty.get()).first());
                    }
                }
                return null;
            }
        });
    }

    private final SourcePane queryURLPane() {
        GridPane pane = this.newGridPane();
        pane.getColumnConstraints().add(0, (Object)new ColumnConstraints(80.0));
        ChoiceBox sampleURLChoice = ChoiceBoxBuilder.create().items(FXCollections.observableArrayList((Object[])new String[]{"FactForge.net", "LinkedLifeData.com"})).build();
        final TextField urlField = ((TextFieldBuilder)TextFieldBuilder.create().text("http://factforge.net/sparql.xml?query=<QUERY>&_implicit=false&implicit=true&_equivalent=false&_form=%2Fsparql")).build();
        final TextArea queryArea = ((TextAreaBuilder)TextAreaBuilder.create().minHeight(230.0)).build();
        sampleURLChoice.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public final void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                switch (newValue) {
                    case "FactForge.net": {
                        urlField.setText("http://factforge.net/sparql.xml?query=<QUERY>&_implicit=false&implicit=true&_equivalent=false&_form=%2Fsparql");
                        break;
                    }
                    case "LinkedLifeData.com": {
                        urlField.setText("http://linkedlifedata.com/sparql.xml?query=<QUERY>&_implicit=false&implicit=true&_form=%2Fsparql");
                    }
                }
            }
        });
        pane.add((Node)((LabelBuilder)((LabelBuilder)LabelBuilder.create().wrapText(true)).text("Enter an URL that computes a SPARQL XML Result. Specify the position of the SPARQL Query with the variable <QUERY>. Within the Query, use the variables ?object and ?attribute to indicate the elements of the constructed formal context. Furthermore use numbered variables, e.g. ?object1, ?object2, ..., if tuples should be created.")).build(), 1, 0);
        pane.add((Node)sampleURLChoice, 1, 1);
        pane.add((Node)((LabelBuilder)LabelBuilder.create().text("URL: ")).build(), 0, 2);
        pane.add((Node)urlField, 1, 2);
        pane.add((Node)((LabelBuilder)LabelBuilder.create().text("SPARQL Query: ")).build(), 0, 3);
        pane.add((Node)queryArea, 1, 3);
        return new SourcePane(Requests.Source.SPARQL_AND_XMLURL, (Node)pane, (ObservableValue)new ObjectBinding<Request<?, ?>>(){
            {
                this.bind(new Observable[]{urlField.textProperty(), queryArea.textProperty()});
            }

            protected final Request<?, ?> computeValue() {
                return new Requests.Import.ImportSPARQLFromEndpoint((String)urlField.textProperty().get(), (String)queryArea.textProperty().get());
            }
        });
    }

    private final SourcePane queryURLPane2() {
        GridPane pane = this.newGridPane();
        pane.getColumnConstraints().add(0, (Object)new ColumnConstraints(80.0));
        final TextField urlField = TextFieldBuilder.create().build();
        final TextArea queryArea = ((TextAreaBuilder)TextAreaBuilder.create().minHeight(230.0)).build();
        pane.add((Node)((LabelBuilder)((LabelBuilder)LabelBuilder.create().wrapText(true)).text("Enter an URL of an ontology on the web. Within the Query, use the variables ?object and ?attribute to indicate the elements of the constructed formal context. Furthermore use numbered variables, e.g. ?object1, ?object2, ..., if tuples should be created.")).build(), 1, 0);
        pane.add((Node)((LabelBuilder)LabelBuilder.create().text("URL: ")).build(), 0, 1);
        pane.add((Node)urlField, 1, 1);
        pane.add((Node)((LabelBuilder)LabelBuilder.create().text("SPARQL Query: ")).build(), 0, 2);
        pane.add((Node)queryArea, 1, 2);
        return new SourcePane(Requests.Source.SPARQL_AND_ONTOLOGYURL, (Node)pane, (ObservableValue)new ObjectBinding<Request<?, ?>>(){
            {
                this.bind(new Observable[]{urlField.textProperty(), queryArea.textProperty()});
            }

            protected final Request<?, ?> computeValue() {
                return new Requests.Import.ImportSPARQLFromURL((String)urlField.textProperty().get(), (String)queryArea.textProperty().get());
            }
        });
    }

    private final SourcePane queryFilePane() {
        GridPane pane = this.newGridPane();
        pane.getColumnConstraints().add(0, (Object)new ColumnConstraints(80.0));
        final FileChooseBox fileChooseBox = new FileChooseBox("Select Ontology File", FileFormat.ANY);
        final TextArea queryArea = ((TextAreaBuilder)TextAreaBuilder.create().minHeight(230.0)).build();
        pane.add((Node)((LabelBuilder)((LabelBuilder)LabelBuilder.create().wrapText(true)).text("Choose a local ontology file. Within the Query, use the variables ?object and ?attribute to indicate the elements of the constructed formal context. Furthermore use numbered variables, e.g. ?object1, ?object2, ..., if tuples should be created.")).build(), 1, 0);
        pane.add((Node)((LabelBuilder)LabelBuilder.create().text("Ontology File: ")).build(), 0, 1);
        pane.add((Node)fileChooseBox, 1, 1);
        pane.add((Node)((LabelBuilder)LabelBuilder.create().text("SPARQL Query: ")).build(), 0, 2);
        pane.add((Node)queryArea, 1, 2);
        return new SourcePane(Requests.Source.SPARQL_AND_ONTOLOGYFILE, (Node)pane, (ObservableValue)new ObjectBinding<Request<?, ?>>(){
            {
                this.bind(new Observable[]{fileChooseBox.fileProperty, queryArea.textProperty()});
            }

            protected final Request<?, ?> computeValue() {
                if (fileChooseBox.fileProperty.get() == null) {
                    return null;
                }
                return new Requests.Import.ImportSPARQLFromFile((File)((Pair)fileChooseBox.fileProperty.get()).first(), (String)queryArea.textProperty().get());
            }
        });
    }

    private final SourcePane queryRepositoryPane() {
        GridPane pane = this.newGridPane();
        pane.getColumnConstraints().add(0, (Object)new ColumnConstraints(105.0));
        final TextField urlField = TextFieldBuilder.create().build();
        final TextField repositoryField = TextFieldBuilder.create().build();
        final TextArea queryArea = ((TextAreaBuilder)TextAreaBuilder.create().minHeight(230.0)).build();
        pane.add((Node)((LabelBuilder)((LabelBuilder)LabelBuilder.create().wrapText(true)).text("Enter an URL of a Sesame Server and a name of a Repository. Within the Query, use the variables ?object and ?attribute to indicate the elements of the constructed formal context. Furthermore use numbered variables, e.g. ?object1, ?object2, ..., if tuples should be created.")).build(), 1, 0);
        pane.add((Node)((LabelBuilder)LabelBuilder.create().text("Sesame Server URL: ")).build(), 0, 1);
        pane.add((Node)urlField, 1, 1);
        pane.add((Node)((LabelBuilder)LabelBuilder.create().text("Repository Name: ")).build(), 0, 2);
        pane.add((Node)repositoryField, 1, 2);
        pane.add((Node)((LabelBuilder)LabelBuilder.create().text("SPARQL Query: ")).build(), 0, 3);
        pane.add((Node)queryArea, 1, 3);
        return new SourcePane(Requests.Source.SPARQL_AND_ONTOLOGYREPOSITORY, (Node)pane, (ObservableValue)new ObjectBinding<Request<?, ?>>(){
            {
                this.bind(new Observable[]{urlField.textProperty(), repositoryField.textProperty(), queryArea.textProperty()});
            }

            protected final Request<?, ?> computeValue() {
                return new Requests.Import.ImportSPARQLFromRepository((Repository)new HTTPRepository((String)urlField.textProperty().get(), (String)repositoryField.textProperty().get()), (String)queryArea.textProperty().get());
            }
        });
    }

    @Override
    protected final void onNext() {
        ConExpFX.instance.treeView.addDataset(new FCADataset(null, (Request)this.resultProperty.get()));
    }

    private final class SourcePane
    extends TitledPane {
        protected final ObservableValue<Request<?, ?>> result;

        private SourcePane(Requests.Source src, Node content, ObservableValue<Request<?, ?>> result) {
            super(src.title, content);
            this.result = result;
            this.setFont(FontBuilder.create().size(16.0).build());
        }
    }

    public final class FileChooseBox
    extends HBox {
        public final ObjectProperty<Pair<File, FileFormat>> fileProperty = new SimpleObjectProperty(null);

        public FileChooseBox(final String title, final FileFormat ... fileFormats) {
            this.setAlignment(Pos.BASELINE_LEFT);
            this.setPadding(new Insets(2.0));
            this.setSpacing(8.0);
            Label chosen = LabelBuilder.create().build();
            chosen.textProperty().bind((ObservableValue)new StringBinding(){
                {
                    this.bind(new Observable[]{FileChooseBox.this.fileProperty});
                }

                protected final String computeValue() {
                    if (FileChooseBox.this.fileProperty.get() == null) {
                        return "unchosen";
                    }
                    return ((File)((Pair)FileChooseBox.this.fileProperty.get()).first()).getName();
                }
            });
            Button choose = ((ButtonBuilder)((ButtonBuilder)ButtonBuilder.create().text("Choose File...")).onAction((EventHandler)new EventHandler<ActionEvent>(){

                public final void handle(ActionEvent event) {
                    FileChooseBox.this.fileProperty.set(ConExpFX.instance.showOpenFileDialog(title, fileFormats));
                }
            })).build();
            this.getChildren().addAll((Object[])new Node[]{chosen, choose});
        }
    }
}

