/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.context;

import conexp.fx.core.context.Implication;
import conexp.fx.gui.dataset.FCADataset;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBuilder;
import javafx.scene.control.TableView;
import javafx.scene.control.TableViewBuilder;
import javafx.scene.control.ToolBar;
import javafx.scene.control.ToolBarBuilder;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;

public class ImplicationWidget<G, M>
extends BorderPane {
    private final FCADataset<G, M> dataset;
    private final TableView<Implication<G, M>> table;
    private final ToolBar toolBar;

    public ImplicationWidget(FCADataset<G, M> dataset) {
        this.dataset = dataset;
        Label confidenceLabel = new Label("Confidence");
        Slider confidenceSlider = new Slider(0.0, 100.0, 100.0);
        confidenceSlider.setBlockIncrement(5.0);
        confidenceSlider.setSnapToTicks(true);
        confidenceSlider.setMajorTickUnit(1.0);
        Label confidenceValue = new Label();
        confidenceValue.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> (int)confidenceSlider.getValue() + "%", (Observable[])new Observable[]{confidenceSlider.valueProperty()}));
        HBox confidenceBox = new HBox(new Node[]{confidenceLabel, confidenceSlider, confidenceValue});
        Label supportLabel = new Label("Support");
        Slider supportSlider = new Slider(0.0, 100.0, 0.0);
        supportSlider.setBlockIncrement(5.0);
        supportSlider.setSnapToTicks(true);
        supportSlider.setMajorTickUnit(1.0);
        Label supportValue = new Label();
        supportValue.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> (int)supportSlider.getValue() + "%", (Observable[])new Observable[]{supportSlider.valueProperty()}));
        HBox supportBox = new HBox(new Node[]{supportLabel, supportSlider, supportValue});
        this.table = TableViewBuilder.create().columns(new TableColumn[]{TableColumnBuilder.create().text("Support").cellValueFactory(p -> Bindings.createObjectBinding(() -> ((Implication)((Object)((Object)((Object)p.getValue())))).getSupport().size(), (Observable[])new Observable[0])).build(), TableColumnBuilder.create().text("Confidence").cellValueFactory(p -> Bindings.createObjectBinding(() -> (int)(100.0 * ((Implication)((Object)((Object)((Object)p.getValue())))).getConfidence()), (Observable[])new Observable[0])).build(), TableColumnBuilder.create().text("Premise").cellValueFactory(p -> Bindings.createObjectBinding(() -> ((Implication)((Object)((Object)((Object)p.getValue())))).getPremise().toString(), (Observable[])new Observable[0])).build(), TableColumnBuilder.create().text("Conclusion").cellValueFactory(p -> Bindings.createObjectBinding(() -> ((Implication)((Object)((Object)((Object)p.getValue())))).getConclusion().toString(), (Observable[])new Observable[0])).build()}).items(dataset.implications).build();
        this.table.itemsProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> dataset.implications.filtered(impl -> impl.getConfidence() >= confidenceSlider.getValue() / 100.0 && (int)(100.0 * ((double)impl.getSupport().size() / (double)dataset.context.rowHeads().size())) >= (int)supportSlider.getValue()), (Observable[])new Observable[]{dataset.implications, confidenceSlider.valueProperty(), supportSlider.valueProperty()}));
        this.setCenter((Node)this.table);
        this.toolBar = ToolBarBuilder.create().items(new Node[]{supportBox, confidenceBox}).build();
        this.setTop((Node)this.toolBar);
        this.table.getFocusModel().focusedItemProperty().addListener((__, ___, newValue) -> {
            if (newValue != null) {
                dataset.conceptGraph.highlight(true, dataset.conceptGraph.highlightRequests.implication(newValue));
            }
        });
    }
}

