/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.dataset;

import conexp.fx.core.util.FileFormat;
import conexp.fx.gui.ConExpFX;
import conexp.fx.gui.dataset.DatasetAction;
import conexp.fx.gui.dataset.DatasetView;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TreeItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;

public abstract class Dataset {
    public File file;
    public FileFormat format;
    public final StringProperty id = new SimpleStringProperty("");
    public final BooleanProperty unsavedChanges = new SimpleBooleanProperty(false);
    public final List<DatasetView<?>> views = new ArrayList();
    public final Set<String> defaultActiveViews = new HashSet<String>();
    public final List<DatasetAction> actions = new ArrayList<DatasetAction>();
    public final Dataset parent;
    public DatasetTreeItem treeItem;

    protected Dataset(Dataset parent) {
        this.parent = parent;
    }

    public Dataset(Dataset parent, File file, FileFormat format) {
        this(parent);
        this.file = file;
        this.format = format;
        this.id.set((Object)file.getName());
    }

    public final DatasetTreeItem getTreeItem() {
        return this.treeItem;
    }

    public final void addToTree(ConExpFX.DatasetTreeView treeView) {
        this.treeItem = new DatasetTreeItem(treeView);
        treeView.getParentItem(this).getChildren().add((Object)this.treeItem);
        treeView.getParentItem(this).setExpanded(true);
        this.treeItem.setExpanded(true);
    }

    public abstract void save();

    public abstract void saveAs();

    public abstract void export();

    public abstract void close();

    public final class DatasetTreeItem
    extends TreeItem<Control> {
        public DatasetTreeItem(ConExpFX.DatasetTreeView treeView) {
            Label label = new Label((String)Dataset.this.id.get());
            label.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> (String)Dataset.this.id.get() + (Dataset.this.unsavedChanges.get() ? "*" : ""), (Observable[])new Observable[]{Dataset.this.id, Dataset.this.unsavedChanges}));
            label.setStyle("-fx-font-weight: bold;");
            ProgressIndicator progressIndicator = new ProgressIndicator();
            progressIndicator.setMinSize(12.0, 12.0);
            progressIndicator.setMaxSize(12.0, 12.0);
            progressIndicator.setPadding(new Insets(0.0));
            progressIndicator.progressProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> ConExpFX.instance.executor.datasetProgressBinding(Dataset.this).get() == 1.0 ? 1.0 : -1.0, (Observable[])new Observable[]{ConExpFX.instance.executor.datasetProgressBinding(Dataset.this)}));
            progressIndicator.visibleProperty().bind((ObservableValue)progressIndicator.progressProperty().lessThan(1.0));
            this.setValue(label);
            Hyperlink closeLink = new Hyperlink("x");
            closeLink.setOnAction(e -> treeView.close(Dataset.this));
            closeLink.setPadding(new Insets(0.0));
            HBox hBox = new HBox(new Node[]{closeLink, progressIndicator});
            hBox.setSpacing(4.0);
            hBox.setAlignment(Pos.CENTER);
            label.setGraphic((Node)hBox);
            label.setContentDisplay(ContentDisplay.RIGHT);
            this.setGraphic((Node)new ImageView(new Image(ConExpFX.class.getResourceAsStream("image/context.gif"))));
            Dataset.this.views.forEach(view -> this.getChildren().add((Object)view.getTreeItem()));
            Dataset.this.actions.forEach(action -> this.getChildren().add((Object)action.getTreeItem()));
        }

        public final Dataset getDataset() {
            return Dataset.this;
        }
    }
}

