/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.dialog;

import java.util.LinkedList;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.InsetsBuilder;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.SceneBuilder;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBuilder;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.DropShadowBuilder;
import javafx.scene.effect.Effect;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.BorderPaneBuilder;
import javafx.scene.layout.HBoxBuilder;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.StackPaneBuilder;
import javafx.scene.layout.VBoxBuilder;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradientBuilder;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.paint.StopBuilder;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.RectangleBuilder;
import javafx.scene.text.FontBuilder;
import javafx.scene.text.Text;
import javafx.scene.text.TextBuilder;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageBuilder;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class FXDialog<T> {
    private final int width;
    private final Stage stage = StageBuilder.create().build();
    protected final BorderPane pane = BorderPaneBuilder.create().build();
    private final Text text;
    private final Style style;
    private Answer result = Answer.UNKNOWN;
    protected T value = null;
    private StackPane topPane;
    private StackPane bottomPane;
    private Rectangle topBackground;
    private Rectangle bottomBackground;
    private final Button okButton = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonBuilder.create().text("OK")).minHeight(20.0)).minWidth(100.0)).effect((Effect)new DropShadow())).onAction((EventHandler)new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            FXDialog.this.result = Answer.OK;
            FXDialog.this.stage.close();
        }
    })).build();
    private final Button cancelButton = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonBuilder.create().text("Cancel")).minHeight(20.0)).minWidth(100.0)).effect((Effect)new DropShadow())).onAction((EventHandler)new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            FXDialog.this.result = Answer.CANCEL;
            FXDialog.this.stage.close();
        }
    })).build();
    private final Button yesButton = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonBuilder.create().text("Yes")).minHeight(20.0)).minWidth(100.0)).effect((Effect)new DropShadow())).onAction((EventHandler)new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            FXDialog.this.result = Answer.YES;
            FXDialog.this.stage.close();
        }
    })).build();
    private final Button noButton = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonBuilder.create().text("No")).minHeight(20.0)).minWidth(100.0)).effect((Effect)new DropShadow())).onAction((EventHandler)new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            FXDialog.this.result = Answer.NO;
            FXDialog.this.stage.close();
        }
    })).build();

    public FXDialog(Stage primaryStage, Style style, String title, String message, Node optionalCenterNode) {
        this(primaryStage, style, title, message, optionalCenterNode, 500);
    }

    public FXDialog(Stage primaryStage, Style style, String title, String message, Node optionalCenterNode, int width) {
        this.width = width;
        this.style = style;
        this.text = ((TextBuilder)TextBuilder.create().effect((Effect)DropShadowBuilder.create().radius(1.0).blurType(BlurType.GAUSSIAN).color(Color.LIGHTGREY).spread(1.0).build())).font(FontBuilder.create().size(16.0).build()).wrappingWidth((double)(width - 50)).build();
        this.stage.initOwner((Window)primaryStage);
        this.stage.initStyle(StageStyle.UTILITY);
        this.stage.initModality(Modality.WINDOW_MODAL);
        this.stage.setTitle(title);
        this.stage.setResizable(false);
        this.stage.setScene(SceneBuilder.create().width((double)width).root((Parent)this.pane).build());
        this.text.setText(message);
        this.createTop();
        if (optionalCenterNode != null) {
            this.pane.setCenter(optionalCenterNode);
        }
        this.createBottom();
    }

    public final void setCenterNode(Node centerNode) {
        this.pane.setCenter(centerNode);
    }

    public final Return<T> showAndWait() {
        this.stage.showAndWait();
        this.bindHeight();
        return new Return(this.result, this.value);
    }

    private final void bindHeight() {
        this.topBackground.heightProperty().bind((ObservableValue)new DoubleBinding(){

            protected double computeValue() {
                return FXDialog.this.text.getLayoutBounds().getHeight() + 20.0;
            }
        });
        DoubleBinding height = new DoubleBinding(){
            {
                if (FXDialog.this.pane.getCenter() != null && FXDialog.this.pane.getCenter() instanceof Pane) {
                    super.bind(new Observable[]{((Pane)FXDialog.this.pane.getCenter()).minHeightProperty()});
                }
            }

            protected double computeValue() {
                return FXDialog.this.topBackground.heightProperty().get() + FXDialog.this.bottomBackground.heightProperty().get() + (FXDialog.this.pane.getCenter() != null && FXDialog.this.pane.getCenter() instanceof Pane ? ((Pane)FXDialog.this.pane.getCenter()).minHeightProperty().get() : 0.0);
            }
        };
        this.pane.minHeightProperty().bind((ObservableValue)height);
        this.pane.maxHeightProperty().bind((ObservableValue)height);
        this.stage.minHeightProperty().bind((ObservableValue)this.pane.heightProperty());
        this.stage.maxHeightProperty().bind((ObservableValue)this.pane.heightProperty());
    }

    private final void createTop() {
        this.topBackground = ((RectangleBuilder)RectangleBuilder.create().fill((Paint)Color.WHITE)).width((double)this.width).build();
        this.topPane = ((StackPaneBuilder)StackPaneBuilder.create().children(new Node[]{this.topBackground, ((VBoxBuilder)((VBoxBuilder)VBoxBuilder.create().alignment(Pos.TOP_LEFT).spacing(10.0).padding(InsetsBuilder.create().left(10.0).top(10.0).right(10.0).bottom(10.0).build())).children(new Node[]{this.text})).build()})).build();
        if (this.text.getText().trim() != "") {
            this.pane.setTop((Node)this.topPane);
        }
    }

    private final void createBottom() {
        this.bottomBackground = ((RectangleBuilder)RectangleBuilder.create().fill((Paint)LinearGradientBuilder.create().startX(0.0).startY(0.0).endX(0.0).endY(1.0).cycleMethod(CycleMethod.NO_CYCLE).proportional(true).stops(new Stop[]{StopBuilder.create().color(Color.LIGHTGRAY).offset(1.0).build(), StopBuilder.create().color(Color.WHITE).offset(0.0).build()}).build())).height(50.0).width((double)this.width).build();
        LinkedList<Button> buttons = new LinkedList<Button>();
        switch (this.style) {
            case INFO: 
            case ERROR: {
                buttons.add(this.okButton);
                break;
            }
            case WARN: {
                buttons.add(this.okButton);
                buttons.add(this.cancelButton);
                break;
            }
            case QUESTION: {
                buttons.add(this.yesButton);
                buttons.add(this.noButton);
                buttons.add(this.cancelButton);
            }
        }
        this.bottomPane = ((StackPaneBuilder)StackPaneBuilder.create().children(new Node[]{this.bottomBackground, ((HBoxBuilder)((HBoxBuilder)HBoxBuilder.create().alignment(Pos.CENTER_RIGHT).spacing(10.0).padding(InsetsBuilder.create().right(30.0).build())).children(buttons)).build()})).build();
        this.pane.setBottom((Node)this.bottomPane);
    }

    public static final class Return<T> {
        private final Answer answer;
        private final T value;

        private Return(Answer answer, T value) {
            this.answer = answer;
            this.value = value;
        }

        public final Answer result() {
            return this.answer;
        }

        public final T value() {
            return this.value;
        }
    }

    public static enum Style {
        INFO,
        WARN,
        ERROR,
        QUESTION;

    }

    public static enum Answer {
        OK,
        CANCEL,
        YES,
        NO,
        UNKNOWN;

    }
}

