/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.dialog;

import conexp.fx.gui.ConExpFX;
import conexp.fx.gui.dialog.ErrorDialog;
import conexp.fx.gui.dialog.FXDialog;
import java.awt.Desktop;
import java.net.URI;
import javafx.geometry.InsetsBuilder;
import javafx.scene.Node;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.HyperlinkBuilder;
import javafx.scene.control.Label;
import javafx.scene.control.LabelBuilder;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.ImageViewBuilder;
import javafx.scene.layout.HBox;
import javafx.scene.layout.HBoxBuilder;
import javafx.scene.layout.VBox;
import javafx.scene.layout.VBoxBuilder;

public final class InfoDialog
extends FXDialog<Void> {
    private final ConExpFX cfx;

    public InfoDialog(ConExpFX cfx) {
        super(cfx.primaryStage, FXDialog.Style.INFO, "Info", "", (Node)InfoDialog.content(cfx));
        this.cfx = cfx;
    }

    private static VBox content(ConExpFX cfx) {
        Hyperlink homepage = ((HyperlinkBuilder)((HyperlinkBuilder)HyperlinkBuilder.create().text("http://lat.inf.tu-dresden.de/~francesco")).onAction(ev -> {
            try {
                Desktop.getDesktop().browse(new URI("http://lat.inf.tu-dresden.de/~francesco"));
            }
            catch (Exception e) {
                new ErrorDialog(cfx.primaryStage, e).showAndWait();
            }
        })).build();
        Hyperlink email = ((HyperlinkBuilder)((HyperlinkBuilder)HyperlinkBuilder.create().text("mailto:francesco.kriegel@tu-dresden.de")).onAction(ev -> {
            try {
                Desktop.getDesktop().mail(new URI("mailto:francesco.kriegel@tu-dresden.de"));
            }
            catch (Exception e) {
                new ErrorDialog(cfx.primaryStage, e).showAndWait();
            }
        })).build();
        Label label = ((LabelBuilder)LabelBuilder.create().text("Concept Explorer FX\r\n(c) 2010-2018, Francesco Kriegel, TU Dresden\r\nGNU General Public License v3 (GPL-3)")).build();
        ImageView icon = InfoDialog.imageView("image/conexp-fx.png", 64, "http://lat.inf.tu-dresden.de/~francesco/conexp-fx/conexp-fx.html");
        HBox title = ((HBoxBuilder)((HBoxBuilder)HBoxBuilder.create().spacing(4.0).padding(InsetsBuilder.create().left(0.0).top(0.0).right(0.0).bottom(0.0).build())).children(new Node[]{icon, label})).build();
        VBox contact = ((VBoxBuilder)((VBoxBuilder)VBoxBuilder.create().spacing(0.0).padding(InsetsBuilder.create().left(0.0).top(0.0).right(0.0).bottom(0.0).build())).children(new Node[]{email, homepage})).build();
        HBox icons1 = ((HBoxBuilder)((HBoxBuilder)HBoxBuilder.create().spacing(5.0).padding(InsetsBuilder.create().left(0.0).top(0.0).right(0.0).bottom(0.0).build())).children(new Node[]{InfoDialog.imageView("image/logo_tu_black.png", 40, "http://tu-dresden.de/en"), InfoDialog.imageView("image/ganter.gif", 40, "http://tu-dresden.de/Members/bernhard.ganter")})).build();
        HBox icons2 = ((HBoxBuilder)((HBoxBuilder)HBoxBuilder.create().spacing(5.0).padding(InsetsBuilder.create().left(0.0).top(0.0).right(0.0).bottom(0.0).build())).children(new Node[]{InfoDialog.imageView("image/Javafx_logo_color.png", 40, "http://docs.oracle.com/javafx/"), InfoDialog.imageView("image/apache.png", 40, "http://www.apache.org/licenses/LICENSE-2.0.html"), InfoDialog.imageView("image/mavenlogo_builtby_w.gif", 40, "http://maven.apache.org/")})).build();
        return ((VBoxBuilder)((VBoxBuilder)VBoxBuilder.create().spacing(5.0).padding(InsetsBuilder.create().left(10.0).top(10.0).right(10.0).bottom(10.0).build())).children(new Node[]{title, contact, icons1, icons2})).build();
    }

    private static ImageView imageView(String image, int h, String url) {
        Image i = new Image(ConExpFX.class.getResourceAsStream(image));
        double r = i.getWidth() / i.getHeight();
        return ((ImageViewBuilder)ImageViewBuilder.create().onMouseClicked(ev -> {
            try {
                Desktop.getDesktop().browse(new URI(url));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        })).image(i).fitHeight((double)h).fitWidth(r * (double)h).build();
    }
}

