/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.exploration;

import conexp.fx.core.algorithm.exploration.CounterExample;
import conexp.fx.core.context.Implication;
import conexp.fx.core.context.MatrixContext;
import conexp.fx.core.util.IdGenerator;
import conexp.fx.gui.ConExpFX;
import conexp.fx.gui.dialog.ErrorDialog;
import conexp.fx.gui.dialog.FXDialog;
import java.util.Collection;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class CounterExampleDialog
extends FXDialog<CounterExample<String, String>> {
    private final MatrixContext<String, String> context;
    private final Implication<String, String> implication;

    public CounterExampleDialog(MatrixContext<String, String> context, Implication<String, String> implication) {
        super(ConExpFX.instance.primaryStage, FXDialog.Style.QUESTION, "Attribute Exploration", "Is the formal implication " + implication + " correct? If no, then please provide a counterexample.", null);
        this.context = context;
        this.implication = implication;
        this.setCenterNode(this.createCenterNode());
    }

    private final Node createCenterNode() {
        BorderPane pane = new BorderPane();
        Label objectLabel = new Label("Counterexample-Name: ");
        TextField objectTextField = new TextField("Counterexample" + IdGenerator.getNextId(this.context));
        HBox objectBox = new HBox(new Node[]{objectLabel, objectTextField});
        ObservableList selectedAttributes = FXCollections.observableArrayList();
        ObjectBinding counterExample = Bindings.createObjectBinding(() -> new CounterExample(objectTextField.getText(), selectedAttributes), (Observable[])new Observable[]{objectTextField.textProperty(), selectedAttributes});
        counterExample.addListener((__, ___, newValue) -> {
            this.value = newValue;
        });
        selectedAttributes.addAll((Collection)this.implication.getPremise());
        VBox checkBoxes = new VBox();
        for (String m : this.context.colHeads()) {
            CheckBox checkBox = new CheckBox(m);
            if (this.implication.getPremise().contains(m)) {
                checkBox.setSelected(true);
                checkBox.setDisable(true);
            } else {
                checkBox.selectedProperty().addListener((__, ___, isSelected) -> {
                    if (isSelected.booleanValue()) {
                        selectedAttributes.add((Object)checkBox.getText());
                    } else {
                        selectedAttributes.remove((Object)checkBox.getText());
                    }
                });
            }
            checkBoxes.getChildren().add((Object)checkBox);
        }
        counterExample.addListener((__, ___, newValue) -> {
            boolean illegal;
            boolean bl = illegal = selectedAttributes.containsAll((Collection)this.implication.getPremise()) && selectedAttributes.containsAll((Collection)this.implication.getConclusion());
            if (illegal) {
                checkBoxes.getChildren().stream().map(child -> (CheckBox)child).forEach(checkBox -> checkBox.setSelected(this.implication.getPremise().contains(checkBox.getText())));
                new ErrorDialog(ConExpFX.instance.primaryStage, new IllegalArgumentException("An illegal counterexample was entered. The counterexample must not have all attributes in the implication's conclusion.")).showAndWait();
            }
        });
        pane.setCenter((Node)checkBoxes);
        pane.setTop((Node)objectBox);
        return pane;
    }
}

