/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.exploration;

import conexp.fx.core.algorithm.exploration.CounterExample;
import conexp.fx.core.algorithm.exploration.Expert;
import conexp.fx.core.collections.relation.RelationEvent;
import conexp.fx.core.collections.relation.RelationEventHandler;
import conexp.fx.core.collections.setlist.SetList;
import conexp.fx.core.context.Context;
import conexp.fx.core.context.Implication;
import conexp.fx.core.context.MatrixContext;
import conexp.fx.core.util.IdGenerator;
import conexp.fx.gui.context.MatrixContextWidget;
import conexp.fx.gui.dialog.ErrorDialog;
import conexp.fx.gui.util.Platform2;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public final class HumanExpertP<M>
implements Expert<String, M> {
    private Stage stage;
    private final Map<Implication<String, M>, Question> pendingQuestions = new ConcurrentHashMap<Implication<String, M>, Question>();
    private boolean isCancelled = false;
    private final Context<String, M> cxt;
    private MatrixContext<Implication<String, M>, M> counterExamples;
    private MatrixContextWidget<Implication<String, M>, M> counterExamplesWidget;

    public HumanExpertP(Context<String, M> cxt) {
        this.cxt = cxt;
    }

    public final void init() {
        this.stage = new Stage(StageStyle.UTILITY);
        this.stage.setTitle("Parallel Attribute Exploration");
        this.stage.setWidth(800.0);
        this.stage.setHeight(500.0);
        this.counterExamples = new MatrixContext(false, MatrixContext.AutomaticMode.NONE);
        this.counterExamples.colHeads().addAll(this.cxt.colHeads());
        this.counterExamplesWidget = new MatrixContextWidget(null, true, false, this.counterExamples);
        this.stage.setScene(new Scene((Parent)new BorderPane(this.counterExamplesWidget, (Node)new Label("Please decide whether the following implications are valid."), null, null, null)));
        this.stage.setOnHiding(__ -> {
            this.isCancelled = true;
            for (Question question : this.pendingQuestions.values()) {
                question.ref.set(Collections.emptySet());
                question.cancel();
            }
        });
    }

    public final void show() {
        this.stage.show();
    }

    public final void hide() {
        this.stage.hide();
    }

    @Override
    public Set<CounterExample<String, M>> getCounterExamples(Implication<String, M> implication) throws InterruptedException {
        Platform2.runOnFXThreadAndWaitTryCatch(() -> this.pendingQuestions.put(implication, new Question(implication)));
        Question question = this.pendingQuestions.get(implication);
        question.cdl.await();
        if (this.isCancelled) {
            throw new InterruptedException();
        }
        return (Set)question.ref.get();
    }

    private final class Question {
        private final String object;
        private final Implication<String, M> implication;
        private final CountDownLatch cdl = new CountDownLatch(1);
        private final AtomicReference<Set<CounterExample<String, M>>> ref = new AtomicReference();
        private final HBox buttonsBox = new HBox();
        private final RelationEventHandler<Implication<String, M>, M> eventHandler;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Question(Implication<String, M> implication) {
            this.object = "Counter-Example " + IdGenerator.getNextId(HumanExpertP.this.cxt);
            this.implication = implication;
            Button acceptButton = new Button("accept");
            Button declineButton = new Button("decline");
            acceptButton.maxHeightProperty().bind((ObservableValue)((HumanExpertP)HumanExpertP.this).counterExamplesWidget.rowHeaderPane.rowHeight);
            acceptButton.minHeightProperty().bind((ObservableValue)((HumanExpertP)HumanExpertP.this).counterExamplesWidget.rowHeaderPane.rowHeight);
            acceptButton.prefHeightProperty().bind((ObservableValue)((HumanExpertP)HumanExpertP.this).counterExamplesWidget.rowHeaderPane.rowHeight);
            declineButton.maxHeightProperty().bind((ObservableValue)((HumanExpertP)HumanExpertP.this).counterExamplesWidget.rowHeaderPane.rowHeight);
            declineButton.minHeightProperty().bind((ObservableValue)((HumanExpertP)HumanExpertP.this).counterExamplesWidget.rowHeaderPane.rowHeight);
            declineButton.prefHeightProperty().bind((ObservableValue)((HumanExpertP)HumanExpertP.this).counterExamplesWidget.rowHeaderPane.rowHeight);
            acceptButton.setMaxWidth(60.0);
            acceptButton.setMinWidth(60.0);
            acceptButton.setPrefWidth(60.0);
            declineButton.setMaxWidth(60.0);
            declineButton.setMinWidth(60.0);
            declineButton.setPrefWidth(60.0);
            acceptButton.setStyle("-fx-padding:0; -fx-background-radius: 5 0 0 5, 5 0 0 5, 4 0 0 4, 3 0 0 3;");
            declineButton.setStyle("-fx-padding:0; -fx-background-radius: 0 5 5 0, 0 5 5 0, 0 4 4 0, 0 3 3 0;");
            acceptButton.setOnAction(__ -> {
                this.ref.set(Collections.emptySet());
                this.cancel();
            });
            declineButton.setOnAction(__ -> this.cancel());
            this.buttonsBox.getChildren().addAll((Object[])new Node[]{acceptButton, declineButton});
            SetList setList = HumanExpertP.this.counterExamples.rowHeads();
            synchronized (setList) {
                HumanExpertP.this.counterExamples.rowHeads().add(implication);
                HumanExpertP.this.counterExamples.row((Object)implication).addAll(implication.getPremise());
            }
            this.ref.set(Collections.singleton(new CounterExample(this.object, implication.getPremise())));
            AtomicBoolean blocked = new AtomicBoolean(false);
            this.eventHandler = __ -> {
                if (blocked.get() || !HumanExpertP.this.counterExamples.rowHeads().contains((Object)implication)) {
                    return;
                }
                if (!HumanExpertP.this.counterExamples.row((Object)implication).containsAll(implication.getPremise()) || HumanExpertP.this.counterExamples.row((Object)implication).containsAll(implication.getConclusion())) {
                    blocked.set(true);
                    HumanExpertP.this.counterExamples.row((Object)implication).clear();
                    HumanExpertP.this.counterExamples.row((Object)implication).addAll(implication.getPremise());
                    new ErrorDialog(HumanExpertP.this.stage, "Invalid Counterexample", "A counterexample must contain all premise attributes, but must not contain all conclusion attributes.").showAndWait();
                    blocked.set(false);
                }
                this.ref.set(Collections.singleton(new CounterExample(this.object, HumanExpertP.this.counterExamples.row((Object)implication))));
            };
            HumanExpertP.this.counterExamples.addEventHandler(this.eventHandler, RelationEvent.ENTRIES);
            HumanExpertP.this.counterExamplesWidget.addRowDecoration(implication, (Node)this.buttonsBox);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void cancel() {
            SetList setList = HumanExpertP.this.counterExamples.rowHeads();
            synchronized (setList) {
                HumanExpertP.this.counterExamples.removeEventHandler(RelationEvent.ENTRIES, this.eventHandler);
                HumanExpertP.this.counterExamples.rowHeads().remove((Object)this.implication);
                HumanExpertP.this.pendingQuestions.remove(this);
            }
            this.cdl.countDown();
        }
    }
}

