/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.graph;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import conexp.fx.core.context.Concept;
import conexp.fx.core.context.ConceptLattice;
import conexp.fx.gui.graph.SuperNode;
import java.util.Set;
import javafx.event.EventHandler;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Shape;
import javafx.stage.Stage;

public class CircularGraph<G, M> {
    private final Stage primaryStage = new Stage();

    public CircularGraph(ConceptLattice<G, M> lattice) {
        StackPane rootPane = new StackPane();
        this.primaryStage.setScene(new Scene((Parent)rootPane, 1280.0, 800.0));
        Multimap<Concept<G, M>, Area> layers = this.computeLayers(lattice, 360.0, 36.0);
        HashMultimap nodes = HashMultimap.create();
        for (Concept c : layers.keySet()) {
            for (Area a : layers.get((Object)c)) {
                SuperNode n = new SuperNode(a.y, a.y + a.h, a.x, a.w, (Paint)this.fromHashCode(c));
                nodes.put((Object)c, (Object)n);
                rootPane.getChildren().add((Object)n);
                this.addListener(c, n, (Multimap<Concept<G, M>, SuperNode>)nodes);
            }
        }
    }

    public final void show() {
        this.primaryStage.show();
    }

    private void addListener(final Concept<G, M> c, SuperNode n, final Multimap<Concept<G, M>, SuperNode> nodes) {
        ((Shape)n.getChildren().get(1)).addEventHandler(MouseEvent.MOUSE_ENTERED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                for (SuperNode node : nodes.get((Object)c)) {
                    ((Shape)node.getChildren().get(1)).setFill((Paint)Color.RED);
                }
            }
        });
        ((Shape)n.getChildren().get(1)).addEventHandler(MouseEvent.MOUSE_EXITED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                for (SuperNode node : nodes.get((Object)c)) {
                    ((Shape)node.getChildren().get(1)).setFill((Paint)CircularGraph.this.fromHashCode(c));
                }
            }
        });
    }

    private Color fromHashCode(Object o) {
        int h = o.hashCode();
        int m = 192;
        int r = h * 7 % m;
        int g = h * 17 % m;
        int b = h * 37 % m;
        if (r < 0) {
            r += m;
        }
        if (g < 0) {
            g += m;
        }
        if (b < 0) {
            b += m;
        }
        return Color.rgb((int)(r += 256 - m), (int)(g += 256 - m), (int)(b += 256 - m));
    }

    private Multimap<Concept<G, M>, Area> computeLayers(ConceptLattice<G, M> lattice, double width, double layerHeight) {
        HashMultimap layers = HashMultimap.create();
        Concept top = lattice.context.topConcept();
        Area parent = new Area(0.0, 0.0, width, layerHeight);
        layers.put(top, (Object)parent);
        this.addNextLayer(lattice, (Multimap<Concept<G, M>, Area>)layers, parent, lattice.col(top));
        return layers;
    }

    private void addNextLayer(ConceptLattice<G, M> lattice, Multimap<Concept<G, M>, Area> layers, Area parent, Set<Concept<G, M>> concepts) {
        double l = parent.w / (double)concepts.size();
        double t = parent.x;
        for (Concept<G, M> c : concepts) {
            Area a = new Area(t, parent.y + parent.h, l, parent.h);
            layers.put(c, (Object)a);
            this.addNextLayer(lattice, layers, a, lattice.col(c));
            t += l;
        }
    }

    private class Area {
        private final double x;
        private final double y;
        private final double w;
        private final double h;

        public Area(double x, double y, double w, double h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }
    }
}

