/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.graph;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import conexp.fx.core.collections.Pair;
import conexp.fx.core.collections.relation.RelationEvent;
import conexp.fx.core.collections.relation.RelationEventHandler;
import conexp.fx.core.context.Concept;
import conexp.fx.core.layout.AdditiveConceptLayout;
import conexp.fx.core.layout.ConceptLayout;
import conexp.fx.core.layout.ConceptMovement;
import conexp.fx.core.layout.LayoutEvolution;
import conexp.fx.core.math.Points;
import conexp.fx.gui.ConExpFX;
import conexp.fx.gui.dataset.FCADataset;
import conexp.fx.gui.graph.Graph;
import conexp.fx.gui.graph.option.AnimationSpeed;
import conexp.fx.gui.graph.option.AttributeLabelText;
import conexp.fx.gui.graph.option.EdgeHighlight;
import conexp.fx.gui.graph.option.EdgeStroke;
import conexp.fx.gui.graph.option.GraphTransformation;
import conexp.fx.gui.graph.option.ObjectLabelText;
import conexp.fx.gui.graph.option.VertexHighlight;
import conexp.fx.gui.graph.option.VertexRadius;
import conexp.fx.gui.util.FXControls;
import conexp.fx.gui.util.NumberPropertyTransition;
import conexp.fx.gui.util.SearchBox;
import de.tudresden.inf.tcs.fcalib.Implication;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javafx.animation.FillTransition;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.StrokeTransition;
import javafx.animation.Timeline;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.SetChangeListener;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.BoundingBox;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Slider;
import javafx.scene.control.SliderBuilder;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.ToolBar;
import javafx.scene.image.Image;
import javafx.scene.image.ImageViewBuilder;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Circle;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.RectangleBuilder;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Text;
import javafx.util.Duration;
import jfxtras.scene.control.ListSpinner;

public final class ConceptGraph<G, M>
extends Graph<Concept<G, M>, Circle> {
    public static final Color COLOR_CONCEPT = Color.valueOf((String)"#FFE206");
    public static final Color COLOR_INTERVAL = Color.valueOf((String)"#8100BC");
    public static final Color COLOR_LOWER = Color.valueOf((String)"#1EA266");
    public static final Color COLOR_UPPER = Color.valueOf((String)"#DD3558");
    public static final Color COLOR_UNCOMPARABLE = Color.valueOf((String)"#EEEEEE");
    private final FCADataset<G, M> fca;
    private final ConceptLayout<G, M, ?> layout;
    private final CFXControlBox controlBox;
    private final CFXToolBar toolBar;
    private final Map<G, ObjectLabel> objectLabels = new ConcurrentHashMap<G, ObjectLabel>();
    private final Map<M, AttributeLabel> attributeLabels = new ConcurrentHashMap<M, AttributeLabel>();
    private LayoutEvolution<G, M> qualityEvolution = null;
    public final HighlightRequests highlightRequests = new HighlightRequests();
    private boolean dontHighlight = false;
    public boolean highlightLock = false;

    public ConceptGraph(FCADataset<G, M> fcaInstance, ConceptLayout<G, M, ?> layout) {
        super(layout);
        this.fca = fcaInstance;
        this.layout = layout;
        this.controlBox = new CFXControlBox();
        this.toolBar = new CFXToolBar();
        this.initLayoutListeners();
        this.initMouseListeners();
        this.textSize.bind((ObservableValue)this.controlBox.labelTextSize.valueProperty());
    }

    public ConceptGraph(FCADataset<G, M> fcaInstance) {
        this(fcaInstance, fcaInstance.layout);
    }

    private final void initLayoutListeners() {
        this.initVertexListeners();
        this.initEdgeListeners();
        this.initLabelListeners();
        this.layout.lattice.addEventHandler(new RelationEventHandler<Concept<G, M>, Concept<G, M>>(){

            @Override
            public final void handle(RelationEvent<Concept<G, M>, Concept<G, M>> event) {
                ConceptGraph.this.controller.graphLock = true;
                ConceptGraph.this.front.getChildren().clear();
                ConceptGraph.this.controller.polarBottom = null;
                ConceptGraph.this.controller.graphLock = false;
            }
        }, RelationEvent.ROWS_CLEARED);
    }

    private final void initVertexListeners() {
        this.layout.lattice.addEventHandler(new RelationEventHandler<Concept<G, M>, Concept<G, M>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void handle(RelationEvent<Concept<G, M>, Concept<G, M>> event) {
                for (Concept concept : event.getRows()) {
                    if (((ConceptGraph)ConceptGraph.this).layout.generators.containsKey(concept)) {
                        Map map = ((ConceptGraph)ConceptGraph.this).layout.generators;
                        synchronized (map) {
                            Concept generator = ((ConceptGraph)ConceptGraph.this).layout.generators.remove(concept);
                            Circle gContent = (Circle)((Graph.Vertex)ConceptGraph.this.vertices.get(generator)).node;
                            new ConceptVertex(concept, gContent.translateXProperty().get(), (Double)gContent.translateYProperty().get());
                            continue;
                        }
                    }
                    new ConceptVertex(concept, null, null);
                }
            }
        }, RelationEvent.ROWS_ADDED);
        this.layout.lattice.addEventHandler(new RelationEventHandler<Concept<G, M>, Concept<G, M>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void handle(RelationEvent<Concept<G, M>, Concept<G, M>> event) {
                for (Concept concept : event.getRows()) {
                    if (((ConceptGraph)ConceptGraph.this).layout.generators.containsKey(concept)) {
                        Map map = ((ConceptGraph)ConceptGraph.this).layout.generators;
                        synchronized (map) {
                            Concept generator = ((ConceptGraph)ConceptGraph.this).layout.generators.remove(concept);
                            ConceptGraph.this.controller.disposeVertex(concept, generator);
                            continue;
                        }
                    }
                    ConceptGraph.this.controller.disposeVertex(concept, null);
                }
            }
        }, RelationEvent.ROWS_REMOVED);
    }

    private final void initEdgeListeners() {
        this.layout.lattice.addEventHandler(new RelationEventHandler<Concept<G, M>, Concept<G, M>>(){

            @Override
            public final void handle(RelationEvent<Concept<G, M>, Concept<G, M>> event) {
                for (Pair concepts : event.getEntries()) {
                    new ConceptEdge(concepts);
                }
            }
        }, RelationEvent.ENTRIES_ADDED);
        this.layout.lattice.addEventHandler(new RelationEventHandler<Concept<G, M>, Concept<G, M>>(){

            @Override
            public final void handle(RelationEvent<Concept<G, M>, Concept<G, M>> event) {
                for (Pair concepts : event.getEntries()) {
                    ConceptGraph.this.controller.disposeEdge(concepts);
                }
            }
        }, RelationEvent.ENTRIES_REMOVED);
    }

    private final void initLabelListeners() {
        this.layout.lattice.objectConcepts.addListener(new MapChangeListener<G, Concept<G, M>>(){

            public final void onChanged(MapChangeListener.Change<? extends G, ? extends Concept<G, M>> change) {
                if (!((ObjectLabelText)((Object)ConceptGraph.this.controlBox.objectLabelText.getSelectionModel().getSelectedItem())).equals((Object)ObjectLabelText.OBJECT_LABELS)) {
                    return;
                }
                if (change.wasRemoved() && change.wasAdded()) {
                    return;
                }
                if (change.wasAdded()) {
                    new ObjectLabel(change.getKey(), (Concept)change.getValueAdded());
                } else if (change.wasRemoved()) {
                    ((ObjectLabel)ConceptGraph.this.objectLabels.get(change.getKey())).dispose();
                }
            }
        });
        this.layout.lattice.attributeConcepts.addListener(new MapChangeListener<M, Concept<G, M>>(){

            public final void onChanged(MapChangeListener.Change<? extends M, ? extends Concept<G, M>> change) {
                if (!((AttributeLabelText)((Object)ConceptGraph.this.controlBox.attributeLabelText.getSelectionModel().getSelectedItem())).equals((Object)AttributeLabelText.ATTRIBUTE_LABELS)) {
                    return;
                }
                if (change.wasRemoved() && change.wasAdded()) {
                    return;
                }
                if (change.wasAdded()) {
                    new AttributeLabel(change.getKey(), (Concept)change.getValueAdded());
                } else if (change.wasRemoved()) {
                    ((AttributeLabel)ConceptGraph.this.attributeLabels.get(change.getKey())).dispose();
                }
            }
        });
    }

    private final void initMouseListeners() {
        this.front.addEventHandler(ScrollEvent.SCROLL, (EventHandler)new EventHandler<ScrollEvent>(){

            public final void handle(ScrollEvent event) {
                if (((GraphTransformation)((Object)ConceptGraph.this.transformation.get())).equals((Object)GraphTransformation.GRAPH_3D)) {
                    ConceptGraph.this.layout.rotate(event.getDeltaX() / 251.32741228718345);
                }
            }
        });
        EventHandler<MouseEvent> lariatSelectionHandler = new EventHandler<MouseEvent>(){
            private Path path = null;

            public final void handle(MouseEvent event) {
                if (!event.getButton().equals((Object)MouseButton.PRIMARY)) {
                    return;
                }
                if (event.getEventType().equals(MouseEvent.MOUSE_PRESSED)) {
                    this.path = new Path(new PathElement[]{new MoveTo(event.getX(), event.getY())});
                    this.path.getStrokeDashArray().addAll((Object[])new Double[]{2.0, 4.0});
                    ConceptGraph.this.front.getChildren().add((Object)this.path);
                } else if (event.getEventType().equals(MouseEvent.MOUSE_RELEASED)) {
                    if (this.path != null && this.path.getElements().size() > 1) {
                        this.path.getElements().add((Object)new ClosePath());
                        this.path.setFill((Paint)Color.RED);
                        HashSet concepts = new HashSet(Maps.filterValues((Map)ConceptGraph.this.vertices, (Predicate)new Predicate<Graph.Vertex>(){

                            public final boolean apply(Graph.Vertex v) {
                                return path.contains(((Circle)v.node).translateXProperty().get(), ((Circle)v.node).translateYProperty().get());
                            }
                        }).keySet());
                        Concept supremum = ((ConceptGraph)ConceptGraph.this).layout.lattice.supremum(concepts);
                        Concept infimum = ((ConceptGraph)ConceptGraph.this).layout.lattice.infimum(concepts);
                        ConceptGraph.this.highlight(true, Iterables.concat(ConceptGraph.this.highlightRequests.filter(supremum), ConceptGraph.this.highlightRequests.ideal(infimum), ConceptGraph.this.highlightRequests.interval(infimum, supremum)), Iterables.concat((Iterable)Iterables.transform(concepts, (Function)new Function<Concept<G, M>, Iterable<Graph.HighlightRequest>>(){

                            public final Iterable<Graph.HighlightRequest> apply(Concept<G, M> concept) {
                                return ConceptGraph.this.highlightRequests.concept(concept);
                            }
                        })));
                    }
                    ConceptGraph.this.front.getChildren().remove((Object)this.path);
                    this.path = null;
                } else if (event.getEventType().equals(MouseEvent.MOUSE_DRAGGED)) {
                    this.path.getElements().add((Object)new LineTo(event.getX(), event.getY()));
                }
            }
        };
        this.front.addEventHandler(MouseEvent.MOUSE_PRESSED, (EventHandler)lariatSelectionHandler);
        this.front.addEventHandler(MouseEvent.MOUSE_DRAGGED, (EventHandler)lariatSelectionHandler);
        this.front.addEventHandler(MouseEvent.MOUSE_RELEASED, (EventHandler)lariatSelectionHandler);
    }

    @Override
    protected final BoundingBox getContentBoundingBox() {
        if (this.fca == null || this.layout == null || this.controlBox == null) {
            return new BoundingBox(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        }
        return this.layout.getCurrentBoundingBox(this.controlBox.hideBottom.isSelected(), this.controlBox.hideTop.isSelected());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void initPolarBottom(Graph.Config c, Timeline t) {
        Map map = this.vertices;
        synchronized (map) {
            this.controller.polarBottom = (Graph.Vertex)this.vertices.get(this.fca.context.selection.bottomConcept());
        }
        if (this.controller.polarBottom != null) {
            ((Circle)this.controller.polarBottom.node).radiusProperty().unbind();
            for (Graph.Edge e : this.upperEdges(this.controller.polarBottom.element)) {
                e.unbindStart();
            }
            t.getKeyFrames().add((Object)new KeyFrame(Duration.ONE, (EventHandler)new EventHandler<ActionEvent>(){

                public final void handle(ActionEvent event) {
                    ((Circle)ConceptGraph.this.controller.polarBottom.node).fillProperty().set((Object)new RadialGradient(0.0, 0.0, 0.5, 0.5, 0.5, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.TRANSPARENT), new Stop(0.95, Color.WHITE), new Stop(0.975, Color.DODGERBLUE), new Stop(1.0, Color.BLACK)}));
                    ((Circle)ConceptGraph.this.controller.polarBottom.node).toBack();
                }
            }, new KeyValue[0]));
        }
    }

    @Override
    protected final void drawPolarBottom(Graph.Config c, Timeline t) {
        t.getKeyFrames().add((Object)new KeyFrame(this.speed.frameSize, new KeyValue[]{this.controller.fadeZ((Node)this.controller.polarBottom.node, new Point3D(0.0, 0.0, 0.0)), new KeyValue((WritableValue)((Circle)this.controller.polarBottom.node).translateXProperty(), (Object)c.x0), new KeyValue((WritableValue)((Circle)this.controller.polarBottom.node).translateYProperty(), (Object)c.y0), new KeyValue((WritableValue)((Circle)this.controller.polarBottom.node).radiusProperty(), (Object)(0.9 * Math.min(c.x0, c.y0) * this.zoom.get()))}));
        for (Graph.Edge e : this.upperEdges(this.controller.polarBottom.element)) {
            Point3D p = (Point3D)c.iso.apply(e.upper.position.getValue());
            Point2D q = Points.projectOnCircle(0.0, 0.0, c.box.getHeight(), p.getX(), p.getY());
            t.getKeyFrames().add((Object)new KeyFrame(this.speed.frameSize, new KeyValue[]{new KeyValue((WritableValue)e.line.startXProperty(), (Object)(c.x0 + c.f * q.getX())), new KeyValue((WritableValue)e.line.startYProperty(), (Object)(c.y0 + c.f * q.getY()))}));
        }
    }

    @Override
    protected final void resetPolarBottom(Graph.Config c, Timeline t) {
        Point3D q = c.toPane((Point3D)this.controller.polarBottom.position.getValue());
        t.getKeyFrames().add((Object)new KeyFrame(this.speed.frameSize, new KeyValue[]{this.controller.translateX((Node)this.controller.polarBottom.node, q), this.controller.translateY((Node)this.controller.polarBottom.node, q)}));
        for (Graph.Edge e : this.upperEdges(this.controller.polarBottom.element)) {
            t.getKeyFrames().add((Object)new KeyFrame(this.speed.frameSize, new KeyValue[]{new KeyValue((WritableValue)e.line.startXProperty(), (Object)q.getX()), new KeyValue((WritableValue)e.line.startYProperty(), (Object)q.getY())}));
        }
        t.getKeyFrames().add((Object)new KeyFrame(Duration.ONE, (EventHandler)new EventHandler<ActionEvent>(){

            public final void handle(ActionEvent event) {
                new NumberPropertyTransition(ConceptGraph.this.speed.frameSize, (Property<Number>)((Circle)ConceptGraph.this.controller.polarBottom.node).radiusProperty(), 5.0, new EventHandler<ActionEvent>(){

                    public final void handle(ActionEvent event) {
                        ConceptGraph.this.controller.polarBottom.init();
                        for (Graph.Edge e : ConceptGraph.this.upperEdges(ConceptGraph.this.controller.polarBottom.element)) {
                            e.bindStart();
                        }
                        ((Circle)ConceptGraph.this.controller.polarBottom.node).fillProperty().set((Object)Graph.COLOR_DEFAULT);
                        ((Circle)ConceptGraph.this.controller.polarBottom.node).toFront();
                        ConceptGraph.this.controller.polarBottom = null;
                    }
                }).play();
            }
        }, new KeyValue[0]));
    }

    @Override
    @SafeVarargs
    public final void highlight(boolean fadeComplement, Iterable<Graph.HighlightRequest> ... requests) {
        if (!this.controller.graphLock && !this.dontHighlight && this.toolBar.highlight.isSelected()) {
            Timeline t = new Timeline();
            for (Iterable<Graph.HighlightRequest> it : requests) {
                for (Graph.HighlightRequest r : it) {
                    this.buildTimeline(t, r, true);
                }
            }
            if (fadeComplement) {
                this.buildTimeline(t, this.constructComplementHighlightRequest(requests), false);
            }
            t.play();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void buildTimeline(Timeline t, final Graph.HighlightRequest r, boolean toFront) {
        if (toFront) {
            Map map = this.vertices;
            synchronized (map) {
                for (Concept c : r.elements) {
                    final Graph.Vertex v = (Graph.Vertex)this.vertices.get(c);
                    if (v == null) continue;
                    Collection edges = null;
                    switch (r.edgeHighlightOption) {
                        case CONTAINS_BOTH: {
                            edges = Collections2.filter(this.upperEdges(v.element), (Predicate)new Predicate<Graph.Edge>(){

                                public final boolean apply(Graph.Edge c) {
                                    return r.elements.contains(c.elements.second());
                                }
                            });
                            break;
                        }
                        case CONTAINS_ONE: {
                            edges = Iterables.concat(this.upperEdges(v.element), this.lowerEdges(v.element));
                            break;
                        }
                        case CONTAINS_LOWER: {
                            edges = this.upperEdges(v.element);
                            break;
                        }
                        case CONTAINS_UPPER: {
                            edges = this.lowerEdges(v.element);
                        }
                    }
                    if (edges != null) {
                        for (final Graph.Edge e : edges) {
                            t.getKeyFrames().add((Object)new KeyFrame(Duration.ONE, (EventHandler)new EventHandler<ActionEvent>(){

                                public final void handle(ActionEvent event) {
                                    if (!e.line.opacityProperty().isBound()) {
                                        e.line.opacityProperty().set(1.0);
                                    }
                                    new StrokeTransition(ConceptGraph.this.speed.frameSize, (Shape)e.line, (Color)e.line.getStroke(), r.edgeColor).play();
                                }
                            }, new KeyValue[0]));
                        }
                    }
                    if (!v.equals(this.controller.polarBottom)) {
                        t.getKeyFrames().add((Object)new KeyFrame(Duration.ONE, (EventHandler)new EventHandler<ActionEvent>(){

                            public final void handle(ActionEvent event) {
                                if (!ConceptGraph.this.threeDimensions() && !((Circle)v.node).opacityProperty().isBound()) {
                                    ((Circle)v.node).opacityProperty().set(1.0);
                                }
                                new FillTransition(ConceptGraph.this.speed.frameSize, (Shape)v.node, ((Circle)v.node).getFill() instanceof Color ? (Color)((Circle)v.node).getFill() : Color.TRANSPARENT, r.vertexColor).play();
                            }
                        }, new KeyValue[0]));
                    }
                    for (final Graph.Label l : v.upperLabels) {
                        t.getKeyFrames().add((Object)new KeyFrame(Duration.ONE, (EventHandler)new EventHandler<ActionEvent>(){

                            public void handle(ActionEvent event) {
                                if (!ConceptGraph.this.threeDimensions()) {
                                    l.content.opacityProperty().set(1.0);
                                }
                                new FillTransition(ConceptGraph.this.speed.frameSize, (Shape)l.back, (Color)l.back.getFill(), r.attributeLabelBackColor).play();
                                new FillTransition(ConceptGraph.this.speed.frameSize, (Shape)l.text, (Color)l.text.getFill(), r.attributeLabelTextColor).play();
                            }
                        }, new KeyValue[0]));
                    }
                    for (final Graph.Label l : v.lowerLabels) {
                        t.getKeyFrames().add((Object)new KeyFrame(Duration.ONE, (EventHandler)new EventHandler<ActionEvent>((Graph.LowerLabel)l, r){
                            final /* synthetic */ Graph.LowerLabel val$l;
                            final /* synthetic */ Graph.HighlightRequest val$r;
                            {
                                this.val$l = lowerLabel;
                                this.val$r = highlightRequest;
                            }

                            public void handle(ActionEvent event) {
                                if (!ConceptGraph.this.threeDimensions()) {
                                    this.val$l.content.opacityProperty().set(1.0);
                                }
                                new FillTransition(ConceptGraph.this.speed.frameSize, (Shape)this.val$l.back, (Color)this.val$l.back.getFill(), this.val$r.objectLabelBackColor).play();
                                new FillTransition(ConceptGraph.this.speed.frameSize, (Shape)this.val$l.text, (Color)this.val$l.text.getFill(), this.val$r.objectLabelTextColor).play();
                            }
                        }, new KeyValue[0]));
                    }
                }
            }
        }
        Map map = this.vertices;
        synchronized (map) {
            for (Concept c : r.elements) {
                final Graph.Vertex v = (Graph.Vertex)this.vertices.get(c);
                if (v == null) continue;
                for (final Graph.Label l : v.upperLabels) {
                    t.getKeyFrames().add((Object)new KeyFrame(Duration.ONE, (EventHandler)new EventHandler<ActionEvent>(){

                        public void handle(ActionEvent event) {
                            if (!ConceptGraph.this.threeDimensions()) {
                                l.content.opacityProperty().set(0.2);
                            }
                            new FillTransition(ConceptGraph.this.speed.frameSize, (Shape)l.back, (Color)l.back.getFill(), r.attributeLabelBackColor).play();
                            new FillTransition(ConceptGraph.this.speed.frameSize, (Shape)l.text, (Color)l.text.getFill(), r.attributeLabelTextColor).play();
                        }
                    }, new KeyValue[0]));
                }
                for (final Graph.Label l : v.lowerLabels) {
                    t.getKeyFrames().add((Object)new KeyFrame(Duration.ONE, (EventHandler)new EventHandler<ActionEvent>((Graph.LowerLabel)l, r){
                        final /* synthetic */ Graph.LowerLabel val$l;
                        final /* synthetic */ Graph.HighlightRequest val$r;
                        {
                            this.val$l = lowerLabel;
                            this.val$r = highlightRequest;
                        }

                        public void handle(ActionEvent event) {
                            if (!ConceptGraph.this.threeDimensions()) {
                                this.val$l.content.opacityProperty().set(0.2);
                            }
                            new FillTransition(ConceptGraph.this.speed.frameSize, (Shape)this.val$l.back, (Color)this.val$l.back.getFill(), this.val$r.objectLabelBackColor).play();
                            new FillTransition(ConceptGraph.this.speed.frameSize, (Shape)this.val$l.text, (Color)this.val$l.text.getFill(), this.val$r.objectLabelTextColor).play();
                        }
                    }, new KeyValue[0]));
                }
                if (!v.equals(this.controller.polarBottom)) {
                    t.getKeyFrames().add((Object)new KeyFrame(Duration.ONE, (EventHandler)new EventHandler<ActionEvent>(){

                        public final void handle(ActionEvent event) {
                            if (!ConceptGraph.this.threeDimensions() && !((Circle)v.node).opacityProperty().isBound()) {
                                ((Circle)v.node).opacityProperty().set(0.2);
                            }
                            new FillTransition(ConceptGraph.this.speed.frameSize, (Shape)v.node, ((Circle)v.node).getFill() instanceof Color ? (Color)((Circle)v.node).getFill() : Color.TRANSPARENT, r.vertexColor).play();
                        }
                    }, new KeyValue[0]));
                }
                Collection edges = null;
                switch (r.edgeHighlightOption) {
                    case CONTAINS_BOTH: {
                        edges = Collections2.filter(this.upperEdges(v.element), (Predicate)new Predicate<Graph.Edge>(){

                            public final boolean apply(Graph.Edge c) {
                                return r.elements.contains(c.elements.second());
                            }
                        });
                        break;
                    }
                    case CONTAINS_ONE: {
                        edges = Iterables.concat(this.upperEdges(v.element), this.lowerEdges(v.element));
                        break;
                    }
                    case CONTAINS_LOWER: {
                        edges = this.upperEdges(v.element);
                        break;
                    }
                    case CONTAINS_UPPER: {
                        edges = this.lowerEdges(v.element);
                    }
                }
                if (edges == null) continue;
                for (final Graph.Edge e : edges) {
                    t.getKeyFrames().add((Object)new KeyFrame(Duration.ONE, (EventHandler)new EventHandler<ActionEvent>(){

                        public final void handle(ActionEvent event) {
                            if (!e.line.opacityProperty().isBound()) {
                                e.line.opacityProperty().set(0.2);
                            }
                            new StrokeTransition(ConceptGraph.this.speed.frameSize, (Shape)e.line, (Color)e.line.getStroke(), r.edgeColor).play();
                        }
                    }, new KeyValue[0]));
                }
            }
        }
    }

    private final Graph.HighlightRequest constructComplementHighlightRequest(Iterable<Graph.HighlightRequest> ... requests) {
        return new Graph.HighlightRequest(Sets.newHashSet(this.layout.lattice.complement(Sets.newHashSet((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)Iterables.concat(Arrays.asList(requests)), (Function)new Function<Graph.HighlightRequest, Iterable<Concept<G, M>>>(){

            public final Iterable<Concept<G, M>> apply(Graph.HighlightRequest request) {
                return request.elements;
            }
        }))))), EdgeHighlight.CONTAINS_ONE, COLOR_UNCOMPARABLE, COLOR_UNCOMPARABLE, COLOR_UNCOMPARABLE, Color.WHITE, COLOR_UNCOMPARABLE, Color.WHITE);
    }

    public final boolean threeDimensions() {
        return ((GraphTransformation)((Object)this.transformation.get())).equals((Object)GraphTransformation.GRAPH_3D);
    }

    public final boolean polar() {
        return ((GraphTransformation)((Object)this.transformation.get())).equals((Object)GraphTransformation.POLAR);
    }

    @Override
    public void removeContent() {
        super.removeContent();
        this.objectLabels.clear();
        this.attributeLabels.clear();
    }

    public final class HighlightRequests {
        private HighlightRequests() {
        }

        public final Iterable<Graph.HighlightRequest> dehighlight() {
            if (ConceptGraph.this.controller.graphLock || ConceptGraph.this.dontHighlight || !ConceptGraph.this.toolBar.highlight.isSelected()) {
                return Collections.emptySet();
            }
            return Collections.singleton(new Graph.HighlightRequest(ConceptGraph.this.vertices.keySet(), EdgeHighlight.CONTAINS_UPPER, Graph.COLOR_DEFAULT, Color.BLACK, Graph.COLOR_LABEL_DEFAULT, Color.BLACK, Graph.COLOR_LABEL_DEFAULT, Color.BLACK));
        }

        public final Iterable<Graph.HighlightRequest> concept(Concept<G, M> concept) {
            if (ConceptGraph.this.controller.graphLock || ConceptGraph.this.dontHighlight || !ConceptGraph.this.toolBar.highlight.isSelected()) {
                return Collections.emptySet();
            }
            return Collections.singleton(new Graph.HighlightRequest(Collections.singleton(concept), EdgeHighlight.CONTAINS_ONE, COLOR_CONCEPT, COLOR_CONCEPT, COLOR_CONCEPT, Color.BLACK, COLOR_CONCEPT, Color.BLACK));
        }

        public final Iterable<Graph.HighlightRequest> implication(Implication<M> implication) {
            if (ConceptGraph.this.controller.graphLock || ConceptGraph.this.dontHighlight || !ConceptGraph.this.toolBar.highlight.isSelected()) {
                return Collections.emptySet();
            }
            HashSet conceptsP = new HashSet();
            HashSet conceptsC = new HashSet();
            HashSet concepts = new HashSet();
            HashSet inner = new HashSet();
            for (Object m : implication.getPremise()) {
                conceptsP.add(((ConceptGraph)ConceptGraph.this).fca.context.attributeConcept(m));
            }
            for (Object m : implication.getConclusion()) {
                conceptsC.add(((ConceptGraph)ConceptGraph.this).fca.context.attributeConcept(m));
            }
            for (Object g : ((ConceptGraph)ConceptGraph.this).fca.context.colAnd(implication.getPremise())) {
                concepts.add(((ConceptGraph)ConceptGraph.this).fca.context.objectConcept(g));
            }
            return Sets.newHashSet((Object[])new Graph.HighlightRequest[]{new Graph.HighlightRequest(((ConceptGraph)ConceptGraph.this).fca.lattice.ideal(((ConceptGraph)ConceptGraph.this).fca.lattice.supremum(concepts)), EdgeHighlight.CONTAINS_BOTH, COLOR_CONCEPT, COLOR_CONCEPT, COLOR_CONCEPT, Color.WHITE, COLOR_CONCEPT, Color.WHITE), new Graph.HighlightRequest(conceptsP, EdgeHighlight.CONTAINS_LOWER, COLOR_UPPER, COLOR_UPPER, COLOR_UPPER, Color.BLACK, COLOR_UPPER, Color.BLACK), new Graph.HighlightRequest(conceptsC, EdgeHighlight.CONTAINS_UPPER, COLOR_LOWER, COLOR_LOWER, COLOR_LOWER, Color.BLACK, COLOR_LOWER, Color.BLACK), new Graph.HighlightRequest(inner, EdgeHighlight.CONTAINS_BOTH, COLOR_INTERVAL, COLOR_INTERVAL, COLOR_INTERVAL, Color.WHITE, COLOR_INTERVAL, Color.WHITE)});
        }

        public final Iterable<Graph.HighlightRequest> upperNeighbors(Concept<G, M> concept) {
            if (ConceptGraph.this.controller.graphLock || ConceptGraph.this.dontHighlight || !ConceptGraph.this.toolBar.highlight.isSelected()) {
                return Collections.emptySet();
            }
            return Collections.singleton(new Graph.HighlightRequest(((ConceptGraph)ConceptGraph.this).layout.lattice.upperNeighbors(concept), EdgeHighlight.CONTAINS_LOWER, COLOR_UPPER, COLOR_UPPER, Graph.COLOR_LABEL_DEFAULT, Color.BLACK, COLOR_UPPER, Color.WHITE));
        }

        public final Iterable<Graph.HighlightRequest> lowerNeighbors(Concept<G, M> concept) {
            if (ConceptGraph.this.controller.graphLock || ConceptGraph.this.dontHighlight || !ConceptGraph.this.toolBar.highlight.isSelected()) {
                return Collections.emptySet();
            }
            return Collections.singleton(new Graph.HighlightRequest(((ConceptGraph)ConceptGraph.this).layout.lattice.lowerNeighbors(concept), EdgeHighlight.CONTAINS_UPPER, COLOR_LOWER, COLOR_LOWER, COLOR_LOWER, Color.WHITE, Graph.COLOR_LABEL_DEFAULT, Color.BLACK));
        }

        public final Iterable<Graph.HighlightRequest> filter(Concept<G, M> concept) {
            if (ConceptGraph.this.controller.graphLock || ConceptGraph.this.dontHighlight || !ConceptGraph.this.toolBar.highlight.isSelected()) {
                return Collections.emptySet();
            }
            return Collections.singleton(new Graph.HighlightRequest(((ConceptGraph)ConceptGraph.this).layout.lattice.filter(concept), EdgeHighlight.CONTAINS_LOWER, COLOR_UPPER, COLOR_UPPER, Graph.COLOR_LABEL_DEFAULT, Color.BLACK, COLOR_UPPER, Color.WHITE));
        }

        public final Iterable<Graph.HighlightRequest> ideal(Concept<G, M> concept) {
            if (ConceptGraph.this.controller.graphLock || ConceptGraph.this.dontHighlight || !ConceptGraph.this.toolBar.highlight.isSelected()) {
                return Collections.emptySet();
            }
            return Collections.singleton(new Graph.HighlightRequest(((ConceptGraph)ConceptGraph.this).layout.lattice.ideal(concept), EdgeHighlight.CONTAINS_UPPER, COLOR_LOWER, COLOR_LOWER, COLOR_LOWER, Color.WHITE, Graph.COLOR_LABEL_DEFAULT, Color.BLACK));
        }

        public final Iterable<Graph.HighlightRequest> strictFilter(Concept<G, M> concept) {
            if (ConceptGraph.this.controller.graphLock || ConceptGraph.this.dontHighlight || !ConceptGraph.this.toolBar.highlight.isSelected()) {
                return Collections.emptySet();
            }
            return Collections.singleton(new Graph.HighlightRequest(Sets.difference(((ConceptGraph)ConceptGraph.this).layout.lattice.filter(concept), Collections.singleton(concept)), EdgeHighlight.CONTAINS_LOWER, COLOR_UPPER, COLOR_UPPER, Graph.COLOR_LABEL_DEFAULT, Color.BLACK, COLOR_UPPER, Color.WHITE));
        }

        public final Iterable<Graph.HighlightRequest> strictIdeal(Concept<G, M> concept) {
            if (ConceptGraph.this.controller.graphLock || ConceptGraph.this.dontHighlight || !ConceptGraph.this.toolBar.highlight.isSelected()) {
                return Collections.emptySet();
            }
            return Collections.singleton(new Graph.HighlightRequest(Sets.difference(((ConceptGraph)ConceptGraph.this).layout.lattice.ideal(concept), Collections.singleton(concept)), EdgeHighlight.CONTAINS_UPPER, COLOR_LOWER, COLOR_LOWER, COLOR_LOWER, Color.WHITE, Graph.COLOR_LABEL_DEFAULT, Color.BLACK));
        }

        public final Iterable<Graph.HighlightRequest> interval(Concept<G, M> lowerConcept, Concept<G, M> upperConcept) {
            if (ConceptGraph.this.controller.graphLock || ConceptGraph.this.dontHighlight || !ConceptGraph.this.toolBar.highlight.isSelected()) {
                return Collections.emptySet();
            }
            return Collections.singleton(new Graph.HighlightRequest(((ConceptGraph)ConceptGraph.this).layout.lattice.interval(lowerConcept, upperConcept), EdgeHighlight.CONTAINS_BOTH, COLOR_INTERVAL, COLOR_INTERVAL, COLOR_INTERVAL, Color.WHITE, COLOR_INTERVAL, Color.WHITE));
        }

        public final Iterable<Graph.HighlightRequest> object(G object) {
            if (ConceptGraph.this.controller.graphLock || ConceptGraph.this.dontHighlight || !ConceptGraph.this.toolBar.highlight.isSelected()) {
                return Collections.emptySet();
            }
            return this.filter(((ConceptGraph)ConceptGraph.this).fca.context.selection.objectConcept(object));
        }

        public final Iterable<Graph.HighlightRequest> attribute(M attribute) {
            if (ConceptGraph.this.controller.graphLock || ConceptGraph.this.dontHighlight || !ConceptGraph.this.toolBar.highlight.isSelected()) {
                return Collections.emptySet();
            }
            return this.ideal(((ConceptGraph)ConceptGraph.this).fca.context.selection.attributeConcept(attribute));
        }

        public final Iterable<Graph.HighlightRequest> incidence(G object, M attribute) {
            if (ConceptGraph.this.controller.graphLock || ConceptGraph.this.dontHighlight || !ConceptGraph.this.toolBar.highlight.isSelected()) {
                return Collections.emptySet();
            }
            return this.interval(((ConceptGraph)ConceptGraph.this).fca.context.selection.objectConcept(object), ((ConceptGraph)ConceptGraph.this).fca.context.selection.attributeConcept(attribute));
        }

        public final Iterable<Graph.HighlightRequest> nonIncidence(G object, M attribute) {
            if (ConceptGraph.this.controller.graphLock || ConceptGraph.this.dontHighlight || !ConceptGraph.this.toolBar.highlight.isSelected()) {
                return Collections.emptySet();
            }
            return Iterables.concat(this.filter(((ConceptGraph)ConceptGraph.this).fca.context.selection.objectConcept(object)), this.ideal(((ConceptGraph)ConceptGraph.this).fca.context.selection.attributeConcept(attribute)));
        }

        public final Iterable<Graph.HighlightRequest> downArrow(G object, M attribute) {
            if (ConceptGraph.this.controller.graphLock || ConceptGraph.this.dontHighlight || !ConceptGraph.this.toolBar.highlight.isSelected()) {
                return Collections.emptySet();
            }
            Concept objectConcept = ((ConceptGraph)ConceptGraph.this).fca.context.selection.objectConcept(object);
            Concept attributeConcept = ((ConceptGraph)ConceptGraph.this).fca.context.selection.attributeConcept(attribute);
            Concept uniqueLowerNeighborOfObjectConcept = ((ConceptGraph)ConceptGraph.this).fca.lattice.infimum(objectConcept, attributeConcept);
            return Iterables.concat(this.filter(objectConcept), this.ideal(attributeConcept), this.concept(objectConcept), this.concept(uniqueLowerNeighborOfObjectConcept));
        }

        public final Iterable<Graph.HighlightRequest> upArrow(G object, M attribute) {
            if (ConceptGraph.this.controller.graphLock || ConceptGraph.this.dontHighlight || !ConceptGraph.this.toolBar.highlight.isSelected()) {
                return Collections.emptySet();
            }
            Concept objectConcept = ((ConceptGraph)ConceptGraph.this).fca.context.selection.objectConcept(object);
            Concept attributeConcept = ((ConceptGraph)ConceptGraph.this).fca.context.selection.attributeConcept(attribute);
            Concept uniqueUpperNeighborOfAttributeConcept = ((ConceptGraph)ConceptGraph.this).fca.lattice.supremum(objectConcept, attributeConcept);
            return Iterables.concat(this.filter(objectConcept), this.ideal(attributeConcept), this.concept(attributeConcept), this.concept(uniqueUpperNeighborOfAttributeConcept));
        }

        public final Iterable<Graph.HighlightRequest> bothArrow(G object, M attribute) {
            if (ConceptGraph.this.controller.graphLock || ConceptGraph.this.dontHighlight || !ConceptGraph.this.toolBar.highlight.isSelected()) {
                return Collections.emptySet();
            }
            Concept objectConcept = ((ConceptGraph)ConceptGraph.this).fca.context.selection.objectConcept(object);
            Concept attributeConcept = ((ConceptGraph)ConceptGraph.this).fca.context.selection.attributeConcept(attribute);
            Concept uniqueUpperNeighborOfAttributeConcept = ((ConceptGraph)ConceptGraph.this).fca.lattice.supremum(objectConcept, attributeConcept);
            Concept uniqueLowerNeighborOfObjectConcept = ((ConceptGraph)ConceptGraph.this).fca.lattice.infimum(objectConcept, attributeConcept);
            return Iterables.concat((Iterable[])new Iterable[]{this.filter(objectConcept), this.ideal(attributeConcept), this.concept(objectConcept), this.concept(attributeConcept), this.concept(uniqueLowerNeighborOfObjectConcept), this.concept(uniqueUpperNeighborOfAttributeConcept)});
        }
    }

    private final class CFXToolBar {
        private final Button relayout = new Button();
        private final Button adjust = new Button();
        private final ToggleButton highlight = new ToggleButton();
        private final ToggleButton labels = new ToggleButton();

        private CFXToolBar() {
            ToolBar toolBar = new ToolBar();
            toolBar.getItems().addAll((Object[])new Node[]{this.createTransformationBox(), this.createLayoutBox(), this.createShowBox(), this.createSpace(), this.createSearchBox()});
            this.relayout.setGraphic((Node)ImageViewBuilder.create().image(new Image(ConExpFX.class.getResourceAsStream("image/16x16/refresh.png"))).build());
            this.adjust.setGraphic((Node)ImageViewBuilder.create().image(new Image(ConExpFX.class.getResourceAsStream("image/16x16/process.png"))).build());
            this.highlight.setGraphic((Node)ImageViewBuilder.create().image(new Image(ConExpFX.class.getResourceAsStream("image/16x16/flag.png"))).build());
            this.labels.setGraphic((Node)ImageViewBuilder.create().image(new Image(ConExpFX.class.getResourceAsStream("image/16x16/comments.png"))).build());
            ConceptGraph.this.setTop((Node)toolBar);
        }

        private final HBox createTransformationBox() {
            final ToggleGroup transformationToggleGroup = new ToggleGroup();
            ToggleButton transformation2DButton = new ToggleButton();
            final ToggleButton transformation3DButton = new ToggleButton();
            final ToggleButton transformationXYButton = new ToggleButton();
            final ToggleButton transformationPolarButton = new ToggleButton();
            transformation2DButton.setGraphic((Node)ImageViewBuilder.create().image(new Image(ConExpFX.class.getResourceAsStream("image/16x16/wired.png"))).build());
            transformation3DButton.setGraphic((Node)ImageViewBuilder.create().image(new Image(ConExpFX.class.getResourceAsStream("image/16x16/wired.png"))).build());
            transformationXYButton.setGraphic((Node)ImageViewBuilder.create().image(new Image(ConExpFX.class.getResourceAsStream("image/16x16/chart.png"))).build());
            transformationPolarButton.setGraphic((Node)ImageViewBuilder.create().image(new Image(ConExpFX.class.getResourceAsStream("image/16x16/target.png"))).build());
            transformation2DButton.setUserData((Object)GraphTransformation.GRAPH_2D);
            transformation3DButton.setUserData((Object)GraphTransformation.GRAPH_3D);
            transformationXYButton.setUserData((Object)GraphTransformation.XY);
            transformationPolarButton.setUserData((Object)GraphTransformation.POLAR);
            transformation2DButton.setToggleGroup(transformationToggleGroup);
            transformation3DButton.setToggleGroup(transformationToggleGroup);
            transformationXYButton.setToggleGroup(transformationToggleGroup);
            transformationPolarButton.setToggleGroup(transformationToggleGroup);
            transformationToggleGroup.selectToggle((Toggle)transformation2DButton);
            ConceptGraph.this.transformation.bind((ObservableValue)new ObjectBinding<GraphTransformation>(){
                private GraphTransformation lastValue = GraphTransformation.GRAPH_3D;
                {
                    this.bind(new Observable[]{transformationToggleGroup.selectedToggleProperty()});
                }

                protected final GraphTransformation computeValue() {
                    Toggle toggle = (Toggle)transformationToggleGroup.selectedToggleProperty().get();
                    if (toggle != null) {
                        this.lastValue = (GraphTransformation)((Object)((ToggleButton)toggle).getUserData());
                        switch (this.lastValue) {
                            case GRAPH_2D: {
                                ConceptGraph.this.layout.deleteZ();
                            }
                            case GRAPH_3D: {
                                ConceptGraph.this.controlBox.conflictChart.setDisable(false);
                                break;
                            }
                            case XY: 
                            case POLAR: {
                                ConceptGraph.this.controlBox.conflictChart.selectedProperty().set(false);
                                ConceptGraph.this.controlBox.conflictChart.setDisable(true);
                                break;
                            }
                        }
                        return this.lastValue;
                    }
                    transformationToggleGroup.selectToggle((Toggle)(this.lastValue == GraphTransformation.GRAPH_3D ? transformation3DButton : (this.lastValue == GraphTransformation.XY ? transformationXYButton : transformationPolarButton)));
                    return this.lastValue;
                }
            });
            HBox transformationBox = new HBox();
            transformationBox.setPadding(new Insets(0.0));
            transformation2DButton.setStyle("-fx-background-radius: 5 0 0 5, 5 0 0 5, 4 0 0 4, 3 0 0 3;");
            transformation3DButton.setStyle("-fx-background-radius: 0, 0, 0, 0;");
            transformationXYButton.setStyle("-fx-background-radius: 0, 0, 0, 0;");
            transformationPolarButton.setStyle("-fx-background-radius: 0 5 5 0, 0 5 5 0, 0 4 4 0, 0 3 3 0;");
            transformation2DButton.setMinHeight(24.0);
            transformation3DButton.setMinHeight(24.0);
            transformationXYButton.setMinHeight(24.0);
            transformationPolarButton.setMinHeight(24.0);
            transformationBox.getChildren().addAll((Object[])new Node[]{transformation2DButton, transformation3DButton, transformationXYButton, transformationPolarButton});
            return transformationBox;
        }

        private final HBox createLayoutBox() {
            this.relayout.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public final void handle(ActionEvent event) {
                    ConceptGraph.this.fca.relayout((int)ConceptGraph.this.controlBox.generations.getValue(), (int)ConceptGraph.this.controlBox.population.getValue());
                }
            });
            this.adjust.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public final void handle(ActionEvent event) {
                    ConceptGraph.this.fca.refine((int)ConceptGraph.this.controlBox.generations.getValue());
                }
            });
            this.relayout.setMinHeight(24.0);
            this.adjust.setMinHeight(24.0);
            this.relayout.setStyle("-fx-background-radius: 5 0 0 5, 5 0 0 5, 4 0 0 4, 3 0 0 3;");
            this.adjust.setStyle("-fx-background-radius: 0 5 5 0, 0 5 5 0, 0 4 4 0, 0 3 3 0;");
            HBox layoutBox = new HBox();
            layoutBox.setPadding(new Insets(0.0));
            layoutBox.getChildren().addAll((Object[])new Node[]{this.relayout, this.adjust});
            return layoutBox;
        }

        private final HBox createShowBox() {
            this.highlight.setSelected(false);
            this.highlight.setMinHeight(24.0);
            this.labels.setSelected(true);
            this.labels.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public final void changed(ObservableValue<? extends Boolean> observable, Boolean wasSelected, Boolean isSelected) {
                    if (isSelected.booleanValue()) {
                        ConceptGraph.this.controlBox.objectLabelText.getSelectionModel().select((Object)ObjectLabelText.OBJECT_LABELS);
                        ConceptGraph.this.controlBox.attributeLabelText.getSelectionModel().select((Object)AttributeLabelText.ATTRIBUTE_LABELS);
                    } else {
                        ConceptGraph.this.controlBox.objectLabelText.getSelectionModel().select((Object)ObjectLabelText.NONE);
                        ConceptGraph.this.controlBox.attributeLabelText.getSelectionModel().select((Object)AttributeLabelText.NONE);
                    }
                }
            });
            this.labels.setMinHeight(24.0);
            this.highlight.setStyle("-fx-background-radius: 5 0 0 5, 5 0 0 5, 4 0 0 4, 3 0 0 3;");
            this.labels.setStyle("-fx-background-radius: 0 5 5 0, 0 5 5 0, 0 4 4 0, 0 3 3 0;");
            HBox showBox = new HBox();
            showBox.setPadding(new Insets(0.0));
            showBox.getChildren().addAll((Object[])new Node[]{this.highlight, this.labels});
            return showBox;
        }

        private final HBox createSpace() {
            HBox space = new HBox();
            HBox.setHgrow((Node)space, (Priority)Priority.ALWAYS);
            return space;
        }

        private final SearchBox createSearchBox() {
            SearchBox searchBox = new SearchBox();
            searchBox.textBox.addEventHandler(MouseEvent.MOUSE_EXITED, (EventHandler)new EventHandler<MouseEvent>(){

                public final void handle(MouseEvent event) {
                    ConceptGraph.this.requestFocus();
                }
            });
            searchBox.textBox.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public final void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    if (newValue.equals("")) {
                        ConceptGraph.this.highlight(false, ConceptGraph.this.highlightRequests.dehighlight());
                    } else {
                        HashSet<Object> concepts = new HashSet<Object>();
                        for (Object g : ((ConceptGraph)ConceptGraph.this).fca.context.selection.rowHeads()) {
                            if (!g.toString().toLowerCase().contains(newValue.toLowerCase())) continue;
                            concepts.add(((ConceptGraph)ConceptGraph.this).fca.lattice.objectConcepts.get(g));
                        }
                        for (Object m : ((ConceptGraph)ConceptGraph.this).fca.context.selection.colHeads()) {
                            if (!m.toString().toLowerCase().contains(newValue.toLowerCase())) continue;
                            concepts.add(((ConceptGraph)ConceptGraph.this).fca.lattice.attributeConcepts.get(m));
                        }
                        ConceptGraph.this.highlight(true, Iterables.concat((Iterable)Iterables.transform(concepts, (Function)new Function<Concept<G, M>, Iterable<Graph.HighlightRequest>>(){

                            public final Iterable<Graph.HighlightRequest> apply(Concept<G, M> concept) {
                                return ConceptGraph.this.highlightRequests.concept(concept);
                            }
                        })));
                    }
                }
            });
            return searchBox;
        }
    }

    private final class CFXControlBox {
        private final VBox content = new VBox();
        private final ChoiceBox<AdditiveConceptLayout.Type> layoutType = FXControls.newChoiceBox(AdditiveConceptLayout.Type.HYBRID, AdditiveConceptLayout.Type.values());
        private final ChoiceBox<AnimationSpeed> animationSpeed = FXControls.newChoiceBox(AnimationSpeed.DEFAULT, AnimationSpeed.values());
        private final ListSpinner<Integer> labelTextSize = FXControls.newListSpinner(Integer.valueOf(12), 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 18, 20, 24);
        private final StringBinding textSizeBinding = new StringBinding(){
            {
                this.bind(new Observable[]{CFXControlBox.this.labelTextSize.valueProperty()});
            }

            protected final String computeValue() {
                return "-fx-font-size: " + CFXControlBox.this.labelTextSize.valueProperty().get() + ";";
            }
        };
        private final ChoiceBox<ObjectLabelText> objectLabelText = FXControls.newChoiceBox(ObjectLabelText.OBJECT_LABELS, ObjectLabelText.values());
        private final ChoiceBox<AttributeLabelText> attributeLabelText = FXControls.newChoiceBox(AttributeLabelText.ATTRIBUTE_LABELS, AttributeLabelText.values());
        private final ChoiceBox<VertexRadius> vertexRadius = FXControls.newChoiceBox(VertexRadius.NORMAL, VertexRadius.values());
        private final ChoiceBox<EdgeStroke> edgeStroke = FXControls.newChoiceBox(EdgeStroke.SMALL, EdgeStroke.values());
        private final ChoiceBox<VertexHighlight> vertexHighlight = FXControls.newChoiceBox(VertexHighlight.FILTER_IDEAL, VertexHighlight.values());
        private final Slider generations = SliderBuilder.create().min(0.0).max(16.0).value(1.0).majorTickUnit(1.0).minorTickCount(0).snapToTicks(true).build();
        private final Slider population = SliderBuilder.create().min(1.0).max(64.0).value(64.0).majorTickUnit(1.0).minorTickCount(0).snapToTicks(true).build();
        private final CheckBox conflictChart = new CheckBox("Conflict Chart");
        private final CheckBox voronoiChart = new CheckBox("Voronoi Chart");
        private final CheckBox hideBottom = new CheckBox("Hide Bottom Concept");
        private final CheckBox hideTop = new CheckBox("Hide Top Concept");

        private CFXControlBox() {
            this.createContent();
            this.createListeners();
        }

        private final void createContent() {
            double inset = 4.0;
            this.content.setPadding(new Insets(4.0));
            this.content.setSpacing(1.0);
            this.content.getChildren().add((Object)RectangleBuilder.create().height(4.0).build());
            this.content.getChildren().add((Object)new Text("Layout Type:"));
            this.content.getChildren().add(this.layoutType);
            this.content.getChildren().add((Object)RectangleBuilder.create().height(4.0).build());
            this.content.getChildren().add((Object)new Text("Animation Speed:"));
            this.content.getChildren().add(this.animationSpeed);
            this.content.getChildren().add((Object)RectangleBuilder.create().height(4.0).build());
            this.content.getChildren().add((Object)new Text("Label Text Size:"));
            this.content.getChildren().add(this.labelTextSize);
            this.content.getChildren().add((Object)RectangleBuilder.create().height(4.0).build());
            this.content.getChildren().add((Object)new Text("Object Label Text:"));
            this.content.getChildren().add(this.objectLabelText);
            this.content.getChildren().add((Object)RectangleBuilder.create().height(4.0).build());
            this.content.getChildren().add((Object)new Text("Attribute Label Text:"));
            this.content.getChildren().add(this.attributeLabelText);
            this.content.getChildren().add((Object)RectangleBuilder.create().height(4.0).build());
            this.content.getChildren().add((Object)new Text("Concept Vertex Radius:"));
            this.content.getChildren().add(this.vertexRadius);
            this.content.getChildren().add((Object)RectangleBuilder.create().height(4.0).build());
            this.content.getChildren().add((Object)new Text("Concept Edge Stroke:"));
            this.content.getChildren().add(this.edgeStroke);
            this.content.getChildren().add((Object)RectangleBuilder.create().height(4.0).build());
            this.content.getChildren().add((Object)new Text("Concept Vertex Highlight:"));
            this.content.getChildren().add(this.vertexHighlight);
            this.content.getChildren().add((Object)RectangleBuilder.create().height(16.0).build());
            this.content.getChildren().add((Object)FXControls.newText(new StringBinding(){
                {
                    this.bind(new Observable[]{CFXControlBox.this.generations.valueProperty()});
                }

                protected String computeValue() {
                    return "Generations: " + (int)CFXControlBox.this.generations.valueProperty().get();
                }
            }));
            this.content.getChildren().add((Object)this.generations);
            this.content.getChildren().add((Object)RectangleBuilder.create().height(4.0).build());
            this.content.getChildren().add((Object)FXControls.newText(new StringBinding(){
                {
                    this.bind(new Observable[]{CFXControlBox.this.population.valueProperty()});
                }

                protected String computeValue() {
                    return "Population: " + (int)CFXControlBox.this.population.valueProperty().get();
                }
            }));
            this.content.getChildren().add((Object)this.population);
            this.content.getChildren().add((Object)RectangleBuilder.create().height(16.0).build());
            this.content.getChildren().add((Object)this.conflictChart);
            this.content.getChildren().add((Object)RectangleBuilder.create().height(4.0).build());
            this.content.getChildren().add((Object)this.voronoiChart);
            this.content.getChildren().add((Object)RectangleBuilder.create().height(4.0).build());
            this.content.getChildren().add((Object)this.hideBottom);
            this.content.getChildren().add((Object)RectangleBuilder.create().height(4.0).build());
            this.content.getChildren().add((Object)this.hideTop);
        }

        private final void createListeners() {
            ConceptGraph.this.front.addEventHandler(MouseEvent.MOUSE_MOVED, (EventHandler)new EventHandler<MouseEvent>(){

                public final void handle(MouseEvent event) {
                    boolean shouldShow;
                    boolean isShown = ConceptGraph.this.getRight() != null;
                    boolean bl = shouldShow = event.getX() > ConceptGraph.this.front.widthProperty().get() - 50.0;
                    if (isShown == shouldShow) {
                        return;
                    }
                    if (!shouldShow) {
                        ConceptGraph.this.setRight(null);
                    } else {
                        ConceptGraph.this.setRight((Node)CFXControlBox.this.content);
                    }
                }
            });
            ConceptGraph.this.setOnMouseExited(e -> ConceptGraph.this.setRight(null));
            this.animationSpeed.valueProperty().addListener((ChangeListener)new ChangeListener<AnimationSpeed>(){

                public final void changed(ObservableValue<? extends AnimationSpeed> observable, AnimationSpeed oldValue, AnimationSpeed newValue) {
                    ConceptGraph.this.speed = newValue;
                }
            });
            this.objectLabelText.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<ObjectLabelText>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void changed(ObservableValue<? extends ObjectLabelText> observable, ObjectLabelText oldValue, ObjectLabelText newValue) {
                    boolean wasNoneOrObjectLabels = oldValue == ObjectLabelText.NONE || oldValue == ObjectLabelText.OBJECT_LABELS;
                    switch (newValue) {
                        case NONE: {
                            Map map = ConceptGraph.this.objectLabels;
                            synchronized (map) {
                                for (ObjectLabel l : ConceptGraph.this.objectLabels.values()) {
                                    l.dispose();
                                }
                            }
                            map = ConceptGraph.this.vertices;
                            synchronized (map) {
                                for (Graph.Vertex cv : ConceptGraph.this.vertices.values()) {
                                    ObservableList<Graph.LowerLabel> observableList = cv.lowerLabels;
                                    synchronized (observableList) {
                                        for (Graph.LowerLabel l : cv.lowerLabels) {
                                            l.dispose();
                                        }
                                    }
                                }
                                break;
                            }
                        }
                        case OBJECT_LABELS: {
                            ObservableMap observableMap = ConceptGraph.this.vertices;
                            synchronized (observableMap) {
                                for (Graph.Vertex cv : ConceptGraph.this.vertices.values()) {
                                    ObservableList<Graph.LowerLabel> observableList = cv.lowerLabels;
                                    synchronized (observableList) {
                                        for (Graph.LowerLabel l : cv.lowerLabels) {
                                            l.dispose();
                                        }
                                    }
                                }
                            }
                            observableMap = ((ConceptGraph)ConceptGraph.this).layout.lattice.objectConcepts;
                            synchronized (observableMap) {
                                for (Map.Entry e : ((ConceptGraph)ConceptGraph.this).layout.lattice.objectConcepts.entrySet()) {
                                    new ObjectLabel(e.getKey(), (Concept)e.getValue());
                                }
                                break;
                            }
                        }
                        case EXTENT_SIZE: 
                        case EXTENT_PERCENTAGE: 
                        case OBJECT_LABELS_SIZE: 
                        case OBJECT_LABELS_PERCENTAGE: {
                            if (!wasNoneOrObjectLabels) break;
                            Map map = ConceptGraph.this.objectLabels;
                            synchronized (map) {
                                for (ObjectLabel l : ConceptGraph.this.objectLabels.values()) {
                                    l.dispose();
                                }
                            }
                            for (Concept c : ((ConceptGraph)ConceptGraph.this).layout.lattice.rowHeads()) {
                                new ObjectLabel(c);
                            }
                            break;
                        }
                    }
                    ConceptGraph.this.layout.invalidate();
                }
            });
            this.attributeLabelText.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<AttributeLabelText>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void changed(ObservableValue<? extends AttributeLabelText> observable, AttributeLabelText oldValue, AttributeLabelText newValue) {
                    boolean wasNoneOrAttributeLabels = oldValue == AttributeLabelText.NONE || oldValue == AttributeLabelText.ATTRIBUTE_LABELS;
                    switch (newValue) {
                        case NONE: {
                            Map map = ConceptGraph.this.attributeLabels;
                            synchronized (map) {
                                for (AttributeLabel u : ConceptGraph.this.attributeLabels.values()) {
                                    u.dispose();
                                }
                            }
                            map = ConceptGraph.this.vertices;
                            synchronized (map) {
                                for (Graph.Vertex cv : ConceptGraph.this.vertices.values()) {
                                    ObservableList<Graph.UpperLabel> observableList = cv.upperLabels;
                                    synchronized (observableList) {
                                        for (Graph.UpperLabel u : cv.upperLabels) {
                                            u.dispose();
                                        }
                                    }
                                }
                                break;
                            }
                        }
                        case ATTRIBUTE_LABELS: {
                            ObservableMap observableMap = ConceptGraph.this.vertices;
                            synchronized (observableMap) {
                                for (Graph.Vertex cv : ConceptGraph.this.vertices.values()) {
                                    ObservableList<Graph.UpperLabel> observableList = cv.upperLabels;
                                    synchronized (observableList) {
                                        for (Graph.UpperLabel u : cv.upperLabels) {
                                            u.dispose();
                                        }
                                    }
                                }
                            }
                            observableMap = ((ConceptGraph)ConceptGraph.this).layout.lattice.attributeConcepts;
                            synchronized (observableMap) {
                                for (Map.Entry e : ((ConceptGraph)ConceptGraph.this).layout.lattice.attributeConcepts.entrySet()) {
                                    new AttributeLabel(e.getKey(), (Concept)e.getValue());
                                }
                                break;
                            }
                        }
                        case SEED_LABELS: {
                            ObservableMap observableMap = ConceptGraph.this.vertices;
                            synchronized (observableMap) {
                                for (Graph.Vertex cv : ConceptGraph.this.vertices.values()) {
                                    ObservableList<Graph.UpperLabel> observableList = cv.upperLabels;
                                    synchronized (observableList) {
                                        for (Graph.UpperLabel u : cv.upperLabels) {
                                            u.dispose();
                                        }
                                    }
                                }
                            }
                            observableMap = ((ConceptGraph)ConceptGraph.this).layout.lattice.attributeConcepts;
                            synchronized (observableMap) {
                                for (Map.Entry e : ((ConceptGraph)ConceptGraph.this).layout.lattice.attributeConcepts.entrySet()) {
                                    new AttributeLabel(e.getKey(), (Concept)e.getValue());
                                }
                                break;
                            }
                        }
                        case INTENT_SIZE: 
                        case INTENT_PERCENTAGE: 
                        case ATTRIBUTE_LABELS_SIZE: 
                        case ATTRIBUTE_LABELS_PERCENTAGE: {
                            if (!wasNoneOrAttributeLabels) break;
                            Map map = ConceptGraph.this.attributeLabels;
                            synchronized (map) {
                                for (AttributeLabel u : ConceptGraph.this.attributeLabels.values()) {
                                    u.dispose();
                                }
                            }
                            for (Concept c : ((ConceptGraph)ConceptGraph.this).layout.lattice.rowHeads()) {
                                new AttributeLabel(c);
                            }
                            break;
                        }
                    }
                    ConceptGraph.this.layout.invalidate();
                }
            });
            ConceptGraph.this.controller.showVoronoi.bind((ObservableValue)this.voronoiChart.selectedProperty());
            this.hideBottom.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean wasHidden, Boolean hide) {
                    if (hide == wasHidden) {
                        return;
                    }
                    ConceptGraph.this.layout.invalidate();
                    if (hide.booleanValue()) {
                        for (Graph.Edge e : ConceptGraph.this.upperEdges(((ConceptGraph)ConceptGraph.this).fca.context.selection.bottomConcept())) {
                            e.line.opacityProperty().unbind();
                            e.line.opacityProperty().bind((ObservableValue)new SimpleDoubleProperty(0.05));
                        }
                    } else {
                        for (Graph.Edge e : ConceptGraph.this.upperEdges(((ConceptGraph)ConceptGraph.this).fca.context.selection.bottomConcept())) {
                            e.line.opacityProperty().unbind();
                            e.line.opacityProperty().bind((ObservableValue)e.opacity);
                        }
                    }
                }
            });
            this.hideTop.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean wasHidden, Boolean hide) {
                    if (hide == wasHidden) {
                        return;
                    }
                    ConceptGraph.this.layout.invalidate();
                    if (hide.booleanValue()) {
                        for (Graph.Edge e : ConceptGraph.this.lowerEdges(((ConceptGraph)ConceptGraph.this).fca.context.selection.topConcept())) {
                            e.line.opacityProperty().unbind();
                            e.line.opacityProperty().bind((ObservableValue)new SimpleDoubleProperty(0.05));
                        }
                    } else {
                        for (Graph.Edge e : ConceptGraph.this.lowerEdges(((ConceptGraph)ConceptGraph.this).fca.context.selection.topConcept())) {
                            e.line.opacityProperty().unbind();
                            e.line.opacityProperty().bind((ObservableValue)e.opacity);
                        }
                    }
                }
            });
        }
    }

    protected final class AttributeLabel
    extends Graph.UpperLabel {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private AttributeLabel(final M attribute, final Concept<G, M> concept) {
            super(new ObjectBinding<Concept<G, M>>(){
                private final M m;
                private Concept<G, M> c;
                {
                    this.m = attribute;
                    this.c = concept;
                    ((ConceptGraph)ConceptGraph.this).layout.lattice.attributeConcepts.addListener(new MapChangeListener<M, Concept<G, M>>(){

                        public final void onChanged(MapChangeListener.Change<? extends M, ? extends Concept<G, M>> change) {
                            if (change.wasRemoved() && change.wasAdded() && change.getKey().equals(m)) {
                                c = (Concept)change.getValueAdded();
                                this.invalidate();
                            }
                        }
                    });
                }

                protected final Concept<G, M> computeValue() {
                    return this.c;
                }
            }, (ObservableValue<String>)new SimpleStringProperty(attribute.toString()), true);
            this.text.styleProperty().bind((ObservableValue)ConceptGraph.this.controlBox.textSizeBinding);
            Map map = ConceptGraph.this.attributeLabels;
            synchronized (map) {
                AttributeLabel old = ConceptGraph.this.attributeLabels.put(attribute, this);
                if (old != null) {
                    old.dispose();
                }
            }
        }

        private AttributeLabel(final Concept<G, M> concept) {
            super(new SimpleObjectProperty(concept), (ObservableValue<String>)new StringBinding(){
                {
                    this.bind(new Observable[]{concept.intent(), ConceptGraph.this.controlBox.attributeLabelText.getSelectionModel().selectedItemProperty()});
                }

                protected final String computeValue() {
                    return ((AttributeLabelText)((Object)ConceptGraph.this.controlBox.attributeLabelText.getSelectionModel().selectedItemProperty().get())).get(((ConceptGraph)ConceptGraph.this).fca.context, ((ConceptGraph)ConceptGraph.this).fca.lattice, concept);
                }
            }, true);
            this.text.styleProperty().bind((ObservableValue)ConceptGraph.this.controlBox.textSizeBinding);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final void dispose() {
            Map map = ConceptGraph.this.attributeLabels;
            synchronized (map) {
                ConceptGraph.this.attributeLabels.values().remove(this);
            }
            super.dispose();
        }
    }

    protected final class ObjectLabel
    extends Graph.LowerLabel {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ObjectLabel(final G object, final Concept<G, M> concept) {
            super(new ObjectBinding<Concept<G, M>>(){
                private final G g;
                private Concept<G, M> c;
                {
                    this.g = object;
                    this.c = concept;
                    ((ConceptGraph)ConceptGraph.this).layout.lattice.objectConcepts.addListener(new MapChangeListener<G, Concept<G, M>>(){

                        public final void onChanged(MapChangeListener.Change<? extends G, ? extends Concept<G, M>> change) {
                            if (change.wasRemoved() && change.wasAdded() && change.getKey().equals(g)) {
                                c = (Concept)change.getValueAdded();
                                this.invalidate();
                            }
                        }
                    });
                }

                protected final Concept<G, M> computeValue() {
                    return this.c;
                }
            }, (ObservableValue<String>)new SimpleStringProperty(object.toString()), true);
            this.text.styleProperty().bind((ObservableValue)ConceptGraph.this.controlBox.textSizeBinding);
            Map map = ConceptGraph.this.objectLabels;
            synchronized (map) {
                ObjectLabel old = ConceptGraph.this.objectLabels.put(object, this);
                if (old != null) {
                    old.dispose();
                }
            }
        }

        private ObjectLabel(final Concept<G, M> concept) {
            super(new SimpleObjectProperty(concept), (ObservableValue<String>)new StringBinding(){
                {
                    this.bind(new Observable[]{concept.intent(), ConceptGraph.this.controlBox.objectLabelText.getSelectionModel().selectedItemProperty()});
                }

                protected final String computeValue() {
                    return ((ObjectLabelText)((Object)ConceptGraph.this.controlBox.objectLabelText.getSelectionModel().selectedItemProperty().get())).get(((ConceptGraph)ConceptGraph.this).fca.context, ((ConceptGraph)ConceptGraph.this).fca.lattice, concept);
                }
            }, true);
            this.text.styleProperty().bind((ObservableValue)ConceptGraph.this.controlBox.textSizeBinding);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final void dispose() {
            Map map = ConceptGraph.this.objectLabels;
            synchronized (map) {
                ConceptGraph.this.objectLabels.values().remove(this);
            }
            super.dispose();
        }
    }

    protected final class ConceptEdge
    extends Graph.Edge {
        private ConceptEdge(final Pair<Concept<G, M>, Concept<G, M>> concepts) {
            super(concepts);
            this.line.strokeWidthProperty().bind((ObservableValue)new DoubleBinding(){
                {
                    this.bind(new Observable[]{((Concept)concepts.first()).intent(), ((Concept)concepts.second()).intent(), ConceptGraph.this.controlBox.edgeStroke.getSelectionModel().selectedItemProperty()});
                }

                protected final double computeValue() {
                    return ((EdgeStroke)((Object)ConceptGraph.this.controlBox.edgeStroke.getSelectionModel().selectedItemProperty().get())).get(((ConceptGraph)ConceptGraph.this).fca.context, ((ConceptGraph)ConceptGraph.this).fca.lattice, concepts);
                }
            });
        }
    }

    protected final class ConceptVertex
    extends Graph.Vertex {
        private final EventHandler<MouseEvent> dragHandler;
        private final EventHandler<MouseEvent> highlightHandler;
        private SetChangeListener<LayoutEvolution.Value> qualityChartListener;

        private ConceptVertex(Concept<G, M> concept, Double layoutX, Double layoutY) {
            super((Graph)ConceptGraph.this, concept, (Node)new Circle(), ConceptGraph.this.layout.getOrAddPosition(concept), layoutX, layoutY);
            this.dragHandler = new DragHandler();
            this.highlightHandler = new HighlightHandler();
            this.init();
            ((Circle)this.node).setFill((Paint)Graph.COLOR_DEFAULT);
            ((Circle)this.node).setStrokeType(StrokeType.OUTSIDE);
            ((Circle)this.node).setStroke((Paint)Color.BLACK);
            ((Circle)this.node).setStrokeWidth(1.0);
            ((Circle)this.node).addEventHandler(MouseEvent.MOUSE_PRESSED, this.dragHandler);
            ((Circle)this.node).addEventHandler(MouseEvent.MOUSE_DRAGGED, this.dragHandler);
            ((Circle)this.node).addEventHandler(MouseEvent.MOUSE_RELEASED, this.dragHandler);
            ((Circle)this.node).addEventHandler(MouseEvent.MOUSE_ENTERED, this.highlightHandler);
            ((Circle)this.node).addEventHandler(MouseEvent.MOUSE_EXITED, this.highlightHandler);
            this.upperLabels.addListener((ListChangeListener)new ListChangeListener<Graph.UpperLabel>(){

                public void onChanged(ListChangeListener.Change<? extends Graph.UpperLabel> change) {
                    while (change.next()) {
                        if (change.wasRemoved()) {
                            for (Graph.UpperLabel l : change.getRemoved()) {
                                l.content.removeEventHandler(MouseEvent.MOUSE_PRESSED, ConceptVertex.this.dragHandler);
                                l.content.removeEventHandler(MouseEvent.MOUSE_DRAGGED, ConceptVertex.this.dragHandler);
                                l.content.removeEventHandler(MouseEvent.MOUSE_RELEASED, ConceptVertex.this.dragHandler);
                                l.content.removeEventHandler(MouseEvent.MOUSE_ENTERED, ConceptVertex.this.highlightHandler);
                                l.content.removeEventHandler(MouseEvent.MOUSE_EXITED, ConceptVertex.this.highlightHandler);
                                l.shift.unbind();
                            }
                            continue;
                        }
                        if (!change.wasAdded()) continue;
                        for (Graph.UpperLabel l : change.getAddedSubList()) {
                            l.content.addEventHandler(MouseEvent.MOUSE_PRESSED, ConceptVertex.this.dragHandler);
                            l.content.addEventHandler(MouseEvent.MOUSE_DRAGGED, ConceptVertex.this.dragHandler);
                            l.content.addEventHandler(MouseEvent.MOUSE_RELEASED, ConceptVertex.this.dragHandler);
                            l.content.addEventHandler(MouseEvent.MOUSE_ENTERED, ConceptVertex.this.highlightHandler);
                            l.content.addEventHandler(MouseEvent.MOUSE_EXITED, ConceptVertex.this.highlightHandler);
                            l.shift.bind((ObservableValue)new ObjectBinding<Point2D>(){
                                {
                                    this.bind(new Observable[]{((Circle)ConceptVertex.this.node).radiusProperty()});
                                }

                                protected Point2D computeValue() {
                                    return new Point2D(0.0, -((Circle)ConceptVertex.this.node).radiusProperty().get() - 1.0);
                                }
                            });
                        }
                    }
                }
            });
            this.lowerLabels.addListener((ListChangeListener)new ListChangeListener<Graph.LowerLabel>(){

                public void onChanged(ListChangeListener.Change<? extends Graph.LowerLabel> change) {
                    while (change.next()) {
                        if (change.wasRemoved()) {
                            for (Graph.LowerLabel l : change.getRemoved()) {
                                l.content.removeEventHandler(MouseEvent.MOUSE_PRESSED, ConceptVertex.this.dragHandler);
                                l.content.removeEventHandler(MouseEvent.MOUSE_DRAGGED, ConceptVertex.this.dragHandler);
                                l.content.removeEventHandler(MouseEvent.MOUSE_RELEASED, ConceptVertex.this.dragHandler);
                                l.content.removeEventHandler(MouseEvent.MOUSE_ENTERED, ConceptVertex.this.highlightHandler);
                                l.content.removeEventHandler(MouseEvent.MOUSE_EXITED, ConceptVertex.this.highlightHandler);
                                l.shift.unbind();
                            }
                            continue;
                        }
                        if (!change.wasAdded()) continue;
                        for (Graph.LowerLabel l : change.getAddedSubList()) {
                            l.content.addEventHandler(MouseEvent.MOUSE_PRESSED, ConceptVertex.this.dragHandler);
                            l.content.addEventHandler(MouseEvent.MOUSE_DRAGGED, ConceptVertex.this.dragHandler);
                            l.content.addEventHandler(MouseEvent.MOUSE_RELEASED, ConceptVertex.this.dragHandler);
                            l.content.addEventHandler(MouseEvent.MOUSE_ENTERED, ConceptVertex.this.highlightHandler);
                            l.content.addEventHandler(MouseEvent.MOUSE_EXITED, ConceptVertex.this.highlightHandler);
                            l.shift.bind((ObservableValue)new ObjectBinding<Point2D>(){
                                {
                                    this.bind(new Observable[]{((Circle)ConceptVertex.this.node).radiusProperty()});
                                }

                                protected Point2D computeValue() {
                                    return new Point2D(0.0, ((Circle)ConceptVertex.this.node).radiusProperty().get() + 1.0);
                                }
                            });
                        }
                    }
                }
            });
            switch ((ObjectLabelText)((Object)ConceptGraph.this.controlBox.objectLabelText.getSelectionModel().selectedItemProperty().get())) {
                case EXTENT_SIZE: 
                case EXTENT_PERCENTAGE: 
                case OBJECT_LABELS_SIZE: 
                case OBJECT_LABELS_PERCENTAGE: {
                    new ObjectLabel(concept);
                }
            }
            switch ((AttributeLabelText)((Object)ConceptGraph.this.controlBox.attributeLabelText.getSelectionModel().selectedItemProperty().get())) {
                case INTENT_SIZE: 
                case INTENT_PERCENTAGE: 
                case ATTRIBUTE_LABELS_SIZE: 
                case ATTRIBUTE_LABELS_PERCENTAGE: {
                    new AttributeLabel(concept);
                }
            }
        }

        @Override
        protected final void init() {
            ((Circle)this.node).radiusProperty().bind((ObservableValue)new DoubleBinding(){
                {
                    this.bind(new Observable[]{((Concept)ConceptVertex.this.element).intent(), ConceptGraph.this.controlBox.vertexRadius.getSelectionModel().selectedItemProperty()});
                }

                public final double computeValue() {
                    return ((VertexRadius)((Object)ConceptGraph.this.controlBox.vertexRadius.getSelectionModel().selectedItemProperty().get())).get(((ConceptGraph)ConceptGraph.this).fca.context, ((ConceptGraph)ConceptGraph.this).fca.lattice, (Concept)ConceptVertex.this.element);
                }
            });
        }

        private final void highlight() {
            VertexHighlight vertexHighlightOption = (VertexHighlight)((Object)ConceptGraph.this.controlBox.vertexHighlight.getSelectionModel().selectedItemProperty().get());
            if (vertexHighlightOption.equals((Object)VertexHighlight.NONE)) {
                return;
            }
            ((ConceptGraph)ConceptGraph.this).fca.contextWidget.highlight((Concept)this.element);
            switch (vertexHighlightOption) {
                case CONCEPT: {
                    ConceptGraph.this.highlight(true, ConceptGraph.this.highlightRequests.concept((Concept)this.element));
                    break;
                }
                case UPPER_NEIGHBORS: {
                    ConceptGraph.this.highlight(true, ConceptGraph.this.highlightRequests.concept((Concept)this.element), ConceptGraph.this.highlightRequests.upperNeighbors((Concept)this.element));
                    break;
                }
                case LOWER_NEIGHBORS: {
                    ConceptGraph.this.highlight(true, ConceptGraph.this.highlightRequests.concept((Concept)this.element), ConceptGraph.this.highlightRequests.lowerNeighbors((Concept)this.element));
                    break;
                }
                case NEIGHBORS: {
                    ConceptGraph.this.highlight(true, ConceptGraph.this.highlightRequests.concept((Concept)this.element), ConceptGraph.this.highlightRequests.upperNeighbors((Concept)this.element), ConceptGraph.this.highlightRequests.lowerNeighbors((Concept)this.element));
                    break;
                }
                case FILTER: {
                    ConceptGraph.this.highlight(true, ConceptGraph.this.highlightRequests.concept((Concept)this.element), ConceptGraph.this.highlightRequests.strictFilter((Concept)this.element));
                    break;
                }
                case IDEAL: {
                    ConceptGraph.this.highlight(true, ConceptGraph.this.highlightRequests.concept((Concept)this.element), ConceptGraph.this.highlightRequests.strictIdeal((Concept)this.element));
                    break;
                }
                case FILTER_IDEAL: {
                    ConceptGraph.this.highlight(true, ConceptGraph.this.highlightRequests.concept((Concept)this.element), ConceptGraph.this.highlightRequests.strictFilter((Concept)this.element), ConceptGraph.this.highlightRequests.strictIdeal((Concept)this.element));
                }
            }
        }

        @Override
        protected final void dispose() {
            ((Circle)this.node).radiusProperty().unbind();
        }

        private final class HighlightHandler
        implements EventHandler<MouseEvent> {
            private HighlightHandler() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final synchronized void handle(MouseEvent event) {
                event.consume();
                if (!ConceptGraph.this.toolBar.highlight.isSelected() || ConceptGraph.this.controller.isDragging()) {
                    return;
                }
                if (event.getEventType().equals(MouseEvent.MOUSE_ENTERED)) {
                    VertexHighlight vertexHighlightOption;
                    Consumer<Concept> f;
                    ConceptVertex.this.highlight();
                    if (((AttributeLabelText)((Object)ConceptGraph.this.controlBox.attributeLabelText.getSelectionModel().getSelectedItem())).equals((Object)AttributeLabelText.NONE)) {
                        f = c -> {
                            ObservableMap observableMap = ((ConceptGraph)ConceptGraph.this).layout.lattice.attributeConcepts;
                            synchronized (observableMap) {
                                for (Map.Entry e : ((ConceptGraph)ConceptGraph.this).layout.lattice.attributeConcepts.entrySet()) {
                                    if (!((Concept)e.getValue()).equals(c)) continue;
                                    new AttributeLabel(e.getKey(), (Concept)c);
                                    break;
                                }
                            }
                        };
                        vertexHighlightOption = (VertexHighlight)((Object)ConceptGraph.this.controlBox.vertexHighlight.getSelectionModel().selectedItemProperty().get());
                        switch (vertexHighlightOption) {
                            case CONCEPT: {
                                f.accept((Concept)ConceptVertex.this.element);
                                break;
                            }
                            case UPPER_NEIGHBORS: {
                                f.accept((Concept)ConceptVertex.this.element);
                                ((ConceptGraph)ConceptGraph.this).layout.lattice.upperNeighbors((Concept)ConceptVertex.this.element).forEach(f::accept);
                                break;
                            }
                            case LOWER_NEIGHBORS: {
                                f.accept((Concept)ConceptVertex.this.element);
                                ((ConceptGraph)ConceptGraph.this).layout.lattice.lowerNeighbors((Concept)ConceptVertex.this.element).forEach(f::accept);
                                break;
                            }
                            case NEIGHBORS: {
                                f.accept((Concept)ConceptVertex.this.element);
                                ((ConceptGraph)ConceptGraph.this).layout.lattice.upperNeighbors((Concept)ConceptVertex.this.element).forEach(f::accept);
                                ((ConceptGraph)ConceptGraph.this).layout.lattice.lowerNeighbors((Concept)ConceptVertex.this.element).forEach(f::accept);
                                break;
                            }
                            case FILTER: {
                                f.accept((Concept)ConceptVertex.this.element);
                                ((ConceptGraph)ConceptGraph.this).layout.lattice.filter((Concept)ConceptVertex.this.element).forEach(f::accept);
                                break;
                            }
                            case IDEAL: {
                                f.accept((Concept)ConceptVertex.this.element);
                                ((ConceptGraph)ConceptGraph.this).layout.lattice.ideal((Concept)ConceptVertex.this.element).forEach(f::accept);
                                break;
                            }
                            case FILTER_IDEAL: {
                                f.accept((Concept)ConceptVertex.this.element);
                                ((ConceptGraph)ConceptGraph.this).layout.lattice.filter((Concept)ConceptVertex.this.element).forEach(f::accept);
                                ((ConceptGraph)ConceptGraph.this).layout.lattice.ideal((Concept)ConceptVertex.this.element).forEach(f::accept);
                            }
                        }
                    }
                    if (((ObjectLabelText)((Object)ConceptGraph.this.controlBox.objectLabelText.getSelectionModel().getSelectedItem())).equals((Object)ObjectLabelText.NONE)) {
                        f = c -> {
                            ObservableMap observableMap = ((ConceptGraph)ConceptGraph.this).layout.lattice.objectConcepts;
                            synchronized (observableMap) {
                                for (Map.Entry e : ((ConceptGraph)ConceptGraph.this).layout.lattice.objectConcepts.entrySet()) {
                                    if (!((Concept)e.getValue()).equals(c)) continue;
                                    new ObjectLabel(e.getKey(), (Concept)c);
                                    break;
                                }
                            }
                        };
                        vertexHighlightOption = (VertexHighlight)((Object)ConceptGraph.this.controlBox.vertexHighlight.getSelectionModel().selectedItemProperty().get());
                        switch (vertexHighlightOption) {
                            case CONCEPT: {
                                f.accept((Concept)ConceptVertex.this.element);
                                break;
                            }
                            case UPPER_NEIGHBORS: {
                                f.accept((Concept)ConceptVertex.this.element);
                                ((ConceptGraph)ConceptGraph.this).layout.lattice.upperNeighbors((Concept)ConceptVertex.this.element).forEach(f::accept);
                                break;
                            }
                            case LOWER_NEIGHBORS: {
                                f.accept((Concept)ConceptVertex.this.element);
                                ((ConceptGraph)ConceptGraph.this).layout.lattice.lowerNeighbors((Concept)ConceptVertex.this.element).forEach(f::accept);
                                break;
                            }
                            case NEIGHBORS: {
                                f.accept((Concept)ConceptVertex.this.element);
                                ((ConceptGraph)ConceptGraph.this).layout.lattice.upperNeighbors((Concept)ConceptVertex.this.element).forEach(f::accept);
                                ((ConceptGraph)ConceptGraph.this).layout.lattice.lowerNeighbors((Concept)ConceptVertex.this.element).forEach(f::accept);
                                break;
                            }
                            case FILTER: {
                                f.accept((Concept)ConceptVertex.this.element);
                                ((ConceptGraph)ConceptGraph.this).layout.lattice.filter((Concept)ConceptVertex.this.element).forEach(f::accept);
                                break;
                            }
                            case IDEAL: {
                                f.accept((Concept)ConceptVertex.this.element);
                                ((ConceptGraph)ConceptGraph.this).layout.lattice.ideal((Concept)ConceptVertex.this.element).forEach(f::accept);
                                break;
                            }
                            case FILTER_IDEAL: {
                                f.accept((Concept)ConceptVertex.this.element);
                                ((ConceptGraph)ConceptGraph.this).layout.lattice.filter((Concept)ConceptVertex.this.element).forEach(f::accept);
                                ((ConceptGraph)ConceptGraph.this).layout.lattice.ideal((Concept)ConceptVertex.this.element).forEach(f::accept);
                            }
                        }
                    }
                    ConceptGraph.this.layout.invalidate();
                } else if (event.getEventType().equals(MouseEvent.MOUSE_EXITED)) {
                    Map map;
                    ((ConceptGraph)ConceptGraph.this).fca.contextWidget.dehighlight();
                    ConceptGraph.this.highlight(false, ConceptGraph.this.highlightRequests.dehighlight());
                    if (((AttributeLabelText)((Object)ConceptGraph.this.controlBox.attributeLabelText.getSelectionModel().getSelectedItem())).equals((Object)AttributeLabelText.NONE)) {
                        map = ConceptGraph.this.attributeLabels;
                        synchronized (map) {
                            for (AttributeLabel u : ConceptGraph.this.attributeLabels.values()) {
                                u.dispose();
                            }
                        }
                    }
                    if (((ObjectLabelText)((Object)ConceptGraph.this.controlBox.objectLabelText.getSelectionModel().getSelectedItem())).equals((Object)ObjectLabelText.NONE)) {
                        map = ConceptGraph.this.objectLabels;
                        synchronized (map) {
                            for (ObjectLabel l : ConceptGraph.this.objectLabels.values()) {
                                l.dispose();
                            }
                        }
                    }
                    ConceptGraph.this.layout.invalidate();
                }
            }
        }

        private final class DragHandler
        implements EventHandler<MouseEvent> {
            private double startX;
            private double startY;
            private ConceptMovement movement;

            private DragHandler() {
            }

            public final void handle(MouseEvent event) {
                event.consume();
                if (event.getEventType().equals(MouseEvent.MOUSE_PRESSED)) {
                    this.dragStart(event);
                } else if (event.getEventType().equals(MouseEvent.MOUSE_RELEASED)) {
                    this.dragDone(event);
                } else {
                    this.drag(event);
                }
            }

            private final void dragStart(MouseEvent event) {
                ConceptGraph.this.controller.drag();
                this.startX = event.getX();
                this.startY = event.getY();
                this.movement = event.getButton().equals((Object)MouseButton.PRIMARY) ? ConceptMovement.INTENT_CHAIN_SEEDS : ConceptMovement.LABEL_CHAIN_SEEDS;
                this.showQualityChart();
            }

            private final void drag(MouseEvent event) {
                ConceptGraph.this.layout.move((Concept)ConceptVertex.this.element, this.movement, this.getTarget(event).subtract((Point3D)ConceptVertex.this.position.getValue()));
            }

            private final void dragDone(MouseEvent event) {
                this.disposeQualityChart();
                ConceptGraph.this.controller.dragDone();
                ConceptGraph.this.layout.invalidate();
            }

            private final void showQualityChart() {
                if (!ConceptGraph.this.controlBox.conflictChart.selectedProperty().get()) {
                    return;
                }
                ConceptGraph.this.qualityEvolution = ConceptGraph.this.fca.qualityChart((Concept)ConceptVertex.this.element, this.movement);
                ConceptVertex.this.qualityChartListener = (SetChangeListener)new SetChangeListener<LayoutEvolution.Value>(){

                    public void onChanged(SetChangeListener.Change<? extends LayoutEvolution.Value> change) {
                        if (change.wasAdded()) {
                            new Graph.Tile((LayoutEvolution.Value)change.getElementAdded(), ((Circle)ConceptVertex.this.node).translateXProperty().get(), ((Circle)ConceptVertex.this.node).translateYProperty().get());
                        }
                    }
                };
                ((ConceptGraph)ConceptGraph.this).qualityEvolution.values.addListener(ConceptVertex.this.qualityChartListener);
            }

            private final void disposeQualityChart() {
                if (ConceptGraph.this.qualityEvolution == null) {
                    return;
                }
                ((ConceptGraph)ConceptGraph.this).qualityEvolution.values.removeListener(ConceptVertex.this.qualityChartListener);
                ConceptGraph.this.qualityEvolution = null;
                ConceptGraph.this.controller.clearBack();
            }

            private final Point3D getTarget(MouseEvent event) {
                Point2D p;
                if (event.getSource().equals(ConceptVertex.this.node)) {
                    p = ((Circle)ConceptVertex.this.node).localToParent(event.getX(), event.getY());
                } else {
                    StackPane content = (StackPane)event.getSource();
                    Point2D nodeP = ((Circle)ConceptVertex.this.node).localToParent(0.0, 0.0);
                    Point2D contentP = content.localToParent(this.startX, this.startY);
                    double dx = nodeP.getX() - contentP.getX();
                    double dy = nodeP.getY() - contentP.getY();
                    p = content.localToParent(event.getX(), event.getY()).add(dx, dy);
                }
                return ((Graph.Config)ConceptGraph.this.controller.config.get()).toContent(p);
            }
        }
    }
}

