/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.graph;

import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import conexp.fx.core.context.Concept;
import conexp.fx.core.context.ConceptLattice;
import conexp.fx.core.context.MatrixContext;
import conexp.fx.core.layout.ChainDecomposer;
import conexp.fx.core.math.Math3;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.geometry.Point2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.Circle;
import javafx.stage.Stage;
import org.ujmp.core.util.RandomSimple;

public class PolarGraph<G, M> {
    private final Stage primaryStage = new Stage();
    private final AnchorPane rootPane = new AnchorPane();

    public PolarGraph(ConceptLattice<G, M> lattice) {
        this.rootPane.setCenterShape(true);
        this.primaryStage.setScene(new Scene((Parent)this.rootPane, 1280.0, 800.0));
        this.initialize(lattice);
    }

    private void initialize(ConceptLattice<G, M> lattice) {
        ChainDecomposer chainDecomposer = new ChainDecomposer(((MatrixContext)lattice.context.selection._reduced.clone()).attributeQuasiOrder().neighborhood());
        RandomSimple rng = new RandomSimple();
        HashMap<Set<Object>, Point2D> seeds = new HashMap<Set<Object>, Point2D>();
        HashMap<Concept, Point2D> positions = new HashMap<Concept, Point2D>();
        Set chains = chainDecomposer.randomChainDecomposition();
        int w = chains.size();
        if (w == 1) {
            Point2D seed = new Point2D(1.0, 0.0);
            for (Set<Object> m : Collections2.transform((Collection)((Collection)Iterables.getOnlyElement(chains)), lattice.context.selection._firstAttribute)) {
                seeds.put(m, seed);
            }
        } else {
            int i = 0;
            for (Set chain : chains) {
                Point2D seed = new Point2D(1.0, (double)i / (double)w * 2.0 * Math.PI);
                for (Object m : Collections2.transform(chain, lattice.context.selection._firstAttribute)) {
                    seeds.put((Set<Object>)m, seed);
                }
                ++i;
            }
        }
        for (Concept concept : lattice.rowHeads()) {
            if (concept.equals(lattice.context.bottomConcept())) continue;
            positions.put(concept, PolarPoints.polarSum(seeds.entrySet().stream().filter(e -> concept.intent().contains(e.getKey())).map(e -> (Point2D)e.getValue()).collect(Collectors.toList())));
        }
        positions.values().forEach(this::addCircleAt);
        for (Concept c1 : lattice.rowHeads()) {
            if (c1.equals(lattice.context.bottomConcept())) continue;
            for (Concept c2 : lattice.col(c1)) {
                if (c2.equals(lattice.context.bottomConcept())) continue;
                this.drawLine((Point2D)positions.get(c1), (Point2D)positions.get(c2));
            }
        }
    }

    private final void drawLine(Point2D p, Point2D q) {
        Point2D _p = this.transform(p);
        Point2D _q = this.transform(q);
        Arc e = new Arc(this.rootPane.getWidth() / 2.0, this.rootPane.getHeight() / 2.0, 100.0 * p.getX(), 100.0 * q.getX(), p.getY(), q.getY() - p.getY());
        this.rootPane.getChildren().add((Object)e);
    }

    private final void addCircleAt(Point2D p) {
        Point2D q = this.transform(p);
        this.rootPane.getChildren().add((Object)new Circle(q.getX(), q.getY(), 10.0, (Paint)Color.CHARTREUSE));
    }

    private Point2D transform(Point2D p) {
        Point2D q = PolarPoints.toCartesian(p);
        return new Point2D(this.rootPane.getWidth() / 2.0 + 100.0 * q.getX(), this.rootPane.getHeight() / 2.0 + 100.0 * q.getY());
    }

    public final void show() {
        this.primaryStage.show();
    }

    public static final class PolarPoints {
        public static final double angleDistance(double a, double b) {
            return Math.min(Math3.modulo(a - b, 360.0), Math3.modulo(b - a, 360.0));
        }

        public static final double averageAngle(double a, double b) {
            double _b;
            if (a == b) {
                return a;
            }
            double _a = Math3.modulo(a, 360.0);
            if (_a == (_b = Math3.modulo(b, 360.0))) {
                return _a;
            }
            double d = PolarPoints.angleDistance(_a, _b) / 2.0;
            if (Math3.modulo(_b - _a, 360.0) < Math3.modulo(_a - _b, 360.0)) {
                return Math3.modulo(_a + d, 360.0);
            }
            return Math3.modulo(_b + d, 360.0);
        }

        public static final Point2D polarSum(Point2D ... ps) {
            return PolarPoints.polarSum(Arrays.asList(ps));
        }

        public static final Point2D polarSum(Collection<Point2D> ps) {
            double r = ps.stream().map(p -> p.getX()).reduce(0.0, Double::sum);
            double a = PolarPoints.toPolar(ps.stream().map(PolarPoints::toCartesian).reduce(new Point2D(0.0, 0.0), (p, q) -> p.add(q))).getY();
            return new Point2D(r, a);
        }

        public static final Point2D toPolar(Point2D q) {
            double r = Math.sqrt(q.getX() * q.getX() + q.getY() * q.getY());
            double a = Math.atan2(q.getX(), q.getY());
            return new Point2D(r, a);
        }

        public static final Point2D toCartesian(Point2D p) {
            double x = p.getX() * Math.sin(p.getY());
            double y = p.getX() * Math.cos(p.getY());
            return new Point2D(x, y);
        }
    }
}

