/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.graph.option;

import javafx.util.Duration;

public enum AnimationSpeed {
    OFF(0, "Off"),
    FASTESTEST(1, "Fastestest"),
    FASTESTER(2, "Fastester"),
    FASTEST(3, "Fastest"),
    FASTER(5, "Faster"),
    FAST(7, "Fast"),
    DEFAULT(10, "Default"),
    SLOW(14, "Slow"),
    SLOWER(19, "Slower"),
    SLOWEST(25, "Slowest"),
    SLOWESTER(32, "Slowester"),
    SLOWESTEST(40, "Slowestest");

    public final int n;
    public final String title;
    public final Duration frameSize;

    private AnimationSpeed(int n2, String title) throws IllegalArgumentException {
        this.n = n2;
        this.title = title;
        if (n2 < 0) {
            throw new IllegalArgumentException("Unable to set negative frame size.");
        }
        this.frameSize = n2 == 0 ? Duration.ONE : Duration.millis((double)(10.0 * (double)n2));
    }

    public String toString() {
        return this.title;
    }
}

