/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.task;

import conexp.fx.core.math.Math3;
import conexp.fx.gui.task.BlockingExecutor;
import conexp.fx.gui.task.TimeTask;
import conexp.fx.gui.util.Platform2;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBuilder;
import javafx.scene.control.Label;
import javafx.scene.control.LabelBuilder;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressBarBuilder;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.ProgressIndicatorBuilder;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.BorderPaneBuilder;
import javafx.scene.layout.HBox;

public final class ExecutorStatusBar {
    private BlockingExecutor executor;
    public final BorderPane statusBar;
    private final int height = 20;
    private final int padding = 2;
    private final ProgressIndicator overallProgressIndicator = ((ProgressIndicatorBuilder)((ProgressIndicatorBuilder)((ProgressIndicatorBuilder)((ProgressIndicatorBuilder)ProgressIndicatorBuilder.create().minHeight(16.0)).maxHeight(16.0)).minWidth(16.0)).maxWidth(16.0)).build();
    private final ProgressBar overallProgressBar = ((ProgressBarBuilder)((ProgressBarBuilder)((ProgressBarBuilder)((ProgressBarBuilder)ProgressBarBuilder.create().minHeight(16.0)).maxHeight(16.0)).minWidth(200.0)).maxWidth(200.0)).build();
    private final Label overallStatusLabel = ((LabelBuilder)((LabelBuilder)((LabelBuilder)LabelBuilder.create().graphic((Node)this.overallProgressIndicator)).minHeight(16.0)).maxHeight(16.0)).build();
    private final ListView<TimeTask<?>> scheduledTaskListView;

    public ExecutorStatusBar(AnchorPane overlayPane) {
        BorderPane overallPane = BorderPaneBuilder.create().left((Node)this.overallStatusLabel).right((Node)this.overallProgressBar).build();
        this.statusBar = ((BorderPaneBuilder)((BorderPaneBuilder)((BorderPaneBuilder)BorderPaneBuilder.create().padding(new Insets(2.0, 2.0, 2.0, 2.0))).minHeight(20.0)).maxHeight(20.0)).right((Node)overallPane).build();
        this.scheduledTaskListView = new ListView();
        this.scheduledTaskListView.setPrefSize(800.0, 200.0);
        this.scheduledTaskListView.setCellFactory(l -> {
            ListCell cell = new ListCell<TimeTask<?>>(){
                private final TaskItem taskItem;
                {
                    this.taskItem = new TaskItem();
                }

                protected void updateItem(TimeTask<?> p, boolean empty) {
                    if (empty) {
                        return;
                    }
                    this.taskItem.bindTo(p);
                    this.setGraphic((Node)this.taskItem.currentPane);
                }
            };
            return cell;
        });
        overallPane.setOnMouseEntered(e -> {
            overlayPane.setMouseTransparent(false);
            if (overlayPane.getChildren().contains(this.scheduledTaskListView)) {
                return;
            }
            overlayPane.getChildren().add(this.scheduledTaskListView);
            AnchorPane.setRightAnchor(this.scheduledTaskListView, (Double)4.0);
            AnchorPane.setBottomAnchor(this.scheduledTaskListView, (Double)4.0);
        });
        this.scheduledTaskListView.setOnMouseExited(e -> {
            overlayPane.setMouseTransparent(true);
            overlayPane.getChildren().clear();
        });
    }

    public final void setOnMouseExitedHandler(Scene scene) {
        scene.setOnMouseExited(this.scheduledTaskListView.getOnMouseExited());
    }

    public void bindTo(final BlockingExecutor executor) {
        this.executor = executor;
        this.scheduledTaskListView.setItems(executor.scheduledTasks);
        this.scheduledTaskListView.scrollTo(executor.currentTaskProperty.getValue());
        this.overallProgressIndicator.progressProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> executor.overallProgressBinding.get() != 1.0 ? -1.0 : 1.0, (Observable[])new Observable[]{executor.overallProgressBinding}));
        this.overallProgressIndicator.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !executor.isIdleBinding.get(), (Observable[])new Observable[]{executor.isIdleBinding}));
        executor.currentTaskProperty.addListener(new ChangeListener<TimeTask<?>>(){

            public final void changed(ObservableValue<? extends TimeTask<?>> observable, TimeTask<?> oldTask, TimeTask<?> newTask) {
                Platform2.runOnFXThread(() -> {
                    ExecutorStatusBar.this.scheduledTaskListView.scrollTo((Object)newTask);
                    ExecutorStatusBar.this.overallStatusLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> executor2.isIdleBinding.get() ? "" : (String)newTask.titleProperty().get() + (((String)newTask.messageProperty().get()).equals("") ? "" : ": " + (String)newTask.messageProperty().get()), (Observable[])new Observable[]{executor2.isIdleBinding, newTask.messageProperty(), newTask.titleProperty()}));
                });
            }
        });
        this.overallProgressBar.progressProperty().bind((ObservableValue)executor.overallProgressBinding);
    }

    private final class TaskItem {
        private final ProgressBar currentProgressBar = ((ProgressBarBuilder)((ProgressBarBuilder)((ProgressBarBuilder)((ProgressBarBuilder)ProgressBarBuilder.create().minHeight(16.0)).maxHeight(16.0)).minWidth(100.0)).maxWidth(100.0)).build();
        private final Label currentStatusLabel = ((LabelBuilder)((LabelBuilder)((LabelBuilder)((LabelBuilder)LabelBuilder.create().minWidth(554.0)).maxWidth(554.0)).minHeight(16.0)).maxHeight(16.0)).build();
        private final Label timeLabel = ((LabelBuilder)((LabelBuilder)((LabelBuilder)((LabelBuilder)LabelBuilder.create().minWidth(100.0)).maxWidth(100.0)).minHeight(16.0)).maxHeight(16.0)).build();
        private final Button stopButton = ((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)((ButtonBuilder)ButtonBuilder.create().style("-fx-base: red")).maxHeight(12.0)).maxWidth(12.0)).minHeight(12.0)).minWidth(12.0)).build();
        private final BorderPane currentPane = new BorderPane();

        public TaskItem() {
            this.currentPane.setLeft((Node)this.currentStatusLabel);
            this.currentPane.setCenter((Node)new HBox(new Node[]{this.currentProgressBar, this.stopButton}));
            this.currentPane.setRight((Node)this.timeLabel);
            this.currentProgressBar.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
        }

        private final void bindTo(TimeTask<?> task) {
            this.currentStatusLabel.textProperty().bind((ObservableValue)task.titleProperty());
            this.timeLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> task.isCancelled() ? "cancelled" : Math3.formatNanos(task.runTimeNanosProperty().get()), (Observable[])new Observable[]{task.runTimeNanosProperty(), task.stateProperty()}));
            this.timeLabel.alignmentProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> task.isDone() || task.isRunning() ? Pos.BASELINE_RIGHT : Pos.BASELINE_LEFT, (Observable[])new Observable[]{task.stateProperty()}));
            this.currentProgressBar.progressProperty().bind((ObservableValue)task.progressProperty());
            this.stopButton.setOnAction(e -> task.cancel(true));
            this.stopButton.visibleProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> !task.isDone(), (Observable[])new Observable[]{task.stateProperty()}));
        }
    }
}

