/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.util;

import conexp.fx.gui.ConExpFX;
import java.util.Arrays;
import java.util.List;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ChoiceBoxBuilder;
import javafx.scene.control.MenuItem;
import javafx.scene.control.MenuItemBuilder;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.text.Text;
import jfxtras.scene.control.ListSpinner;

public final class FXControls {
    public static final ImageView newImageView(String image) {
        return new ImageView(new Image(ConExpFX.class.getResourceAsStream(image)));
    }

    public static final MenuItem newMenuItem(String text, String image, EventHandler<ActionEvent> onAction) {
        return MenuItemBuilder.create().text(text).graphic((Node)FXControls.newImageView(image)).onAction(onAction).build();
    }

    public static final MenuItem newMenuItem(String text, String image, boolean disable, EventHandler<ActionEvent> onAction) {
        return MenuItemBuilder.create().text(text).graphic((Node)FXControls.newImageView(image)).disable(disable).onAction(onAction).build();
    }

    public static final Text newText(StringBinding textBinding) {
        Text text = new Text();
        text.textProperty().bind((ObservableValue)textBinding);
        return text;
    }

    public static final <E> ListSpinner<E> newListSpinner(E initial, List<E> values) {
        return new ListSpinner(FXCollections.observableList(values), initial);
    }

    public static final <E> ListSpinner<E> newListSpinner(E initial, E ... values) {
        return FXControls.newListSpinner(initial, Arrays.asList(values));
    }

    public static final <E> ChoiceBox<E> newChoiceBox(E initial, List<E> values) {
        return ((ChoiceBoxBuilder)((ChoiceBoxBuilder)ChoiceBoxBuilder.create().items(FXCollections.observableList(values)).value(initial).minWidth(150.0)).maxWidth(150.0)).build();
    }

    public static final <E> ChoiceBox<E> newChoiceBox(E initial, E ... values) {
        return FXControls.newChoiceBox(initial, Arrays.asList(values));
    }
}

