/*
 * Decompiled with CFR 0.152.
 */
package conexp.fx.gui.util;

import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;

public final class Platform2 {
    public static final void runOnFXThread(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            Platform.runLater((Runnable)runnable);
        }
    }

    public static final void runOnFXThreadAndWait(Runnable runnable) throws InterruptedException {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            CountDownLatch cdl = new CountDownLatch(1);
            Platform.runLater(() -> {
                runnable.run();
                cdl.countDown();
            });
            cdl.await();
        }
    }

    public static final void runOnFXThreadAndWaitTryCatch(Runnable runnable) {
        try {
            Platform2.runOnFXThreadAndWait(runnable);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

